/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.types.AbstractSpecializedType;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCollectionType
extends AbstractSpecializedType
implements DomainCollectionType {
    @NonNull
    protected final DomainType elementType;
    @NonNull
    protected final IntegerValue lower;
    @NonNull
    protected final IntegerValue upper;
    @NonNull
    protected final CollectionTypeId typeId;

    public AbstractCollectionType(@NonNull DomainStandardLibrary standardLibrary, @NonNull String name, @NonNull DomainType containerType, @NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        super(standardLibrary, name, containerType);
        this.elementType = elementType;
        this.lower = lower != null ? lower : ValuesUtil.ZERO_VALUE;
        this.upper = upper != null ? upper : ValuesUtil.UNLIMITED_VALUE;
        this.typeId = IdManager.getCollectionTypeId(name).getSpecializedId(elementType.getTypeId());
    }

    @Override
    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainCollectionType)) {
            return false;
        }
        return standardLibrary.conformsToCollectionType(this, (DomainCollectionType)type);
    }

    @Override
    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        if (!(type instanceof AbstractCollectionType)) {
            return this.standardLibrary.getOclAnyType();
        }
        AbstractCollectionType thatClass = (AbstractCollectionType)type;
        DomainType commonContainerClass = this.containerType;
        DomainType commonElementClass = this.elementType.getCommonType(idResolver, thatClass.getElementType());
        if (commonContainerClass == this.containerType && commonElementClass == this.elementType) {
            return this;
        }
        if (commonContainerClass == thatClass.containerType && commonElementClass == thatClass.elementType) {
            return thatClass;
        }
        if (commonContainerClass.isOrdered()) {
            if (commonContainerClass.isUnique()) {
                return this.standardLibrary.getOrderedSetType(commonElementClass, null, null);
            }
            return this.standardLibrary.getSequenceType(commonElementClass, null, null);
        }
        if (commonContainerClass.isUnique()) {
            return this.standardLibrary.getSetType(commonElementClass, null, null);
        }
        return this.standardLibrary.getBagType(commonElementClass, null, null);
    }

    @Override
    public DomainType getContainerType() {
        return this.containerType;
    }

    @Override
    @NonNull
    public DomainType getElementType() {
        return this.elementType;
    }

    @Override
    @NonNull
    public IntegerValue getLowerValue() {
        return this.lower;
    }

    @Override
    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        return this.containerType.getOwnedOperation();
    }

    @Override
    @NonNull
    public CollectionTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    @NonNull
    public IntegerValue getUpperValue() {
        return this.upper;
    }

    @Override
    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainCollectionType)) {
            return false;
        }
        return standardLibrary.isEqualToCollectionType(this, (DomainCollectionType)type);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.containerType)) + "(" + String.valueOf(this.elementType) + ")";
    }
}

