/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;

public abstract class AbstractPolyOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List<? extends DomainExpression> arguments = callExp.getArgument();
        if (arguments.size() == 0) {
            return this.evaluate(evaluator, typeId, sourceValue);
        }
        DomainExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = evaluator.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument);
        }
        DomainExpression argument1 = arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = evaluator.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument, secondArgument);
        }
        Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            DomainExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, typeId, sourceValue, argumentValues);
    }
}

