/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.ids.BindingsId;
import org.eclipse.ocl.examples.domain.ids.ClassId;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdHash;
import org.eclipse.ocl.examples.domain.ids.LambdaTypeId;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.impl.BindingsIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.GeneralizedCollectionTypeIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.GeneralizedLambdaTypeIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.GeneralizedTupleTypeIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.NsURIPackageIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.ParametersIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.PrimitiveTypeIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.RootPackageIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.TemplateParameterIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.TuplePartIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.UnspecifiedIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfListOfWeakReference2;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfListOfWeakReference3;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfListOfWeakReference4;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfWeakReference;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdManager {
    @NonNull
    private static IdManager PRIVATE_INSTANCE;
    @Deprecated
    @NonNull
    public static IdManager INSTANCE;
    @Nullable
    private static WeakHashMapOfListOfWeakReference2<Integer, ElementId[], BindingsIdImpl> bindingsIds;
    @NonNull
    private static WeakHashMapOfWeakReference<String, CollectionTypeId> collectionNames;
    @NonNull
    private static WeakHashMapOfWeakReference<String, NsURIPackageId> nsURIs;
    @Nullable
    private static WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl> lambdaTypes;
    @Nullable
    private static WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl> tupleParts;
    @NonNull
    private static WeakHashMapOfWeakReference<String, RootPackageId> roots;
    @NonNull
    private static List<TemplateParameterId> templateParameters;
    @Nullable
    private static WeakHashMapOfListOfWeakReference3<Integer, String, TuplePartId[], GeneralizedTupleTypeIdImpl> tupleTypes;
    @Nullable
    private static WeakHashMapOfListOfWeakReference2<Integer, TypeId[], ParametersIdImpl> parametersIds;
    @NonNull
    private static WeakHashMapOfWeakReference<String, PrimitiveTypeId> primitiveTypes;

    static {
        INSTANCE = PRIVATE_INSTANCE = new IdManager();
        collectionNames = new WeakHashMapOfWeakReference<String, CollectionTypeId>(){

            @Override
            @NonNull
            protected CollectionTypeId newId(@NonNull String name) {
                return new GeneralizedCollectionTypeIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        nsURIs = new WeakHashMapOfWeakReference<String, NsURIPackageId>(){

            @Override
            @NonNull
            protected NsURIPackageId newId(@NonNull String nsURI) {
                return new NsURIPackageIdImpl(PRIVATE_INSTANCE, nsURI, null, null);
            }
        };
        lambdaTypes = null;
        tupleParts = null;
        roots = new WeakHashMapOfWeakReference<String, RootPackageId>(){

            @Override
            @NonNull
            protected RootPackageId newId(@NonNull String name) {
                return new RootPackageIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        templateParameters = new ArrayList<TemplateParameterId>(10);
        tupleTypes = null;
        primitiveTypes = new WeakHashMapOfWeakReference<String, PrimitiveTypeId>(){

            @Override
            @NonNull
            protected PrimitiveTypeId newId(@NonNull String name) {
                return new PrimitiveTypeIdImpl(PRIVATE_INSTANCE, name);
            }
        };
    }

    @NonNull
    public static BindingsId getBindingsId(DomainType ... types) {
        ElementId[] elementIds = new ElementId[types.length];
        int i = 0;
        while (i < types.length) {
            elementIds[i] = types[i].getTypeId();
            ++i;
        }
        return IdManager.getBindingsId(elementIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static BindingsId getBindingsId(ElementId ... elementIds) {
        WeakHashMapOfListOfWeakReference2<Integer, ElementId[], BindingsIdImpl> bindingsIds2 = bindingsIds;
        if (bindingsIds2 == null) {
            Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.examples.domain.ids.IdManager.class
            bindingsIds2 = bindingsIds;
            if (bindingsIds2 == null) {
                bindingsIds = bindingsIds2 = new WeakHashMapOfListOfWeakReference2<Integer, ElementId[], BindingsIdImpl>(){

                    @Override
                    @NonNull
                    protected BindingsIdImpl newId(@NonNull Integer hashCode, @NonNull ElementId[] elementIds) {
                        return new BindingsIdImpl(PRIVATE_INSTANCE, hashCode, elementIds);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        Integer hashCode = IdHash.createParametersHash(BindingsId.class, elementIds);
        return bindingsIds2.getId(hashCode, elementIds);
    }

    @NonNull
    public static ClassId getClassId(@NonNull DomainType aType) {
        String name = aType.getName();
        assert (name != null);
        DomainPackage parentPackage = aType.getPackage();
        if (parentPackage != null) {
            DomainTypeParameters typeParameters = aType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            return packageId.getClassId(name, typeParameters.parametersSize());
        }
        return IdManager.getUnspecifiedTypeId(aType);
    }

    @NonNull
    public static CollectionTypeId getCollectionTypeId(@NonNull String collectionTypeName) {
        return collectionNames.getId(collectionTypeName);
    }

    @NonNull
    public static DataTypeId getDataTypeId(@NonNull DomainType aType) {
        String name = aType.getName();
        assert (name != null);
        DomainPackage parentPackage = aType.getPackage();
        if (parentPackage != null) {
            DomainTypeParameters typeParameters = aType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            return packageId.getDataTypeId(name, typeParameters.parametersSize());
        }
        return new UnspecifiedIdImpl(PRIVATE_INSTANCE, aType);
    }

    @NonNull
    public static EnumerationId getEnumerationId(@NonNull DomainEnumeration anEnumeration) {
        String name = anEnumeration.getName();
        assert (name != null);
        DomainPackage parentPackage = anEnumeration.getPackage();
        assert (parentPackage != null);
        return parentPackage.getPackageId().getEnumerationId(name);
    }

    @NonNull
    public static EnumerationId getEnumerationId(@NonNull EEnum eEnum) {
        String name = eEnum.getName();
        assert (name != null);
        EPackage parentPackage = eEnum.getEPackage();
        assert (parentPackage != null);
        return IdManager.getPackageId(parentPackage).getEnumerationId(name);
    }

    @NonNull
    public static EnumerationLiteralId getEnumerationLiteralId(@NonNull EEnumLiteral eEnumLiteral) {
        EEnum eEnum = DomainUtil.nonNullModel(eEnumLiteral.getEEnum());
        String name = DomainUtil.nonNullModel(eEnumLiteral.getName());
        EnumerationId enumerationId = IdManager.getEnumerationId(eEnum);
        EnumerationLiteralId enumerationLiteralId = enumerationId.getEnumerationLiteralId(name);
        return enumerationLiteralId;
    }

    @NonNull
    public static LambdaTypeId getLambdaTypeId(@NonNull DomainLambdaType lambdaType) {
        String name = DomainUtil.getSafeName(lambdaType);
        return IdManager.getLambdaTypeId(name, lambdaType.getParametersId());
    }

    @NonNull
    public static LambdaTypeId getLambdaTypeId(@NonNull String name, TypeId ... typeIds) {
        return IdManager.getLambdaTypeId(name, IdManager.getParametersId(typeIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static LambdaTypeId getLambdaTypeId(@NonNull String name, @NonNull ParametersId parametersId) {
        WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl> lambdaTypes2 = lambdaTypes;
        if (lambdaTypes2 == null) {
            Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.examples.domain.ids.IdManager.class
            lambdaTypes2 = lambdaTypes;
            if (lambdaTypes2 == null) {
                lambdaTypes = lambdaTypes2 = new WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl>(){

                    @Override
                    @NonNull
                    protected GeneralizedLambdaTypeIdImpl newId(@NonNull Integer hashCode, @NonNull String name, @NonNull ParametersId parametersId) {
                        return new GeneralizedLambdaTypeIdImpl(hashCode, name, parametersId);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        int childHash = IdHash.createGlobalHash(LambdaTypeId.class, name);
        Integer hashCode = childHash + parametersId.hashCode();
        return (LambdaTypeId)lambdaTypes2.getId(hashCode, name, parametersId);
    }

    @Deprecated
    @NonNull
    public static NsURIPackageId getNsURIPackageId(@NonNull String nsURI, @Nullable EPackage ePackage) {
        return IdManager.getNsURIPackageId(nsURI, null, ePackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static NsURIPackageId getNsURIPackageId(@NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
        NsURIPackageId oldTypeId;
        WeakReference ref = (WeakReference)nsURIs.get(nsURI);
        if (ref != null && (oldTypeId = (NsURIPackageId)ref.get()) != null) {
            if (ePackage != null && oldTypeId.getEPackage() == null) {
                oldTypeId.setEPackage(ePackage);
            }
            return oldTypeId;
        }
        WeakHashMapOfWeakReference<String, NsURIPackageId> weakHashMapOfWeakReference = nsURIs;
        synchronized (weakHashMapOfWeakReference) {
            NsURIPackageId oldTypeId2;
            ref = (WeakReference)nsURIs.get(nsURI);
            if (ref != null && (oldTypeId2 = (NsURIPackageId)ref.get()) != null) {
                return oldTypeId2;
            }
            NsURIPackageIdImpl newTypeId = new NsURIPackageIdImpl(PRIVATE_INSTANCE, nsURI, nsPrefix, ePackage);
            nsURIs.put(nsURI, (NsURIPackageId)((Object)new WeakReference<NsURIPackageIdImpl>(newTypeId)));
            return newTypeId;
        }
    }

    @NonNull
    public static OperationId getOperationId(@NonNull DomainOperation anOperation) {
        String name = DomainUtil.getSafeName(anOperation);
        DomainType parentType = anOperation.getOwningType();
        TypeId parentTypeId = parentType.getTypeId();
        DomainType[] parameterTypes = DomainUtil.getOperationParameterTypes(anOperation);
        DomainTypeParameters typeParameters = anOperation.getTypeParameters();
        ParametersId parametersId = IdManager.getParametersId(parameterTypes);
        return parentTypeId.getOperationId(typeParameters.parametersSize(), name, parametersId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static TupleTypeId getOrderedTupleTypeId(@NonNull String name, @NonNull TuplePartId[] parts) {
        WeakHashMapOfListOfWeakReference3<Integer, String, TuplePartId[], GeneralizedTupleTypeIdImpl> tupleTypes2 = tupleTypes;
        if (tupleTypes2 == null) {
            Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.examples.domain.ids.IdManager.class
            tupleTypes2 = tupleTypes;
            if (tupleTypes2 == null) {
                tupleTypes = tupleTypes2 = new WeakHashMapOfListOfWeakReference3<Integer, String, TuplePartId[], GeneralizedTupleTypeIdImpl>(){

                    @Override
                    @NonNull
                    protected GeneralizedTupleTypeIdImpl newId(@NonNull Integer hashCode, @NonNull String name, @NonNull TuplePartId[] parts) {
                        return new GeneralizedTupleTypeIdImpl(PRIVATE_INSTANCE, hashCode, name, parts);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        int hash = IdHash.createTupleHash(name, parts);
        return tupleTypes2.getId(hash, name, parts);
    }

    @NonNull
    public static PackageId getPackageId(@NonNull DomainPackage aPackage) {
        String nsURI = aPackage.getNsURI();
        if (nsURI != null) {
            return IdManager.getNsURIPackageId(nsURI, aPackage.getNsPrefix(), aPackage.getEPackage());
        }
        String name = aPackage.getName();
        assert (name != null);
        DomainPackage parentPackage = aPackage.getNestingPackage();
        if (parentPackage != null) {
            return parentPackage.getPackageId().getNestedPackageId(name);
        }
        return IdManager.getRootPackageId(name);
    }

    @NonNull
    public static PackageId getPackageId(@NonNull EPackage aPackage) {
        String nsURI = aPackage.getNsURI();
        if (nsURI != null) {
            return IdManager.getNsURIPackageId(nsURI, aPackage.getNsPrefix(), aPackage);
        }
        String name = aPackage.getName();
        assert (name != null);
        EPackage parentPackage = aPackage.getESuperPackage();
        if (parentPackage != null) {
            return IdManager.getPackageId(parentPackage).getNestedPackageId(name);
        }
        return IdManager.getNsURIPackageId(name, aPackage.getNsPrefix(), null);
    }

    @NonNull
    public static ParametersId getParametersId(@NonNull DomainType[] parameterTypes) {
        int iSize = parameterTypes.length;
        TypeId[] typeIds = new TypeId[iSize];
        int i = 0;
        while (i < iSize) {
            DomainType parameterType = parameterTypes[i];
            typeIds[i] = parameterType != null ? parameterType.getTypeId() : TypeId.OCL_INVALID;
            ++i;
        }
        return IdManager.getParametersId(typeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static ParametersId getParametersId(TypeId ... typeIds) {
        WeakHashMapOfListOfWeakReference2<Integer, TypeId[], ParametersIdImpl> parametersIds2 = parametersIds;
        if (parametersIds2 == null) {
            Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.examples.domain.ids.IdManager.class
            parametersIds2 = parametersIds;
            if (parametersIds2 == null) {
                parametersIds = parametersIds2 = new WeakHashMapOfListOfWeakReference2<Integer, TypeId[], ParametersIdImpl>(){

                    @Override
                    @NonNull
                    protected ParametersIdImpl newId(@NonNull Integer hashCode, @NonNull TypeId[] typeIds) {
                        return new ParametersIdImpl(PRIVATE_INSTANCE, hashCode, typeIds);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        Integer hashCode = IdHash.createParametersHash(ParametersId.class, typeIds);
        return parametersIds2.getId(hashCode, typeIds);
    }

    @NonNull
    public static PrimitiveTypeId getPrimitiveTypeId(@NonNull String name) {
        return primitiveTypes.getId(name);
    }

    @NonNull
    public static PropertyId getPropertyId(@NonNull EStructuralFeature eFeature) {
        String name = eFeature.getName();
        assert (name != null);
        EClass parentClass = eFeature.getEContainingClass();
        assert (parentClass != null);
        TypeId typeId = IdManager.getTypeId((EClassifier)parentClass);
        return typeId.getPropertyId(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static RootPackageId getRootPackageId(@NonNull String name) {
        RootPackageId oldTypeId;
        WeakReference ref = (WeakReference)roots.get(name);
        if (ref != null && (oldTypeId = (RootPackageId)ref.get()) != null) {
            return oldTypeId;
        }
        WeakHashMapOfWeakReference<String, RootPackageId> weakHashMapOfWeakReference = roots;
        synchronized (weakHashMapOfWeakReference) {
            RootPackageId oldTypeId2;
            ref = (WeakReference)roots.get(name);
            if (ref != null && (oldTypeId2 = (RootPackageId)ref.get()) != null) {
                return oldTypeId2;
            }
            RootPackageIdImpl newTypeId = new RootPackageIdImpl(PRIVATE_INSTANCE, name);
            roots.put(name, (RootPackageId)((Object)new WeakReference<RootPackageIdImpl>(newTypeId)));
            return newTypeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static TemplateParameterId getTemplateParameterId(int index) {
        if (index >= templateParameters.size()) {
            List<TemplateParameterId> list = templateParameters;
            synchronized (list) {
                while (index >= templateParameters.size()) {
                    templateParameters.add(new TemplateParameterIdImpl(PRIVATE_INSTANCE, templateParameters.size()));
                }
            }
        }
        TemplateParameterId templateParameterId = templateParameters.get(index);
        assert (templateParameterId != null);
        return templateParameterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static TuplePartId getTuplePartId(int index, @NonNull String name, @NonNull TypeId typeId) {
        WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl> tupleParts2 = tupleParts;
        if (tupleParts2 == null) {
            Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.examples.domain.ids.IdManager.class
            tupleParts2 = tupleParts;
            if (tupleParts2 == null) {
                tupleParts = tupleParts2 = new WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl>(){

                    @Override
                    @NonNull
                    protected TuplePartIdImpl newId(@NonNull Integer hashCode, @NonNull Integer index, @NonNull String name, @NonNull TypeId typeId) {
                        return new TuplePartIdImpl(PRIVATE_INSTANCE, hashCode, index, name, typeId);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        Integer hashCode = name.hashCode() + 7 * typeId.hashCode() + 989 * index;
        return (TuplePartId)tupleParts2.getId(hashCode, index, name, typeId);
    }

    @NonNull
    public static TupleTypeId getTupleTypeId(@NonNull String name, @NonNull Collection<? extends TuplePartId> parts) {
        Object[] orderedParts = new TuplePartId[parts.size()];
        int i = 0;
        for (TuplePartId tuplePartId : parts) {
            orderedParts[i++] = tuplePartId;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    @NonNull
    public static TupleTypeId getTupleTypeId(@NonNull String name, TuplePartId ... parts) {
        Object[] orderedParts = new TuplePartId[parts.length];
        int i = 0;
        TuplePartId[] tuplePartIdArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId part = tuplePartIdArray[n2];
            orderedParts[i++] = part;
            ++n2;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    @NonNull
    public static TypeId getTypeId(@NonNull EClassifier eClassifier) {
        String name = eClassifier.getName();
        assert (name != null);
        EPackage parentPackage = eClassifier.getEPackage();
        assert (parentPackage != null);
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters != null);
        PackageId packageId = IdManager.getPackageId(parentPackage);
        int eTypeParameterCount = eTypeParameters.size();
        if (eClassifier instanceof EEnum) {
            return packageId.getEnumerationId(name);
        }
        if (eClassifier instanceof EDataType) {
            return packageId.getDataTypeId(name, eTypeParameterCount);
        }
        return packageId.getClassId(name, eTypeParameterCount);
    }

    @NonNull
    public static UnspecifiedIdImpl getUnspecifiedTypeId(@NonNull DomainType aType) {
        UnspecifiedIdImpl newId = new UnspecifiedIdImpl(PRIVATE_INSTANCE, aType);
        return newId;
    }

    private IdManager() {
    }
}

