/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.standard.ExtensionLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredProfileAsLibrarySelectionDialog
extends ElementListSelectionDialog {
    private EList<PackageImport> importedProfiles;
    private List<String> importedProfilesNames;
    private IRegisteredProfile[] regProfiles;
    private Package currentPackage;

    public RegisteredProfileAsLibrarySelectionDialog(Composite parent, Package umlPackage) {
        super(parent.getShell(), (ILabelProvider)new ExtensionLabelProvider());
        this.currentPackage = umlPackage;
        this.importedProfiles = umlPackage.getPackageImports();
        this.importedProfilesNames = this.getImportedProfileNames(this.importedProfiles);
        this.regProfiles = Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]);
        this.regProfiles = this.removeAlreadyImportedFromSelection();
        this.setTitle("Apply profiles from Papyrus repository :");
        this.setElements(this.regProfiles);
    }

    public boolean run() {
        this.open();
        return this.treatSelection();
    }

    private List<String> getImportedProfileNames(EList<? extends PackageImport> importedProfiles) {
        ArrayList<String> Libraries = new ArrayList<String>();
        for (PackageImport currentImport : importedProfiles) {
            String currentName = currentImport.getImportedPackage().getName();
            Libraries.add(currentName);
        }
        return Libraries;
    }

    private IRegisteredProfile[] removeAlreadyImportedFromSelection() {
        ArrayList<IRegisteredProfile> profiles = new ArrayList<IRegisteredProfile>();
        int i = 0;
        while (i < this.regProfiles.length) {
            String currentName = this.regProfiles[i].getName();
            if (!this.importedProfilesNames.contains(currentName)) {
                profiles.add(this.regProfiles[i]);
            }
            ++i;
        }
        IRegisteredProfile[] cleandList = profiles.toArray(new IRegisteredProfile[profiles.size()]);
        return cleandList;
    }

    private boolean treatSelection() {
        Object[] selection = this.getResult();
        boolean hasChanged = false;
        if (selection == null) {
            return hasChanged;
        }
        int i = 0;
        while (i < selection.length) {
            IRegisteredProfile currentProfile = (IRegisteredProfile)selection[i];
            URI modelUri = currentProfile.getUri();
            PackageImport pi = this.getModelLibraryImportFromURI(modelUri);
            if (pi != null) {
                this.currentPackage.getPackageImports().add((Object)pi);
            }
            ++i;
        }
        return hasChanged;
    }

    public PackageImport getModelLibraryImportFromURI(URI uri) {
        ResourceSet resourceSet = EMFHelper.getResourceSet((EObject)this.currentPackage);
        Resource modelResource = resourceSet.getResource(uri, true);
        if (modelResource.getContents().size() <= 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.extensionpoints", "No element found in model from URI " + uri.toString()));
            return null;
        }
        Element root = (Element)modelResource.getContents().get(0);
        if (root instanceof Package) {
            Package libToImport = (Package)modelResource.getContents().get(0);
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return modelLibImport;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.extensionpoints", "The selected uri (" + uri.toString() + ") does not contain any model library !"));
        return null;
    }
}

