/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.CatalogBranding;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogSwitcher;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplacePage
extends CatalogPage {
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogDescriptor previousCatalogDescriptor;
    private boolean updated;
    private Link selectionLink;
    private TabFolder tabFolder;
    private TabItem searchTabItem;
    private TabItem recentTabItem;
    private TabItem popularTabItem;
    private TabItem newsTabItem;
    private Control tabContent;
    private TabItem installedTabItem;
    private NewsViewer newsViewer;
    private CatalogSwitcher marketplaceSwitcher;
    private ICatalogBranding currentBranding = this.getDefaultBranding();
    protected boolean disableTabSelection;
    protected CatalogDescriptor lastSelection;

    public MarketplacePage(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog);
        this.configuration = configuration;
        this.setDescription(Messages.MarketplacePage_selectSolutionsToInstall);
        this.setTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.configuration.getCatalogDescriptor() != null) {
            this.setTitle(this.configuration.getCatalogDescriptor().getLabel());
        }
    }

    public void createControl(Composite parent) {
        this.currentBranding = this.getDefaultBranding();
        boolean needSwitchMarketplaceControl = this.configuration.getCatalogDescriptors().size() > 1;
        Composite pageContent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 5).applyTo(pageContent);
        this.tabFolder = new TabFolder(pageContent, 128);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        super.createControl((Composite)this.tabFolder);
        this.tabContent = this.getControl();
        this.searchTabItem = this.createCatalogTab(-1, this.currentBranding.getSearchTabName());
        this.recentTabItem = this.createCatalogTab(-1, this.currentBranding.getRecentTabName());
        this.popularTabItem = this.createCatalogTab(-1, this.currentBranding.getPopularTabName());
        this.installedTabItem = this.createCatalogTab(-1, Messages.MarketplacePage_installed);
        this.updateNewsTab();
        this.tabFolder.setSelection(this.searchTabItem);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.setActiveTab((TabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectionLink = new Link(pageContent, 0);
        this.selectionLink.setToolTipText(Messages.MarketplacePage_showSelection);
        this.selectionLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.selectionLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.selectionLink);
        this.computeSelectionLinkText();
        if (needSwitchMarketplaceControl) {
            this.createMarketplaceSwitcher(pageContent);
        }
        this.updateBranding();
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private int previousSelectionSize = 0;

            public void selectionChanged(SelectionChangedEvent event) {
                IWizardPage nextPage;
                IWizardPage currentPage;
                if (!MarketplacePage.this.isCurrentPage()) {
                    return;
                }
                SelectionModel selectionModel = MarketplacePage.this.getWizard().getSelectionModel();
                int newSelectionSize = selectionModel.getItemToSelectedOperation().size();
                if (!event.getSelection().isEmpty() && this.previousSelectionSize == 0 && newSelectionSize == 1 && selectionModel.computeProvisioningOperationViable() && (currentPage = MarketplacePage.this.getContainer().getCurrentPage()).isPageComplete() && (nextPage = MarketplacePage.this.getWizard().getNextPage((IWizardPage)MarketplacePage.this)) != null && nextPage instanceof WizardPage) {
                    ((WizardPage)nextPage).setPageComplete(true);
                    MarketplacePage.this.getContainer().showPage(nextPage);
                }
                this.previousSelectionSize = newSelectionSize;
            }
        });
        this.getViewer().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(MarketplaceViewer.CONTENT_TYPE_PROPERTY) && event.getNewValue() != null) {
                    MarketplacePage.this.setActiveTab((MarketplaceViewer.ContentType)((Object)event.getNewValue()));
                }
            }
        });
        this.setControl((Control)pageContent);
        MarketplaceClientUi.setDefaultHelp(this.tabContent);
    }

    private void setActiveTab(TabItem tab) {
        TabItem tabItem;
        if (this.disableTabSelection) {
            return;
        }
        if (tab == this.newsTabItem) {
            INews news = this.getNews();
            boolean wasUpdated = this.newsViewer.isUpdated(news);
            this.newsViewer.showNews(news);
            if (wasUpdated) {
                this.updateBranding();
                TabItem currentTabItem = this.getSelectedTabItem();
                if (currentTabItem != this.newsTabItem) {
                    this.tabFolder.setSelection(this.newsTabItem);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MarketplacePage.this.tabFolder.setSelection(MarketplacePage.this.newsTabItem);
                        }
                    });
                }
            }
            return;
        }
        MarketplaceViewer.ContentType currentContentType = this.getViewer().getContentType();
        if (currentContentType != null && (tabItem = this.getTabItem(currentContentType)) == tab) {
            this.setActiveTab(currentContentType);
            return;
        }
        MarketplaceViewer.ContentType[] contentTypeArray = MarketplaceViewer.ContentType.values();
        int n = contentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarketplaceViewer.ContentType contentType = contentTypeArray[n2];
            if (this.getTabItem(contentType) == tab) {
                this.setActiveTab(contentType);
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    private void setActiveTab(MarketplaceViewer.ContentType contentType) {
        if (this.disableTabSelection) {
            return;
        }
        TabItem tabItem = this.getTabItem(contentType);
        TabItem currentTabItem = this.getSelectedTabItem();
        if (currentTabItem != tabItem) {
            this.tabFolder.setSelection(tabItem);
        }
        this.getViewer().setContentType(contentType);
    }

    private TabItem getSelectedTabItem() {
        int currentTabIndex = this.tabFolder.getSelectionIndex();
        TabItem currentTabItem = null;
        if (currentTabIndex != -1) {
            currentTabItem = this.tabFolder.getItem(currentTabIndex);
        }
        return currentTabItem;
    }

    private TabItem getTabItem(MarketplaceViewer.ContentType content) {
        switch (content) {
            case INSTALLED: {
                return this.installedTabItem;
            }
            case POPULAR: {
                return this.popularTabItem;
            }
            case RECENT: {
                return this.recentTabItem;
            }
            case SEARCH: {
                return this.searchTabItem;
            }
            case SELECTION: {
                return this.searchTabItem;
            }
        }
        throw new IllegalArgumentException();
    }

    private TabItem createCatalogTab(int index, String label) {
        Control tabControl = this.tabContent;
        return this.createTab(index, label, tabControl);
    }

    private TabItem createTab(int index, String label, Control tabControl) {
        TabItem tabItem = index == -1 ? new TabItem(this.tabFolder, 0) : new TabItem(this.tabFolder, 0, index);
        tabItem.setText(label);
        tabItem.setControl(tabControl);
        return tabItem;
    }

    private void createNewsTab() {
        this.newsTabItem = new TabItem(this.tabFolder, 1);
        this.newsTabItem.setText(Messages.MarketplacePage_DefaultNewsTitle);
        if (this.newsViewer == null) {
            this.createNewsViewer((Composite)this.tabFolder);
        }
        this.newsTabItem.setControl(this.newsViewer.getControl());
    }

    private void updateNewsTab() {
        INews news;
        if (this.newsTabItem == null) {
            this.createNewsTab();
        }
        if ((news = this.getNews()) == null) {
            if (!this.newsTabItem.isDisposed()) {
                this.newsTabItem.dispose();
            }
            return;
        }
        if (this.newsTabItem.isDisposed()) {
            this.createNewsTab();
        }
        if (news.getShortTitle() != null && news.getShortTitle().length() > 0) {
            String title;
            String tooltip = title = news.getShortTitle();
            if (title.length() > 40) {
                tooltip = title;
                title = String.valueOf(title.substring(0, 39)) + '\u2026';
            }
            this.newsTabItem.setText(title);
            this.newsTabItem.setToolTipText(tooltip);
        }
        this.updateNewsStatus();
    }

    private void updateNewsStatus() {
        INews news = this.getNews();
        Image tabImage = null;
        if (news != null && this.newsViewer.isUpdated(news)) {
            tabImage = MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NEWS_ICON_UPDATE");
        }
        this.newsTabItem.setImage(tabImage);
        this.newsTabItem.getParent().layout();
    }

    private INews getNews() {
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        INews news = CatalogRegistry.getInstance().getCatalogNews(descriptor);
        return news;
    }

    private void createNewsViewer(Composite parent) {
        this.newsViewer = new NewsViewer(this.getWizard());
        this.newsViewer.createControl(parent);
    }

    private void createMarketplaceSwitcher(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        CatalogSwitcher switcher = new CatalogSwitcher(composite, 2048, this.configuration);
        switcher.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CatalogDescriptor descriptor = (CatalogDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
                MarketplacePage.this.showMarketplace(descriptor);
            }
        });
        CatalogDescriptor selectedDescriptor = this.configuration.getCatalogDescriptor();
        if (selectedDescriptor != null) {
            switcher.setSelection((ISelection)new StructuredSelection((Object)selectedDescriptor));
        }
        this.marketplaceSwitcher = switcher;
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).minSize(1, -1).hint(500, -1).applyTo((Control)composite);
    }

    private void computeSelectionLinkText() {
        if (this.selectionLink != null) {
            String originalText = this.selectionLink.getText();
            String text = "";
            int count = this.getWizard().getSelectionModel().getItemToSelectedOperation().size();
            if (count == 1) {
                text = Messages.MarketplacePage_linkShowSelection_One;
            } else if (count > 0) {
                text = NLS.bind((String)Messages.MarketplacePage_linkShowSelection_Multiple, (Object)count);
            }
            if (!text.equals(originalText)) {
                this.selectionLink.setText(text);
                this.selectionLink.getParent().layout(true, false);
            }
        }
    }

    protected void selectionLinkActivated() {
        this.tabFolder.setSelection(this.searchTabItem);
        this.getViewer().showSelected();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        MarketplaceViewer viewer = new MarketplaceViewer(this.getCatalog(), (IShellProvider)this, this.getWizard());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        return viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!MarketplacePage.this.getControl().isDisposed() && MarketplacePage.this.isCurrentPage()) {
                        MarketplacePage.this.getWizard().updateNews();
                        MarketplacePage.this.getViewer().updateCatalog();
                        MarketplacePage.this.updateBranding();
                    }
                }
            });
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
            if (catalogDescriptor != null) {
                this.setTitle(catalogDescriptor.getLabel());
            }
            if (this.previousCatalogDescriptor == null || !this.previousCatalogDescriptor.equals(catalogDescriptor)) {
                this.previousCatalogDescriptor = catalogDescriptor;
                this.tabFolder.setSelection(this.searchTabItem);
                this.getViewer().setContentType(MarketplaceViewer.ContentType.SEARCH);
                this.getWizard().initializeCatalog();
                this.updated = false;
            }
        }
        super.setVisible(visible);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = this.getWizard().getSelectionModel().computeProvisioningOperationViable();
        }
        this.computeMessages();
        super.setPageComplete(complete);
    }

    private void computeMessages() {
        this.computeStatusMessage();
        this.computeSelectionLinkText();
    }

    private void computeStatusMessage() {
        IStatus viability;
        String message = null;
        int messageType = 0;
        if (this.getWizard() != null && (viability = this.getWizard().getSelectionModel().computeProvisioningOperationViability()) != null) {
            message = viability.getMessage();
            messageType = Util.computeMessageType(viability);
        }
        this.setMessage(message, messageType);
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    private void updateBranding() {
        ICatalogBranding branding;
        this.disableTabSelection = true;
        this.updateTitle();
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        ICatalogBranding oldBranding = this.currentBranding;
        ICatalogBranding iCatalogBranding = branding = descriptor == null ? null : descriptor.getCatalogBranding();
        if (branding == null) {
            branding = this.getDefaultBranding();
        }
        this.currentBranding = branding;
        TabItem selectedTabItem = this.getSelectedTabItem();
        int tabIndex = 0;
        boolean hasTab = branding.hasSearchTab();
        this.searchTabItem = this.updateTab(this.searchTabItem, branding.getSearchTabName(), hasTab, oldBranding.hasSearchTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = branding.hasRecentTab();
        this.recentTabItem = this.updateTab(this.recentTabItem, branding.getRecentTabName(), hasTab, oldBranding.hasRecentTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = branding.hasPopularTab();
        this.popularTabItem = this.updateTab(this.popularTabItem, branding.getPopularTabName(), hasTab, oldBranding.hasPopularTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        this.updateNewsTab();
        if (selectedTabItem == null || selectedTabItem.isDisposed()) {
            this.tabFolder.setSelection(0);
        }
        try {
            ImageDescriptor wizardIconDescriptor = branding.getWizardIcon() == null ? DiscoveryImages.BANNER_DISOVERY : ImageDescriptor.createFromURL((URL)URLUtil.toURL((String)branding.getWizardIcon()));
            this.setImageDescriptor(wizardIconDescriptor);
        }
        catch (MalformedURLException e) {
            MarketplaceClientUi.error(e);
        }
        this.disableTabSelection = false;
    }

    private TabItem updateTab(TabItem tabItem, String tabLabel, boolean hasTab, boolean hadTab, int tabIndex) {
        if (hasTab) {
            if (!hadTab) {
                tabItem = this.createCatalogTab(tabIndex, tabLabel);
            } else {
                tabItem.setText(tabLabel);
            }
        } else if (tabItem != null && !tabItem.isDisposed()) {
            tabItem.dispose();
        }
        return tabItem;
    }

    private ICatalogBranding getDefaultBranding() {
        CatalogBranding branding = new CatalogBranding();
        branding.setHasSearchTab(true);
        branding.setHasPopularTab(true);
        branding.setHasRecentTab(true);
        branding.setSearchTabName(Messages.MarketplacePage_search);
        branding.setPopularTabName(Messages.MarketplacePage_popular);
        branding.setRecentTabName(Messages.MarketplacePage_recent);
        branding.setWizardTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        return branding;
    }

    public IStatus showMarketplace(CatalogDescriptor catalogDescriptor) {
        if (this.configuration.getCatalogDescriptor() != catalogDescriptor) {
            if (this.getWizard().getSelectionModel().getSelectedCatalogItems().size() > 0) {
                boolean discardSelection = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MarketplacePage_selectionSolutions, (String)Messages.MarketplacePage_discardPendingSolutions);
                if (discardSelection) {
                    this.getWizard().getSelectionModel().clear();
                    this.computeSelectionLinkText();
                } else {
                    if (this.marketplaceSwitcher != null) {
                        this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)this.lastSelection));
                    }
                    return Status.CANCEL_STATUS;
                }
            }
            this.lastSelection = catalogDescriptor;
            this.configuration.setCatalogDescriptor(catalogDescriptor);
            if (this.marketplaceSwitcher != null) {
                this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)catalogDescriptor));
            }
            this.updateCatalog();
        }
        return Status.OK_STATUS;
    }

    private void updateCatalog() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MarketplacePage.this.getWizard().initializeCatalog();
                    MarketplacePage.this.getWizard().updateNews();
                    MarketplacePage.this.getViewer().updateCatalog();
                    MarketplacePage.this.updateBranding();
                }
            });
        }
        catch (InvocationTargetException e) {
            MarketplaceClientUi.error(e.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void showNews(CatalogDescriptor catalogDescriptor) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.newsTabItem);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, MarketplaceViewer.ContentType content) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(content);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, Set<? extends INode> nodes) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().show(nodes);
        }
    }

    public void search(CatalogDescriptor catalogDescriptor, IMarket searchMarket, ICategory searchCategory, String searchString) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().search(searchMarket, searchCategory, searchString);
        }
    }

    protected void initialize(MarketplaceWizard.WizardState initialState) {
        MarketplaceViewer.ContentType contentType = initialState.getContentType();
        if (contentType != null && contentType != MarketplaceViewer.ContentType.SEARCH) {
            this.show(this.configuration.getCatalogDescriptor(), contentType);
        } else if (initialState.getContent() != null && !initialState.getContent().isEmpty()) {
            this.show(this.configuration.getCatalogDescriptor(), initialState.getContent());
        } else {
            IMarket market = initialState.getFilterMarket();
            ICategory category = initialState.getFilterCategory();
            String query = initialState.getFilterQuery();
            if (market != null || category != null || query != null) {
                this.search(this.configuration.getCatalogDescriptor(), market, category, query);
            }
        }
    }

    public void dispose() {
        if (this.marketplaceSwitcher != null) {
            this.marketplaceSwitcher.dispose();
        }
        super.dispose();
    }
}

