/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogToolTip;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CatalogSwitcher
extends Composite
implements ISelectionProvider {
    private static final int ITEM_MARGIN = 5;
    private static final int MIN_SCROLL_HEIGHT = 42;
    private final MarketplaceCatalogConfiguration configuration;
    private final ImageRegistry imageRegistry = new ImageRegistry();
    private final List<ISelectionChangedListener> listeners = new LinkedList<ISelectionChangedListener>();
    private CatalogDescriptor selection;
    private Composite marketplaceArea;

    public CatalogSwitcher(Composite parent, int style, MarketplaceCatalogConfiguration configuration) {
        super(parent, style);
        this.configuration = configuration;
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo((Composite)this);
        this.createContents(this);
    }

    private void createContents(final Composite parent) {
        this.createHeader(parent);
        final ScrolledComposite scrollArea = new ScrolledComposite(parent, 512);
        scrollArea.setLayout((Layout)new FillLayout());
        this.marketplaceArea = new Composite((Composite)scrollArea, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.marketplaceArea.setLayout((Layout)layout);
        Color listBackground = this.getDisplay().getSystemColor(25);
        this.setBackground(listBackground);
        this.marketplaceArea.setBackground(listBackground);
        scrollArea.setBackground(listBackground);
        List<CatalogDescriptor> catalogDescriptors = this.configuration.getCatalogDescriptors();
        for (CatalogDescriptor catalogDescriptor : catalogDescriptors) {
            this.createMarketplace(this.marketplaceArea, catalogDescriptor);
        }
        scrollArea.setContent((Control)this.marketplaceArea);
        scrollArea.setExpandVertical(true);
        scrollArea.setExpandHorizontal(true);
        scrollArea.setMinHeight(42);
        scrollArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = parent.getClientArea();
                int scrollBarWidth = scrollArea.getVerticalBar().getSize().x;
                scrollArea.setMinSize(CatalogSwitcher.this.marketplaceArea.computeSize(r.width - scrollBarWidth, -1));
            }
        });
    }

    private void createHeader(Composite parent) {
        CatalogCategory fakeCategory = new CatalogCategory();
        fakeCategory.setName(Messages.CatalogSwitcher_Header);
        CategoryItem header = new CategoryItem(parent, 0, new DiscoveryResources(parent.getDisplay()), fakeCategory);
        MarketplaceViewer.setSeparatorVisible(header, false);
        MarketplaceViewer.fixLayout(header);
    }

    private void createMarketplace(Composite composite, final CatalogDescriptor catalogDescriptor) {
        Composite container = new Composite(composite, 0);
        Color listBackground = this.getDisplay().getSystemColor(25);
        container.setBackground(listBackground);
        container.setData((Object)catalogDescriptor);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setBackground(listBackground);
        this.retrieveCatalogImage(catalogDescriptor, label);
        label.setImage(this.getDefaultCatalogImage());
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CatalogSwitcher.this.selection = catalogDescriptor;
                CatalogSwitcher.this.refreshSelection();
                CatalogSwitcher.this.fireSelectionChanged();
            }
        });
        CatalogToolTip.attachCatalogToolTip(label, catalogDescriptor);
    }

    private void retrieveCatalogImage(final CatalogDescriptor catalogDescriptor, final Label label) {
        Job job = new Job(Messages.CatalogSwitcher_retrieveMetaData){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)Messages.CatalogSwitcher_downloadCatalogImage, (Object)catalogDescriptor.getLabel()), 1);
                final Image image = CatalogSwitcher.this.getCatalogIcon(catalogDescriptor);
                monitor.worked(1);
                label.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        label.setImage(image);
                    }
                });
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    private void fireSelectionChanged() {
        for (ISelectionChangedListener listener : this.listeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)this.selection));
            listener.selectionChanged(event);
        }
    }

    private Image getCatalogIcon(CatalogDescriptor catalogDescriptor) {
        String key = catalogDescriptor.getUrl().toExternalForm();
        Image image = this.imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor catalogIcon = catalogDescriptor.getIcon();
            if (catalogIcon == null) {
                return this.getDefaultCatalogImage();
            }
            this.imageRegistry.put(key, catalogIcon);
            image = this.imageRegistry.get(key);
        }
        return image;
    }

    private Image getDefaultCatalogImage() {
        return MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED_CATALOG");
    }

    public void dispose() {
        this.imageRegistry.dispose();
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.selection);
    }

    public void setSelection(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
            this.selection = (CatalogDescriptor)structuredSelection.getFirstElement();
            this.refreshSelection();
        }
    }

    private void refreshSelection() {
        Control[] children;
        Control[] controlArray = children = this.marketplaceArea.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            int color = this.selection == control.getData() ? 26 : 1;
            control.setBackground(this.getDisplay().getSystemColor(color));
            ((Composite)control).getChildren()[0].setBackground(this.getDisplay().getSystemColor(color));
            ++n2;
        }
    }

    public int getPreferredHeight() {
        return 42 + 2 * this.getBorderWidth() + 6;
    }
}

