/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressConstants2;

public abstract class WorkspaceAction
extends SelectionListenerAction {
    private final IShellProvider shellProvider;

    protected WorkspaceAction(final Shell shell, String text) {
        super(text);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
    }

    protected WorkspaceAction(IShellProvider provider, String text) {
        super(text);
        Assert.isNotNull((Object)provider);
        this.shellProvider = provider;
    }

    void displayError(String message) {
        if (message == null) {
            message = IDEWorkbenchMessages.WorkbenchAction_internalError;
        }
        MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getProblemsTitle(), (String)message);
    }

    final IStatus execute(List resources, IProgressMonitor monitor) {
        MultiStatus errors = null;
        if (this.shouldPerformResourcePruning()) {
            resources = this.pruneResources(resources);
        }
        monitor.beginTask("", resources.size() * 1000);
        monitor.setTaskName(this.getOperationMessage());
        Iterator resourcesEnum = resources.iterator();
        try {
            while (resourcesEnum.hasNext()) {
                IResource resource = (IResource)resourcesEnum.next();
                try {
                    this.invokeOperation(resource, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (CoreException e) {
                    errors = this.recordError(errors, e);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            IStatus iStatus = errors == null ? Status.OK_STATUS : errors;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract String getOperationMessage();

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.WorkbenchAction_problemsMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.WorkspaceAction_problemsTitle;
    }

    Shell getShell() {
        return this.shellProvider.getShell();
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
    }

    boolean isDescendent(List resources, IResource child) {
        IContainer parent = child.getParent();
        return parent != null && (resources.contains(parent) || this.isDescendent(resources, (IResource)parent));
    }

    List pruneResources(List resourceCollection) {
        ArrayList prunedList = new ArrayList(resourceCollection);
        Iterator elementsEnum = prunedList.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(prunedList, currentResource)) continue;
            elementsEnum.remove();
        }
        return prunedList;
    }

    MultiStatus recordError(MultiStatus errors, CoreException error) {
        if (errors == null) {
            errors = new MultiStatus("org.eclipse.ui.ide", 4, this.getProblemsMessage(), null);
        }
        errors.merge(error.getStatus());
        return errors;
    }

    public void run() {
        IStatus[] errorStatus = new IStatus[1];
        try {
            new ProgressMonitorJobsDialog(this.shellProvider.getShell()).run(true, true, this.createOperation(errorStatus));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            String msg = NLS.bind((String)IDEWorkbenchMessages.WorkspaceAction_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)e.getTargetException());
            IDEWorkbenchPlugin.log(msg, StatusUtil.newStatus(4, msg, e.getTargetException()));
            this.displayError(e.getTargetException().getMessage());
        }
        if (errorStatus[0] != null && !errorStatus[0].isOK()) {
            ErrorDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getProblemsTitle(), null, (IStatus)errorStatus[0]);
        }
    }

    protected boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection) || selection.isEmpty()) {
            return false;
        }
        for (IResource r : this.getSelectedResources()) {
            if (r.isAccessible()) continue;
            return false;
        }
        return true;
    }

    protected List getActionResources() {
        return this.getSelectedResources();
    }

    public void runInBackground(ISchedulingRule rule) {
        this.runInBackground(rule, null);
    }

    public void runInBackground(ISchedulingRule rule, Object jobFamily) {
        if (jobFamily == null) {
            this.runInBackground(rule, null);
        } else {
            this.runInBackground(rule, new Object[]{jobFamily});
        }
    }

    public void runInBackground(ISchedulingRule rule, final Object[] jobFamilies) {
        final ArrayList resources = new ArrayList(this.getActionResources());
        WorkspaceJob job = new WorkspaceJob(WorkspaceAction.removeMnemonics((String)this.getText())){

            public boolean belongsTo(Object family) {
                if (jobFamilies == null || family == null) {
                    return false;
                }
                int i = 0;
                while (i < jobFamilies.length) {
                    if (family.equals(jobFamilies[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                return WorkspaceAction.this.execute(resources, monitor);
            }
        };
        if (rule != null) {
            job.setRule(rule);
        }
        if (job.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        }
        job.setUser(true);
        job.schedule();
    }

    protected IRunnableWithProgress createOperation(final IStatus[] errorStatus) {
        return new WorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) {
                errorStatus[0] = WorkspaceAction.this.execute(WorkspaceAction.this.getActionResources(), monitor);
            }
        };
    }
}

