/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;

public class PivotEnvironmentFactory
extends AbstractEnvironmentFactory {
    @Nullable
    private static PivotEnvironmentFactory globalRegistryInstance = null;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @Nullable
    private final EPackage.Registry registry;

    @Nullable
    public static PivotEnvironmentFactory basicGetGlobalRegistryInstance() {
        return globalRegistryInstance;
    }

    public static void disposeGlobalRegistryInstance() {
        if (globalRegistryInstance != null) {
            globalRegistryInstance.getMetaModelManager().dispose();
            globalRegistryInstance = null;
        }
    }

    @NonNull
    public static PivotEnvironmentFactory getGlobalRegistryInstance() {
        PivotEnvironmentFactory globalRegistryInstance2 = globalRegistryInstance;
        if (globalRegistryInstance2 == null) {
            globalRegistryInstance = globalRegistryInstance2 = new PivotEnvironmentFactory();
        }
        return globalRegistryInstance2;
    }

    public PivotEnvironmentFactory() {
        this(EPackage.Registry.INSTANCE, null);
    }

    public PivotEnvironmentFactory(@Nullable EPackage.Registry reg, @Nullable MetaModelManager metaModelManager) {
        this.registry = reg;
        this.metaModelManager = metaModelManager != null ? metaModelManager : new MetaModelManager();
    }

    @NonNull
    public PivotEnvironment createEnvironment() {
        PivotEnvironment result = new PivotEnvironment(this, null);
        return result;
    }

    @NonNull
    public PivotEnvironment loadEnvironment(@NonNull Resource resource) {
        PivotEnvironment result = new PivotEnvironment(this, resource);
        return result;
    }

    @Nullable
    public final EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    @NonNull
    public PivotEnvironment createEnvironment(@NonNull Environment parent) {
        if (!(parent instanceof PivotEnvironment)) {
            throw new IllegalArgumentException("Parent environment must be a Pivot environment: " + parent);
        }
        PivotEnvironment result = new PivotEnvironment((PivotEnvironment)parent);
        return result;
    }

    @NonNull
    public EvaluationEnvironment createEvaluationEnvironment() {
        return new PivotEvaluationEnvironment(this.getMetaModelManager());
    }

    @NonNull
    public EvaluationEnvironment createEvaluationEnvironment(@NonNull EvaluationEnvironment parent) {
        return new PivotEvaluationEnvironment(parent);
    }

    @NonNull
    protected Type getClassifier(@NonNull Object context) {
        DomainType dType = this.metaModelManager.getIdResolver().getStaticTypeOf(context);
        return this.metaModelManager.getType(dType);
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }
}

