/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.ASSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSaverNormalizeVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverNormalizeVisitor(@NonNull ASSaver context) {
        super(context);
    }

    protected <T> void sort(@NonNull List<T> ownedTypes, @NonNull Comparator<T> comparator) {
        ArrayList<T> sortedList = new ArrayList<T>(ownedTypes);
        Collections.sort(sortedList, comparator);
        ownedTypes.clear();
        ownedTypes.addAll(sortedList);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        List<Property> ownedAttributes = object.getOwnedAttribute();
        this.sort(ownedAttributes, PropertyComparator.INSTANCE);
        return null;
    }

    @Override
    public Object visitPackage(@NonNull Package object) {
        List<Type> ownedTypes = object.getOwnedType();
        this.sort(ownedTypes, TypeComparator.INSTANCE);
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class PropertyComparator
    implements Comparator<Property> {
        @NonNull
        public static final Comparator<Property> INSTANCE = new PropertyComparator();

        protected PropertyComparator() {
        }

        @Override
        public int compare(Property o1, Property o2) {
            int l2;
            assert (o1 != null);
            assert (o2 != null);
            int l1 = o1.isImplicit() ? 1 : 0;
            int n = l2 = o2.isImplicit() ? 1 : 0;
            if (l1 != l2) {
                return l1 - l2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class TypeComparator
    implements Comparator<Type> {
        @NonNull
        public static final Comparator<Type> INSTANCE = new TypeComparator();

        protected TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            assert (o1 != null);
            assert (o2 != null);
            String n1 = AS2Moniker.toString(o1);
            String n2 = AS2Moniker.toString(o2);
            return n1.compareTo(n2);
        }
    }
}

