/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIid;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AS2XMIidVisitor
extends AbstractExtendingVisitor<Boolean, AS2XMIid> {
    public static final int OVERFLOW_LIMIT = 1024;
    @NonNull
    public static final String OVERFLOW_MARKER = "##";
    @NonNull
    public static final String NULL_MARKER = "<<null-element>>";
    @NonNull
    public static final String FRAGMENT_SEPARATOR = "#";
    @NonNull
    public static final String ACCUMULATOR_PREFIX = "a";
    @NonNull
    public static final String BODYCONDITION_PREFIX = "c=";
    @NonNull
    public static final String INVARIANT_PREFIX = "ci";
    @NonNull
    public static final String ITERATION_PREFIX = "i.";
    @NonNull
    public static final String ITERATOR_PREFIX = "i";
    @NonNull
    public static final String OPERATION_PREFIX = "o.";
    @NonNull
    public static final String PARAMETER_PREFIX = "p";
    @NonNull
    public static final String PACKAGE_PREFIX = "P.";
    @NonNull
    public static final String POSTCONDITION_PREFIX = "c+";
    @NonNull
    public static final String PRECONDITION_PREFIX = "c-";
    @NonNull
    public static final String PRECEDENCE_PREFIX = "Z.";
    @NonNull
    public static final String PROPERTY_PREFIX = "p.";
    @NonNull
    public static final String TEMPLATE_PARAMETER_PREFIX = "t.";
    @NonNull
    public static final String TEMPLATE_SIGNATURE_PREFIX = "s.";
    @NonNull
    public static final String TYPE_PREFIX = "T.";
    @NonNull
    public static final String OPERATION_PARAMETER_SEPARATOR = "..";
    @NonNull
    public static final String SCOPE_SEPARATOR = ".";
    @NonNull
    public static final String TEMPLATE_PARAMETER_SEPARATOR = "..";
    @NonNull
    protected final StringBuilder s = new StringBuilder();

    public AS2XMIidVisitor(@NonNull AS2XMIid context) {
        super(context);
    }

    protected void appendName(@Nullable String name) {
        if (name == null) {
            this.s.append(NULL_MARKER);
        } else {
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if ('0' <= c && c <= '9') {
                    this.s.append(c);
                } else if ('A' <= c && c <= 'Z') {
                    this.s.append(c);
                } else if ('a' <= c && c <= 'z') {
                    this.s.append(c);
                } else if (c == '_') {
                    this.s.append(c);
                } else if (c == '$') {
                    this.s.append(c);
                } else if (c == '%') {
                    this.s.append("%%");
                } else {
                    this.s.append("%");
                    this.s.append((int)c);
                    this.s.append("%");
                }
                ++i;
            }
        }
    }

    protected void appendOperation(Operation object) {
        this.appendParent(object);
        this.appendName(object.getName());
        List<Parameter> parameters = object instanceof Iteration ? ((Iteration)object).getOwnedIterator() : object.getOwnedParameter();
        for (Parameter parameter : parameters) {
            this.s.append("..");
            this.appendType(parameter.getType());
        }
    }

    protected void appendParent(@Nullable NamedElement element) {
        if (this.toString().length() >= 1024) {
            this.s.append(OVERFLOW_MARKER);
        } else if (element == null) {
            this.s.append(NULL_MARKER);
            this.s.append(SCOPE_SEPARATOR);
        } else {
            EObject eContainer = element.eContainer();
            if (!(eContainer instanceof Root) && eContainer instanceof NamedElement) {
                NamedElement parent = (NamedElement)eContainer;
                this.appendParent(parent);
                this.appendName(parent.getName());
                this.s.append(SCOPE_SEPARATOR);
            }
        }
    }

    protected void appendType(@Nullable Type type) {
        if (type == null) {
            this.s.append(NULL_MARKER);
        } else {
            this.appendParent(type);
            this.appendName(type.getName());
        }
    }

    @Nullable
    public String getID(@NonNull Element element, boolean internalUUIDs) {
        Boolean status = (Boolean)element.accept(this);
        if (status == null) {
            return null;
        }
        if (status.booleanValue()) {
            return this.s.toString();
        }
        return ((AS2XMIid)this.context).getID(element, internalUUIDs);
    }

    public String toString() {
        return this.s.toString();
    }

    @Override
    public Boolean visitClass(@NonNull Class object) {
        if (Orphanage.isTypeOrphanage(object.getPackage())) {
            return false;
        }
        String name = object.getName();
        if ("wildcard".equals(name) && Orphanage.isTypeOrphanage(PivotUtil.getContainingPackage(object))) {
            return false;
        }
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            NamedElement template = (NamedElement)((Object)owningTemplateParameter.getSignature().getTemplate());
            if (template instanceof Type && Orphanage.isTypeOrphanage(((Type)template).getPackage())) {
                return false;
            }
            this.s.append(TYPE_PREFIX);
            this.appendParent(template);
            this.s.append(SCOPE_SEPARATOR);
            this.appendName(template.getName());
            this.appendName(name);
        } else {
            this.s.append(TYPE_PREFIX);
            this.appendParent(object);
            this.appendName(name);
        }
        return true;
    }

    @Override
    @Nullable
    public Boolean visitCollectionType(@NonNull CollectionType object) {
        if (object.getTemplateBinding().isEmpty()) {
            this.appendName(object.getName());
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Boolean visitConstraint(@NonNull Constraint object) {
        String name = object.getName();
        if (name != null && !"".equals(name)) {
            EReference eContainmentFeature = object.eContainmentFeature();
            if (eContainmentFeature == PivotPackage.Literals.OPERATION__PRECONDITION) {
                this.s.append(PRECONDITION_PREFIX);
            } else if (eContainmentFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
                this.s.append(BODYCONDITION_PREFIX);
            } else if (eContainmentFeature == PivotPackage.Literals.OPERATION__POSTCONDITION) {
                this.s.append(POSTCONDITION_PREFIX);
            } else {
                this.s.append(INVARIANT_PREFIX);
            }
            this.appendParent(object);
            this.appendName(name);
            return true;
        }
        return null;
    }

    @Override
    @Nullable
    public Boolean visitElement(@NonNull Element object) {
        return null;
    }

    @Override
    @Nullable
    public Boolean visitLambdaType(@NonNull LambdaType object) {
        return false;
    }

    @Override
    public Boolean visitIteration(@NonNull Iteration object) {
        this.s.append(ITERATION_PREFIX);
        this.appendOperation(object);
        return true;
    }

    @Override
    @Nullable
    public Boolean visitMetaclass(@NonNull Metaclass<?> object) {
        if (object.getTemplateBinding().isEmpty()) {
            this.appendName(object.getName());
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Boolean visitOperation(@NonNull Operation object) {
        this.s.append(OPERATION_PREFIX);
        this.appendOperation(object);
        return true;
    }

    @Override
    @Nullable
    public Boolean visitPackage(@NonNull Package object) {
        String name = object.getName();
        if (name != null) {
            this.s.append(PACKAGE_PREFIX);
            this.appendParent(object);
            this.appendName(name);
            return true;
        }
        if (object.getNsURI() != null) {
            this.appendName(object.getNsURI());
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Boolean visitParameter(@NonNull Parameter object) {
        Operation operation = (Operation)object.eContainer();
        int index = operation.getOwnedParameter().indexOf(object);
        if (index >= 0) {
            this.s.append(PARAMETER_PREFIX);
            this.s.append(index);
        } else if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            index = iteration.getOwnedIterator().indexOf(object);
            if (index >= 0) {
                this.s.append(ITERATOR_PREFIX);
                this.s.append(index);
            } else {
                index = iteration.getOwnedAccumulator().indexOf(object);
                if (index >= 0) {
                    this.s.append(ACCUMULATOR_PREFIX);
                    this.s.append(index);
                }
            }
        }
        operation.accept(this);
        return true;
    }

    @Override
    @Nullable
    public Boolean visitPrecedence(@NonNull Precedence object) {
        this.s.append(PRECEDENCE_PREFIX);
        this.appendName(object.getName());
        return true;
    }

    @Override
    @Nullable
    public Boolean visitPrimitiveType(@NonNull PrimitiveType object) {
        this.appendName(object.getName());
        return true;
    }

    @Override
    @Nullable
    public Boolean visitProperty(@NonNull Property object) {
        EObject eContainer = object.eContainer();
        if (eContainer instanceof TupleType) {
            return false;
        }
        String name = object.getName();
        if (object.isImplicit() && eContainer instanceof Type) {
            for (Property asProperty : ((Type)eContainer).getOwnedAttribute()) {
                if (asProperty == object || !name.equals(asProperty.getName())) continue;
                return false;
            }
        }
        this.s.append(PROPERTY_PREFIX);
        this.appendParent(object);
        this.appendName(name);
        return true;
    }

    @Override
    @Nullable
    public Boolean visitSelfType(@NonNull SelfType object) {
        this.appendName(object.getName());
        return true;
    }

    @Override
    @Nullable
    public Boolean visitTemplateParameter(@NonNull TemplateParameter object) {
        this.s.append(TEMPLATE_PARAMETER_PREFIX);
        NamedElement template = (NamedElement)((Object)object.getSignature().getTemplate());
        this.appendParent(template);
        this.s.append(SCOPE_SEPARATOR);
        this.appendName(template.getName());
        this.appendName(((NamedElement)((Object)object.getParameteredElement())).getName());
        return true;
    }

    @Override
    @Nullable
    public Boolean visitTemplateSignature(@NonNull TemplateSignature object) {
        this.s.append(TEMPLATE_SIGNATURE_PREFIX);
        TemplateableElement template = object.getTemplate();
        template.accept(this);
        return true;
    }

    @Override
    @Nullable
    public Boolean visitTupleType(@NonNull TupleType object) {
        return false;
    }

    @Override
    @Nullable
    public Boolean visitTypeTemplateParameter(@NonNull TypeTemplateParameter object) {
        this.s.append(TEMPLATE_PARAMETER_PREFIX);
        NamedElement template = (NamedElement)((Object)object.getSignature().getTemplate());
        this.appendParent(template);
        this.s.append(SCOPE_SEPARATOR);
        this.appendName(template.getName());
        this.appendName(((NamedElement)((Object)object.getParameteredElement())).getName());
        return true;
    }

    @Override
    @Nullable
    public Boolean visitVariableDeclaration(@NonNull VariableDeclaration object) {
        return false;
    }

    @Override
    @Nullable
    public Boolean visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

