/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactory;
import org.eclipse.ocl.examples.pivot.resource.ASResourceImpl;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIid;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLASResourceImpl
extends ASResourceImpl {
    private Map<Type, EClassifier> uml2ecore = null;

    public UMLASResourceImpl(@NonNull URI uri, @NonNull ASResourceFactory asResourceFactory) {
        super(uri, asResourceFactory);
    }

    @Nullable
    public EClassifier getEClassifier(@NonNull Type umlType) {
        EClassifier eClassifier;
        if (this.uml2ecore == null) {
            this.uml2ecore = new HashMap<Type, EClassifier>();
        }
        if ((eClassifier = this.uml2ecore.get(umlType)) != null) {
            return eClassifier;
        }
        if (this.uml2ecore.containsKey(umlType)) {
            return null;
        }
        Package umlPackage = umlType.getPackage();
        if (umlPackage != null) {
            String typeName = umlType.getName();
            if ("http://www.omg.org/spec/UML/20131001".equals(umlPackage.getURI())) {
                eClassifier = UMLPackage.eINSTANCE.getEClassifier(typeName);
            } else if ("http://www.omg.org/spec/PrimitiveTypes/20131001".equals(umlPackage.getURI())) {
                eClassifier = TypesPackage.eINSTANCE.getEClassifier(typeName);
            }
        }
        this.uml2ecore.put(umlType, eClassifier);
        return eClassifier;
    }

    public EObject getEObject(String uriFragment) {
        if (this.idToEObjectMap == null) {
            AS2XMIid as2id = new AS2XMIid();
            as2id.assignIds(this, null);
        }
        return super.getEObject(uriFragment);
    }

    public void load(Map<?, ?> options) throws IOException {
        URI umlURI = this.uri.trimFileExtension();
        UML2Pivot.loadFromUML(this, umlURI);
        super.load(options);
    }
}

