/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.ecore.AbstractEcore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.resource.AbstractASResourceFactory;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.uml.UMLASResourceImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UMLASResourceFactory
extends AbstractASResourceFactory {
    @NonNull
    public static final UMLASResourceFactory INSTANCE = new UMLASResourceFactory();

    protected UMLASResourceFactory() {
        super("org.eclipse.ocl.examples.oclas.uml", null);
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        super.configure(resourceSet);
        OCL.initialize(resourceSet);
        UMLResourcesUtil.init((ResourceSet)resourceSet);
    }

    @Override
    @NonNull
    public Resource createResource(URI uri) {
        assert (uri != null);
        UMLASResourceImpl asResource = new UMLASResourceImpl(uri, this);
        this.configureResource(asResource);
        return asResource;
    }

    @Override
    @Nullable
    public <T extends Element> T getASElement(@NonNull MetaModelManager metaModelManager, @NonNull java.lang.Class<T> pivotClass, @NonNull EObject eObject) throws ParserException {
        EOperation eOperation;
        Constraint umlConstraint;
        Resource metaModel = eObject.eResource();
        if (metaModel == null) {
            return null;
        }
        UML2Pivot uml2pivot = UML2Pivot.getAdapter(metaModel, metaModelManager);
        uml2pivot.getPivotRoot();
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == EcorePackage.eINSTANCE && eObject instanceof EOperation && (umlConstraint = this.getConstraintForEOperation(eOperation = (EOperation)eObject)) != null) {
            eObject = umlConstraint;
        }
        return uml2pivot.getCreated(pivotClass, eObject);
    }

    protected Constraint getConstraintForEOperation(EOperation eOperation) {
        String operationName;
        Constraint umlConstraint;
        EObject eReference;
        EList eReferences;
        EClass eContainingClass;
        EAnnotation eAnnotation;
        if (EcoreUtil.isInvariant((EOperation)eOperation) && (eAnnotation = (eContainingClass = eOperation.getEContainingClass()).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (eReferences = eAnnotation.getReferences()) != null && eReferences.size() > 0 && (eReference = (EObject)eReferences.get(0)) instanceof Type && (umlConstraint = ((Classifier)eReference).getOwnedRule(operationName = AbstractEcore2Pivot.getOriginalName((ENamedElement)eOperation))) != null) {
            return umlConstraint;
        }
        return null;
    }

    @Override
    @Nullable
    public EOperation getEOperation(@NonNull ASResource asResource, @NonNull EObject eObject) {
        UMLASResourceImpl umlResource = (UMLASResourceImpl)asResource;
        if (!(eObject instanceof Operation)) {
            return null;
        }
        Operation umlOperation = (Operation)eObject;
        Class umlClass = umlOperation.getClass_();
        if (umlClass == null) {
            return null;
        }
        EClassifier eClassifier = umlResource.getEClassifier((Type)umlClass);
        if (eClassifier == null) {
            return null;
        }
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        String operationName = umlOperation.getName();
        if (operationName == null) {
            return null;
        }
        EList umlParameters = umlOperation.getOwnedParameters();
        int umlParameterCount = umlParameters.size();
        for (EOperation eOperation : ((EClass)eClassifier).getEOperations()) {
            EList eParameters;
            int eParameterCount;
            if (!operationName.equals(eOperation.getName()) || umlParameterCount < (eParameterCount = (eParameters = eOperation.getEParameters()).size())) continue;
            boolean parametersMatch = true;
            int umlIndex = 0;
            int eIndex = 0;
            while (eIndex < eParameterCount && umlIndex < umlParameterCount) {
                EClassifier eParameterType;
                Parameter umlInParameter = null;
                while (umlIndex < umlParameterCount) {
                    Parameter umlParameter;
                    if ((umlParameter = (Parameter)umlParameters.get(umlIndex++)).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                    umlInParameter = umlParameter;
                    break;
                }
                if (umlInParameter == null) {
                    parametersMatch = false;
                    break;
                }
                EParameter eParameter = (EParameter)eParameters.get(eIndex++);
                Type umlParameterType = umlInParameter.getType();
                EClassifier umlEParameterType = umlParameterType != null ? umlResource.getEClassifier(umlParameterType) : null;
                if (umlEParameterType == (eParameterType = eParameter.getEType())) continue;
                parametersMatch = false;
                break;
            }
            while (umlIndex < umlParameterCount) {
                Parameter umlParameter;
                if ((umlParameter = (Parameter)umlParameters.get(umlIndex++)).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                parametersMatch = false;
                break;
            }
            if (eIndex != eParameterCount || umlIndex != umlParameterCount || !parametersMatch) continue;
            return eOperation;
        }
        return null;
    }

    @Override
    @Nullable
    public EReference getEReference(@NonNull ASResource asResource, @NonNull EObject eObject) {
        UMLASResourceImpl umlResource = (UMLASResourceImpl)asResource;
        if (!(eObject instanceof Property)) {
            return null;
        }
        Property umlProperty = (Property)eObject;
        Class umlClass = umlProperty.getClass_();
        if (umlClass == null) {
            return null;
        }
        EClassifier eClassifier = umlResource.getEClassifier((Type)umlClass);
        if (eClassifier == null) {
            return null;
        }
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        String propertyName = umlProperty.getName();
        if (propertyName == null) {
            return null;
        }
        for (EReference eReference : ((EClass)eClassifier).getEReferences()) {
            if (!propertyName.equals(eReference.getName())) continue;
            return eReference;
        }
        return null;
    }

    @Override
    public int getHandlerPriority(@NonNull EObject eObject) {
        if (eObject instanceof org.eclipse.uml2.uml.Element) {
            return 100;
        }
        if (eObject.eResource() instanceof UMLResource) {
            return 100;
        }
        return -100;
    }

    @Override
    public int getHandlerPriority(@NonNull Resource resource) {
        return UML2Pivot.isUML(resource) ? 100 : -100;
    }

    @Override
    public int getHandlerPriority(@NonNull URI uri) {
        return "uml".equals(uri.fileExtension()) ? 100 : -100;
    }

    @Override
    @Nullable
    public String getMetamodelNsURI(@NonNull EPackage ePackage) {
        if (ePackage instanceof UMLPackage) {
            return "http://www.omg.org/spec/UML/20131001";
        }
        if (ePackage.getClass().getName().startsWith(UMLPackage.class.getPackage().getName())) {
            return "http://www.omg.org/spec/UML/20131001";
        }
        return null;
    }

    @Override
    @Nullable
    public URI getPackageURI(@NonNull EObject eObject) {
        String uri;
        if (eObject instanceof Package && (uri = ((Package)eObject).getURI()) != null) {
            return URI.createURI((String)uri);
        }
        return null;
    }

    @Override
    @Nullable
    public Element importFromResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource umlResource, @Nullable URI uri) throws ParserException {
        String uriFragment;
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        conversion.setUMLURI(uri);
        Root pivotRoot = conversion.getPivotRoot();
        String string = uriFragment = uri != null ? uri.fragment() : null;
        if (uriFragment == null) {
            return pivotRoot;
        }
        EObject eObject = umlResource.getEObject(uriFragment);
        if (eObject == null) {
            return null;
        }
        return conversion.getCreated(Element.class, eObject);
    }
}

