/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.uml.Pivot2UML;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.uml2.uml.MultiplicityElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2UMLReferenceVisitor
extends AbstractExtendingVisitor<EObject, Pivot2UML> {
    private static final Logger logger = Logger.getLogger(Pivot2UMLReferenceVisitor.class);

    public Pivot2UMLReferenceVisitor(@NonNull Pivot2UML context) {
        super(context);
    }

    public <T extends org.eclipse.uml2.uml.Element> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            org.eclipse.uml2.uml.Element eObject = (org.eclipse.uml2.uml.Element)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2UML Reference pass");
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        org.eclipse.uml2.uml.Class umlClass = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Class.class, pivotClass);
        this.safeVisitAll((List)umlClass.getSuperClasses(), (List<? extends Element>)pivotClass.getSuperClass());
        return umlClass;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        org.eclipse.uml2.uml.DataType umlDataType = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.DataType.class, pivotDataType);
        return umlDataType;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        org.eclipse.uml2.uml.Operation umlOperation = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Operation.class, pivotOperation);
        this.safeVisitAll((List)umlOperation.getRaisedExceptions(), (List<? extends Element>)pivotOperation.getRaisedException());
        Type pivotType = pivotOperation.getType();
        if (pivotType == null) {
            return null;
        }
        org.eclipse.uml2.uml.Type umlType = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Type.class, pivotType);
        umlOperation.setType(umlType);
        return null;
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        return null;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        org.eclipse.uml2.uml.Property umlOpposite;
        org.eclipse.uml2.uml.Property umlProperty = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Property.class, pivotProperty);
        Property pivotOpposite = pivotProperty.getOpposite();
        if (pivotOpposite != null && (umlOpposite = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Property.class, pivotOpposite)) != null) {
            umlProperty.setOpposite(umlOpposite);
        }
        return (EObject)super.visitProperty(pivotProperty);
    }

    @Override
    public EObject visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        return null;
    }

    @Override
    public EObject visitTypedElement(@NonNull TypedElement pivotTypedElement) {
        org.eclipse.uml2.uml.TypedElement umlTypedElement = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.TypedElement.class, pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null) {
            return null;
        }
        org.eclipse.uml2.uml.Type umlType = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Type.class, pivotType);
        umlTypedElement.setType(umlType);
        return null;
    }

    @Override
    public EObject visitTypedMultiplicityElement(@NonNull TypedMultiplicityElement pivotTypedElement) {
        org.eclipse.uml2.uml.TypedElement umlTypedElement = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.TypedElement.class, pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null || pivotType instanceof VoidType) {
            if (umlTypedElement instanceof MultiplicityElement) {
                MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
                umlMultiplicityElement.setLower(1);
                umlMultiplicityElement.setUpper(1);
                umlMultiplicityElement.setIsOrdered(true);
                umlMultiplicityElement.setIsUnique(true);
            }
            umlTypedElement.setType(null);
            return null;
        }
        if (pivotType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)pivotType;
            Type elementType = collectionType.getElementType();
            org.eclipse.uml2.uml.Type umlElementType = elementType != null ? ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Type.class, elementType) : null;
            umlTypedElement.setType(umlElementType);
            if (umlTypedElement instanceof MultiplicityElement) {
                MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
                umlMultiplicityElement.setIsOrdered(collectionType.isOrdered());
                umlMultiplicityElement.setIsUnique(collectionType.isUnique());
                IntegerValue lower = collectionType.getLowerValue();
                IntegerValue upper = collectionType.getUpperValue();
                try {
                    umlMultiplicityElement.setLower(lower.intValue());
                }
                catch (InvalidValueException e) {
                    logger.error((Object)"Out of range lower bound", (Throwable)e);
                }
                try {
                    umlMultiplicityElement.setUpper(upper.isUnlimited() ? -1 : upper.intValue());
                }
                catch (InvalidValueException e) {
                    logger.error((Object)"Out of range upper bound", (Throwable)e);
                }
            }
            return null;
        }
        if (umlTypedElement instanceof MultiplicityElement) {
            MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
            if (pivotTypedElement.isRequired()) {
                umlMultiplicityElement.setLower(1);
                umlMultiplicityElement.setUpper(1);
            } else {
                umlMultiplicityElement.setLower(0);
                umlMultiplicityElement.setUpper(1);
            }
            umlMultiplicityElement.setIsUnique(true);
            umlMultiplicityElement.setIsOrdered(false);
        }
        org.eclipse.uml2.uml.Type umlType = ((Pivot2UML)this.context).getCreated(org.eclipse.uml2.uml.Type.class, pivotType);
        umlTypedElement.setType(umlType);
        return null;
    }
}

