/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceSlotNavigationProperty
extends AbstractProperty {
    @NonNull
    protected final Property property;
    @Nullable
    protected final CollectionTypeId collectionTypeId;

    public InstanceSlotNavigationProperty(@NonNull Property property, @Nullable CollectionTypeId collectionTypeId) {
        this.property = property;
        this.collectionTypeId = collectionTypeId;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        if (sourceValue != null) {
            InstanceSpecification instanceSpecification = (InstanceSpecification)sourceValue;
            for (Slot slot : instanceSpecification.getSlots()) {
                if (slot.getDefiningFeature() != this.property) continue;
                EList values = slot.getValues();
                CollectionTypeId collectionTypeId2 = this.collectionTypeId;
                int size = values.size();
                if (collectionTypeId2 != null) {
                    ArrayList<Object> unboxedValues = new ArrayList<Object>(size);
                    for (ValueSpecification value : values) {
                        unboxedValues.add(this.valueOf(value));
                    }
                    IdResolver idResolver = evaluator.getIdResolver();
                    return idResolver.createCollectionOfAll(collectionTypeId2, unboxedValues);
                }
                if (size >= 1) {
                    ValueSpecification valueSpecification = (ValueSpecification)values.get(0);
                    return this.valueOf(valueSpecification);
                }
                throw new InvalidValueException("no ValueSpecification in Slot", new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    private Object valueOf(@Nullable ValueSpecification valueSpecification) {
        if (valueSpecification == null) {
            throw new InvalidValueException("null ValueSpecification in Slot", new Object[0]);
        }
        if (valueSpecification instanceof LiteralBoolean) {
            return ((LiteralBoolean)valueSpecification).booleanValue();
        }
        if (valueSpecification instanceof LiteralInteger) {
            return ValuesUtil.integerValueOf((int)((LiteralInteger)valueSpecification).getValue());
        }
        if (valueSpecification instanceof LiteralNull) {
            return null;
        }
        if (valueSpecification instanceof LiteralReal) {
            return ValuesUtil.realValueOf((double)((LiteralReal)valueSpecification).getValue());
        }
        if (valueSpecification instanceof LiteralString) {
            return ((LiteralString)valueSpecification).getValue();
        }
        if (valueSpecification instanceof LiteralUnlimitedNatural) {
            int unlimitedValue = ((LiteralUnlimitedNatural)valueSpecification).unlimitedValue();
            return unlimitedValue < 0 ? ValuesUtil.UNLIMITED_VALUE : ValuesUtil.integerValueOf((int)unlimitedValue);
        }
        if (valueSpecification instanceof InstanceValue) {
            return ((InstanceValue)valueSpecification).getInstance();
        }
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".valueOf " + valueSpecification.eClass().getName());
    }
}

