/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.scoping;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.NullAttribution;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class PivotScopeView
implements ScopeView {
    @NonNull
    public static final ScopeView NULLSCOPEVIEW = new ScopeView(){

        @NonNull
        public Attribution getAttribution() {
            return NullAttribution.INSTANCE;
        }

        @Nullable
        public Element getChild() {
            return null;
        }

        @Nullable
        public EStructuralFeature getContainmentFeature() {
            return null;
        }

        @NonNull
        public ScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        @NonNull
        public ScopeView getRoot() {
            return NULLSCOPEVIEW;
        }

        public Element getTarget() {
            return null;
        }

        public boolean isQualified() {
            return false;
        }
    };
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Element target;
    @Nullable
    protected final Element child;
    protected final boolean isQualified;
    private ScopeView parent = null;
    private Attribution attribution = null;

    protected PivotScopeView(@NonNull MetaModelManager metaModelManager, @NonNull Element target, @Nullable Element child, boolean isQualified) {
        this.metaModelManager = metaModelManager;
        this.target = target;
        this.child = child;
        this.isQualified = isQualified;
    }

    @Nullable
    public ScopeView computeLookup(@NonNull EnvironmentView environmentView, @NonNull EObject aTarget) {
        assert (aTarget instanceof Element);
        if (this.attribution == null) {
            this.attribution = PivotUtil.getAttribution(this.target);
        }
        return this.attribution.computeLookup(aTarget, environmentView, this);
    }

    @NonNull
    public Attribution getAttribution() {
        Attribution attribution2 = this.attribution;
        if (attribution2 == null) {
            this.attribution = attribution2 = PivotUtil.getAttribution(this.target);
        }
        return attribution2;
    }

    @Nullable
    public Element getChild() {
        return this.child;
    }

    @Nullable
    public EStructuralFeature getContainmentFeature() {
        return this.child != null ? this.child.eContainmentFeature() : null;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public ScopeView getParent() {
        ScopeView parent2 = this.parent;
        if (parent2 == null) {
            EObject pParent = this.target.eContainer();
            parent2 = pParent instanceof Element ? new PivotScopeView(this.metaModelManager, (Element)pParent, this.target, this.isQualified) : NULLSCOPEVIEW;
            this.parent = parent2;
        }
        return parent2;
    }

    @NonNull
    public ScopeView getRoot() {
        ScopeView parent = this.getParent();
        if (parent == NULLSCOPEVIEW) {
            return this;
        }
        return parent.getRoot();
    }

    @NonNull
    public final Element getTarget() {
        return this.target;
    }

    public boolean isQualified() {
        return this.isQualified;
    }

    public String toString() {
        Element target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        EStructuralFeature containmentFeature = this.getContainmentFeature();
        if (containmentFeature != null) {
            s.append("::");
            s.append(containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

