/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.resource;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.EssentialOCLPrettyPrintVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactory;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.examples.pivot.resource.ASResourceImpl;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIid;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ASSaver;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverLocateVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverNormalizeVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ASSaverResolveVisitor;
import org.eclipse.ocl.examples.pivot.utilities.ToStringVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASResourceFactory
extends ResourceFactoryImpl
implements ASResourceFactory {
    @NonNull
    protected final String contentType;
    @Nullable
    protected final String fileExtension;

    public static void installContentHandler(int priority, @NonNull ContentHandler contentHandler) {
        ArrayList<ContentHandler> contentHandlers = (ArrayList<ContentHandler>)ContentHandler.Registry.INSTANCE.get((Object)priority);
        if (contentHandlers == null) {
            contentHandlers = new ArrayList<ContentHandler>();
            ContentHandler.Registry.INSTANCE.put((Object)priority, contentHandlers);
        }
        if (!contentHandlers.contains(contentHandler)) {
            contentHandlers.add(contentHandler);
        }
    }

    protected AbstractASResourceFactory(@NonNull String contentType, @Nullable String fileExtension) {
        this.contentType = contentType;
        this.fileExtension = fileExtension;
        ASResourceFactoryRegistry.INSTANCE.addASResourceFactory(contentType, this);
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getContentTypeToFactoryMap().put(this.contentType, this);
        if (this.fileExtension != null) {
            resourceFactoryRegistry.getExtensionToFactoryMap().put(this.fileExtension, this);
        }
    }

    protected void configureResource(@NonNull ASResource asResource) {
        asResource.setEncoding("UTF-8");
        Map defaultSaveOptions = asResource.getDefaultSaveOptions();
        defaultSaveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        defaultSaveOptions.put("LINE_WIDTH", 80);
        defaultSaveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        defaultSaveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSaveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
    }

    @Override
    @NonNull
    public AS2MonikerVisitor createAS2MonikerVisitor(@NonNull AS2Moniker as2moniker) {
        return new AS2MonikerVisitor(as2moniker);
    }

    @Override
    @NonNull
    public AS2XMIidVisitor createAS2XMIidVisitor(@NonNull AS2XMIid as2id) {
        return new AS2XMIidVisitor(as2id);
    }

    @Override
    @NonNull
    public ASSaverLocateVisitor createASSaverLocateVisitor(@NonNull ASSaver saver) {
        return new ASSaverLocateVisitor(saver);
    }

    @Override
    @NonNull
    public ASSaverNormalizeVisitor createASSaverNormalizeVisitor(@NonNull ASSaver saver) {
        return new ASSaverNormalizeVisitor(saver);
    }

    @Override
    @NonNull
    public ASSaverResolveVisitor createASSaverResolveVisitor(@NonNull ASSaver saver) {
        return new ASSaverResolveVisitor(saver);
    }

    @Override
    @NonNull
    public PrettyPrintVisitor createPrettyPrintVisitor(@NonNull PrettyPrinter prettyPrinter) {
        return new EssentialOCLPrettyPrintVisitor(prettyPrinter);
    }

    @Override
    @NonNull
    public ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
        return new ToStringVisitor(s);
    }

    public Resource createResource(URI uri) {
        assert (uri != null);
        ASResourceImpl result = new ASResourceImpl(uri, this);
        this.configureResource(result);
        return result;
    }

    @Override
    @Nullable
    public <T extends Element> T getASElement(@NonNull MetaModelManager metaModelManager, @NonNull Class<T> pivotClass, @NonNull EObject eObject) throws ParserException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".getPivotOf");
    }

    @Override
    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public EOperation getEOperation(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    @Nullable
    public EReference getEReference(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    public int getHandlerPriority(@NonNull EObject eObject) {
        return -100;
    }

    @Override
    public int getHandlerPriority(@NonNull Resource resource) {
        return -100;
    }

    @Override
    public int getHandlerPriority(@NonNull URI uri) {
        return -100;
    }

    @Override
    @Nullable
    public String getMetamodelNsURI(@NonNull EPackage ePackage) {
        return null;
    }

    @Override
    @Nullable
    public URI getPackageURI(@NonNull EObject eObject) {
        return null;
    }

    @Override
    @Nullable
    public Element importFromResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource resource, @Nullable URI uri) throws ParserException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".importFromResource");
    }

    @Override
    public boolean isCompatibleResource(@NonNull Resource newResource, @NonNull Resource oldResource) {
        return false;
    }

    @NonNull
    public String toString() {
        return this.contentType;
    }
}

