/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorManager;
import org.eclipse.ocl.examples.library.executor.LazyModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotExecutorManager
extends ExecutorManager {
    @NonNull
    protected final PivotIdResolver idResolver;
    @NonNull
    protected final EObject contextObject;
    @Nullable
    private DomainModelManager modelManager = null;

    public PivotExecutorManager(@NonNull MetaModelManager metaModelManager, @NonNull EObject contextObject) {
        super((DomainStandardLibrary)metaModelManager);
        this.idResolver = metaModelManager.getIdResolver();
        this.contextObject = contextObject;
    }

    @NonNull
    protected IdResolver createIdResolver() {
        return ((MetaModelManager)this.standardLibrary).getIdResolver();
    }

    @NonNull
    public DomainEvaluator createNestedEvaluator() {
        return new PivotExecutorManager((MetaModelManager)this.standardLibrary, this.contextObject);
    }

    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        return this.idResolver.getDynamicTypeOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DomainModelManager getModelManager() {
        Object modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            PivotExecutorManager pivotExecutorManager = this;
            synchronized (pivotExecutorManager) {
                modelManager2 = this.modelManager;
                if (modelManager2 == null) {
                    this.modelManager = modelManager2 = new LazyModelManager(this.contextObject){

                        protected boolean isInstance(@NonNull DomainType type, @NonNull EObject element) {
                            EClass eClass = (EClass)DomainUtil.nonNullEMF((Object)element.eClass());
                            DomainType elementType = PivotExecutorManager.this.idResolver.getType((EClassifier)eClass);
                            return elementType.conformsTo(PivotExecutorManager.this.standardLibrary, type);
                        }
                    };
                }
            }
        }
        return modelManager2;
    }

    @NonNull
    public IdResolver getIdResolver() {
        return this.idResolver;
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        return this.idResolver.getStaticTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }
}

