/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.base.Function;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

class PackageTracker
implements Adapter.Internal {
    public static Function<PackageTracker, DomainPackage> tracker2package = new Function<PackageTracker, DomainPackage>(){

        public DomainPackage apply(PackageTracker packageTracker) {
            return packageTracker.getPackage();
        }
    };
    @NonNull
    protected final PackageServer packageServer;
    @NonNull
    private final DomainPackage target;

    PackageTracker(@NonNull PackageServer packageServer, @NonNull DomainPackage target) {
        this.packageServer = packageServer;
        this.target = target;
        assert (!(target instanceof PackageServer));
        if (target instanceof Notifier) {
            ((Notifier)target).eAdapters().add((Object)this);
        }
    }

    void dispose() {
        PackageManager packageManager = this.packageServer.getPackageManager();
        for (DomainType type : this.target.getOwnedType()) {
            if (type == null) continue;
            packageManager.removedType(type);
        }
        this.packageServer.disposedPackageTracker(this);
        if (this.target instanceof Notifier) {
            ((Notifier)this.target).eAdapters().remove((Object)this);
        }
    }

    @NonNull
    public DomainPackage getPackage() {
        return this.target;
    }

    @NonNull
    final PackageServer getPackageServer() {
        return this.packageServer;
    }

    public Notifier getTarget() {
        return this.target instanceof Notifier ? (Notifier)this.target : null;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.packageServer.getPackageManager();
    }

    public void notifyChanged(Notification notification) {
        block20: {
            Object feature;
            int eventType;
            block19: {
                eventType = notification.getEventType();
                feature = notification.getFeature();
                if (feature != PivotPackage.Literals.PACKAGE__OWNED_TYPE) break block19;
                switch (eventType) {
                    case 3: {
                        Object value = notification.getNewValue();
                        if (value instanceof Type) {
                            this.packageServer.addedMemberType((Type)value);
                            break;
                        }
                        break block20;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            if (!(value instanceof Type)) continue;
                            this.packageServer.addedMemberType((Type)value);
                        }
                        break block20;
                    }
                    case 4: {
                        Object value = notification.getOldValue();
                        if (value instanceof Type) {
                            this.packageServer.removedMemberType((Type)value);
                            break;
                        }
                        break block20;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            if (!(value instanceof Type)) continue;
                            this.packageServer.removedMemberType((Type)value);
                        }
                    }
                }
                break block20;
            }
            if (feature == PivotPackage.Literals.PACKAGE__NESTED_PACKAGE) {
                switch (eventType) {
                    case 3: {
                        Object value = notification.getNewValue();
                        if (!(value instanceof Package)) break;
                        this.packageServer.addedMemberPackage((Package)value);
                        break;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            if (!(value instanceof Package)) continue;
                            this.packageServer.addedMemberPackage((Package)value);
                        }
                        break;
                    }
                    case 4: {
                        Object value = notification.getOldValue();
                        if (!(value instanceof Package)) break;
                        this.packageServer.removedMemberPackage((Package)value);
                        break;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            if (!(value instanceof Package)) continue;
                            this.packageServer.removedMemberPackage((Package)value);
                        }
                        break;
                    }
                }
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (this.target == newTarget);
    }

    public String toString() {
        return String.valueOf(this.target);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (this.target == oldTarget);
    }
}

