/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassServer
extends ExtensibleTypeServer {
    @Nullable
    private Map<Type, WeakReference<Metaclass<?>>> metaclasses = null;

    public MetaclassServer(@NonNull PackageServer packageServer, @NonNull Metaclass<?> domainType) {
        super(packageServer, domainType);
    }

    @NonNull
    protected Metaclass<?> createMetaclass(@NonNull Type type) {
        MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        DomainType metaclassType = metaModelManager.getMetaclassType();
        Metaclass metaclass = PivotFactory.eINSTANCE.createMetaclass();
        metaclass.setName(metaclassType.getName());
        metaclass.setInstanceType(type);
        metaclass.setUnspecializedElement((TemplateableElement)metaclassType);
        TemplateSignature templateSignature = metaclassType.getOwnedTemplateSignature();
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        TemplateParameter formalParameter = templateSignature.getOwnedParameter().get(0);
        allBindings.put(formalParameter, type);
        TemplateParameterSubstitution templateParameterSubstitution = MetaclassServer.createTemplateParameterSubstitution(formalParameter, type);
        templateBinding.getParameterSubstitution().add(templateParameterSubstitution);
        metaclass.getTemplateBinding().add(templateBinding);
        this.packageManager.resolveSuperClasses(metaclass, (Type)metaclassType, allBindings);
        Orphanage orphanage = Orphanage.getOrphanage(metaModelManager.getASResourceSet());
        metaclass.setPackage(orphanage);
        return metaclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Metaclass<?> getMetaclass(@NonNull Type type) {
        Object object;
        assert (this.getPivotType() instanceof Metaclass);
        TemplateSignature templateSignature = this.getPivotType().getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() != 1) {
            throw new IllegalArgumentException("Incompatible metaclass template argument count");
        }
        Map<Type, WeakReference<Metaclass<?>>> metaclasses2 = this.metaclasses;
        if (metaclasses2 == null) {
            object = this;
            synchronized (object) {
                metaclasses2 = this.metaclasses;
                if (metaclasses2 == null) {
                    this.metaclasses = new HashMap();
                    metaclasses2 = this.metaclasses;
                }
            }
        }
        object = metaclasses2;
        synchronized (object) {
            Metaclass<?> metaclass = null;
            WeakReference<Metaclass<?>> weakReference = metaclasses2.get(type);
            if (weakReference != null) {
                metaclass = (Metaclass<?>)weakReference.get();
            }
            if (metaclass == null) {
                metaclass = this.createMetaclass(type);
                metaclasses2.put(type, new WeakReference(metaclass));
            }
            return metaclass;
        }
    }
}

