/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.domain.compatibility.EMF_2_9;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainNamespace;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.library.UnsupportedOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.ProjectMap;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.manager.CollectionTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ImplementationManager;
import org.eclipse.ocl.examples.pivot.manager.LambdaTypeManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManageable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaclassServer;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.manager.PivotStandardLibrary;
import org.eclipse.ocl.examples.pivot.manager.PrecedenceManager;
import org.eclipse.ocl.examples.pivot.manager.TemplateableTypeServer;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.model.OCLMetaModel;
import org.eclipse.ocl.examples.pivot.model.OCLstdlib;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactory;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIid;
import org.eclipse.ocl.examples.pivot.utilities.CompleteElementIterable;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.IllegalMetamodelException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelManager
extends PivotStandardLibrary
implements Adapter.Internal,
MetaModelManageable {
    private static final Logger logger = Logger.getLogger(MetaModelManager.class);
    @NonNull
    public static final TracingOption CREATE_MUTABLE_CLONE = new TracingOption("org.eclipse.ocl.examples.pivot", "mm/createMutableClone");
    @NonNull
    public static final List<Comment> EMPTY_COMMENT_LIST = Collections.emptyList();
    @NonNull
    public static final List<Constraint> EMPTY_CONSTRAINT_LIST = Collections.emptyList();
    @NonNull
    public static final List<Element> EMPTY_ELEMENT_LIST = Collections.emptyList();
    @NonNull
    public static final List<Operation> EMPTY_OPERATION_LIST = Collections.emptyList();
    @NonNull
    public static final List<Property> EMPTY_PROPERTY_LIST = Collections.emptyList();
    @NonNull
    public static final List<State> EMPTY_STATE_LIST = Collections.emptyList();
    @NonNull
    public static final List<TemplateParameter> EMPTY_TEMPLATE_PARAMETER_LIST = Collections.emptyList();
    @NonNull
    public static final List<Type> EMPTY_TYPE_LIST = Collections.emptyList();
    @NonNull
    public static final List<TypeServer> EMPTY_TYPE_SERVER_LIST = Collections.emptyList();
    public static WeakHashMap<MetaModelManager, Object> liveMetaModelManagers = null;
    @NonNull
    private final PackageManager packageManager = this.createPackageManager();
    private PrecedenceManager precedenceManager = null;
    private TupleTypeManager tupleManager = null;
    private LambdaTypeManager lambdaManager = null;
    private ImplementationManager implementationManager = null;
    private Orphanage orphanage = null;
    protected DomainPackage asMetamodel = null;
    private boolean libraryLoadInProgress = false;
    @NonNull
    protected final ResourceSet asResourceSet;
    @NonNull
    protected final List<Library> asLibraries = new ArrayList<Library>();
    @Nullable
    protected Resource asLibraryResource = null;
    @Nullable
    protected ResourceSetImpl externalResourceSet = null;
    @NonNull
    private final Map<String, DomainNamespace> globalNamespaces = new HashMap<String, DomainNamespace>();
    @NonNull
    private final Set<Type> globalTypes = new HashSet<Type>();
    private int unspecifiedTypeCount = 0;
    @NonNull
    private final Map<URI, External2Pivot> external2PivotMap = new HashMap<URI, External2Pivot>();
    @NonNull
    protected final PivotIdResolver idResolver;
    @Nullable
    private EAnnotation lockingAnnotation = null;
    @Nullable
    private List<MetaModelManagerListener> listeners = null;
    private boolean autoLoadASMetamodel = true;
    @Nullable
    private Map<String, GenPackage> genPackageMap = null;

    @Nullable
    public static MetaModelManager findAdapter(@Nullable ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return PivotUtil.getAdapter(MetaModelManager.class, (Notifier)resourceSet);
    }

    @NonNull
    public static MetaModelManager getAdapter(@NonNull ResourceSet resourceSet) {
        List eAdapters = (List)DomainUtil.nonNullEMF((Object)resourceSet.eAdapters());
        MetaModelManager adapter = PivotUtil.getAdapter(MetaModelManager.class, eAdapters);
        if (adapter == null) {
            if (resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get("org.eclipse.ocl.examples.oclas") == null) {
                MetaModelManager.initializeASResourceSet(resourceSet);
            }
            adapter = new MetaModelManager(resourceSet);
        }
        return adapter;
    }

    public static void initializeASResourceSet(@NonNull ResourceSet asResourceSet) {
        StandaloneProjectMap.initializeURIResourceMap((ResourceSet)asResourceSet);
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet(asResourceSet);
        EPackage.Registry packageRegistry = asResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/3.1.0/Pivot", (Object)PivotPackage.eINSTANCE);
    }

    public MetaModelManager() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public MetaModelManager(@NonNull StandaloneProjectMap projectMap) {
        this();
        this.asResourceSet.eAdapters().add((Object)projectMap);
    }

    public MetaModelManager(@NonNull ResourceSet asResourceSet) {
        if (asResourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get("org.eclipse.ocl.examples.oclas") == null) {
            MetaModelManager.initializeASResourceSet(asResourceSet);
        }
        this.idResolver = this.createIdResolver();
        this.asResourceSet = asResourceSet;
        asResourceSet.eAdapters().add((Object)this);
        if (liveMetaModelManagers != null) {
            liveMetaModelManagers.put(this, null);
            System.out.println(String.valueOf(Thread.currentThread().getName()) + " Create " + PivotUtil.debugSimpleName((Object)this) + " " + PivotUtil.debugSimpleName((Object)asResourceSet));
        }
    }

    public void addClassLoader(@NonNull ClassLoader classLoader) {
        ImplementationManager implementationManager = this.getImplementationManager();
        implementationManager.addClassLoader(classLoader);
    }

    public void addExternalResource(@NonNull External2Pivot external2Pivot) {
        URI uri = external2Pivot.getURI();
        Resource resource = external2Pivot.getResource();
        if (resource != null && DomainUtil.isRegistered((Resource)resource)) {
            ResourceSet externalResourceSet2 = this.getExternalResourceSet();
            this.getProjectMap().useGeneratedResource(resource, externalResourceSet2);
        }
        this.external2PivotMap.put(uri, external2Pivot);
    }

    public void addGenModel(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            this.addGenPackage(genPackage);
        }
    }

    public void addGenPackage(@NonNull GenPackage genPackage) {
        Map<String, GenPackage> genPackageMap2 = this.genPackageMap;
        if (genPackageMap2 == null) {
            this.genPackageMap = genPackageMap2 = new HashMap<String, GenPackage>();
        }
        genPackageMap2.put(genPackage.getNSURI(), genPackage);
    }

    @Nullable
    public DomainNamespace addGlobalNamespace(@NonNull String name, @NonNull DomainNamespace namespace) {
        return this.globalNamespaces.put(name, namespace);
    }

    public boolean addGlobalTypes(@NonNull Collection<Type> types) {
        return this.globalTypes.addAll(types);
    }

    public void addListener(@NonNull MetaModelManagerListener listener) {
        List<MetaModelManagerListener> listeners2 = this.listeners;
        if (listeners2 == null) {
            this.listeners = listeners2 = new ArrayList<MetaModelManagerListener>();
        }
        if (!listeners2.contains(listener)) {
            listeners2.add(listener);
        }
    }

    public void addLockedElement(@NonNull Object lockedElement) {
        if (lockedElement instanceof EObject) {
            EList lockingReferences;
            EAnnotation lockingAnnotation2 = this.lockingAnnotation;
            if (lockingAnnotation2 == null) {
                this.lockingAnnotation = lockingAnnotation2 = EcoreFactory.eINSTANCE.createEAnnotation();
            }
            if (!(lockingReferences = lockingAnnotation2.getReferences()).contains(lockedElement)) {
                lockingReferences.add((EObject)lockedElement);
            }
        }
    }

    public void addOrphanClass(@NonNull Type pivotElement) {
        if (pivotElement.getUnspecializedElement() != null ? !$assertionsDisabled && pivotElement.getUnspecializedElement().getUnspecializedElement() != null : !$assertionsDisabled && !(pivotElement instanceof LambdaType) && !(pivotElement instanceof TupleType) && !(pivotElement instanceof UnspecifiedType)) {
            throw new AssertionError();
        }
        pivotElement.setPackage(this.getOrphanage());
    }

    @Deprecated
    public void assignLibraryIds(@NonNull AS2XMIid as2xmIid) {
        this.assignLibraryIds(as2xmIid, null);
    }

    public void assignLibraryIds(@NonNull AS2XMIid as2xmIid, @Nullable Map<?, ?> options) {
        for (Library asLibrary : this.asLibraries) {
            Resource eResource = asLibrary.eResource();
            if (!(eResource instanceof ASResource)) continue;
            as2xmIid.assignIds((ASResource)eResource, options);
        }
    }

    public int compareOperationMatches(@NonNull Operation reference, @Nullable Map<TemplateParameter, ParameterableElement> referenceBindings, @NonNull Operation candidate, @Nullable Map<TemplateParameter, ParameterableElement> candidateBindings) {
        if (reference instanceof Iteration && candidate instanceof Iteration) {
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterator().size() - ((Iteration)reference).getOwnedIterator().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            Type referenceType = PivotUtil.getOwningType(reference);
            Type candidateType = PivotUtil.getOwningType(candidate);
            Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
            Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
            if (referenceType != candidateType) {
                if (this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                    return 1;
                }
                if (this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                    return -1;
                }
            }
        }
        List<Parameter> candidateParameters = candidate.getOwnedParameter();
        List<Parameter> referenceParameters = reference.getOwnedParameter();
        int parameterCountDelta = candidateParameters.size() - referenceParameters.size();
        if (parameterCountDelta != 0) {
            return parameterCountDelta;
        }
        boolean referenceConformsToCandidate = true;
        boolean candidateConformsToReference = true;
        int i = 0;
        while (i < candidateParameters.size()) {
            Parameter referenceParameter = referenceParameters.get(i);
            Parameter candidateParameter = candidateParameters.get(i);
            if (referenceParameter == null || candidateParameter == null) {
                referenceConformsToCandidate = false;
                candidateConformsToReference = false;
            } else {
                Type referenceType = PivotUtil.getBehavioralType(referenceParameter);
                Type candidateType = PivotUtil.getBehavioralType(candidateParameter);
                Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
                Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
                if (referenceType != candidateType) {
                    if (!this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                        referenceConformsToCandidate = false;
                    }
                    if (!this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                        candidateConformsToReference = false;
                    }
                }
            }
            ++i;
        }
        if (referenceConformsToCandidate != candidateConformsToReference) {
            return referenceConformsToCandidate ? 1 : -1;
        }
        Type referenceType = (Type)DomainUtil.nonNullModel((Object)PivotUtil.getOwningType(reference));
        Type candidateType = (Type)DomainUtil.nonNullModel((Object)PivotUtil.getOwningType(candidate));
        Type specializedReferenceType = this.getSpecializedType(referenceType, referenceBindings);
        Type specializedCandidateType = this.getSpecializedType(candidateType, candidateBindings);
        if (referenceType != candidateType) {
            if (this.conformsTo(specializedReferenceType, specializedCandidateType, null)) {
                return 1;
            }
            if (this.conformsTo(specializedCandidateType, specializedReferenceType, null)) {
                return -1;
            }
        }
        return 0;
    }

    public void configureLoadFirstStrategy() {
        this.configureLoadStrategy(StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
    }

    public void configureLoadStrategy(@NonNull StandaloneProjectMap.IResourceLoadStrategy packageLoadStrategy, @Nullable StandaloneProjectMap.IConflictHandler conflictHandler) {
        ResourceSet externalResourceSet = this.getExternalResourceSet();
        StandaloneProjectMap projectMap = this.getProjectMap();
        projectMap.configure(externalResourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
    }

    public boolean conformsTo(@NonNull Type firstType, @NonNull Type secondType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstType);
                    return true;
                }
            }
        }
        if (firstType == secondType) {
            return true;
        }
        if ((firstType = this.getPrimaryType(firstType)) == (secondType = this.getPrimaryType(secondType))) {
            return true;
        }
        if ((firstType = PivotUtil.getType(firstType)) == (secondType = PivotUtil.getType(secondType))) {
            return true;
        }
        if (secondType instanceof AnyType) {
            return true;
        }
        if (firstType instanceof AnyType) {
            return false;
        }
        if (firstType instanceof InvalidType) {
            return true;
        }
        if (secondType instanceof InvalidType) {
            return false;
        }
        if (firstType instanceof VoidType) {
            return true;
        }
        if (secondType instanceof VoidType) {
            return false;
        }
        if (firstType instanceof Metaclass) {
            if (secondType instanceof Metaclass) {
                return this.conformsToMetaclass((Metaclass)firstType, (Metaclass)secondType, bindings);
            }
        } else {
            if (firstType instanceof CollectionType) {
                if (secondType instanceof CollectionType) {
                    return this.conformsToCollectionType((CollectionType)firstType, (CollectionType)secondType, bindings);
                }
                return false;
            }
            if (firstType instanceof LambdaType) {
                if (secondType instanceof LambdaType) {
                    return this.conformsToLambdaType((LambdaType)firstType, (LambdaType)secondType, bindings);
                }
                return false;
            }
            if (firstType instanceof TupleType) {
                if (secondType instanceof TupleType) {
                    return this.conformsToTupleType((TupleType)firstType, (TupleType)secondType, bindings);
                }
                return false;
            }
        }
        for (Type superClass : this.getSuperClasses(firstType)) {
            if (superClass == null || !this.conformsTo(superClass, secondType, bindings)) continue;
            return true;
        }
        return false;
    }

    public boolean conformsToCollectionType(@NonNull DomainCollectionType firstCollectionType, @NonNull DomainCollectionType secondCollectionType) {
        Map<TemplateParameter, ParameterableElement> bindings = secondCollectionType instanceof EObject ? PivotUtil.getAllTemplateParametersAsBindings((EObject)secondCollectionType) : null;
        return this.conformsToCollectionType((CollectionType)firstCollectionType, (CollectionType)secondCollectionType, bindings);
    }

    protected boolean conformsToCollectionType(@NonNull CollectionType firstType, @NonNull CollectionType secondType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        IntegerValue secondUpper;
        IntegerValue secondLower;
        CollectionType unspecializedFirstType = PivotUtil.getUnspecializedTemplateableElement(firstType);
        CollectionType unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (!this.isSuperClassOf(unspecializedSecondType, unspecializedFirstType)) {
            return false;
        }
        Type firstElementType = firstType.getElementType();
        Type secondElementType = secondType.getElementType();
        if (firstElementType == null || secondElementType == null) {
            return false;
        }
        IntegerValue firstLower = firstType.getLowerValue();
        if (firstLower.compareTo((Object)(secondLower = secondType.getLowerValue())) < 0) {
            return false;
        }
        IntegerValue firstUpper = firstType.getUpperValue();
        if (firstUpper.compareTo((Object)(secondUpper = secondType.getUpperValue())) > 0) {
            return false;
        }
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstElementType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondElementType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType == secondElementType) {
            return true;
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (lowerBound != null && this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (upperBound != null && this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    protected boolean conformsToLambdaType(@NonNull LambdaType actualType, @NonNull LambdaType requiredType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        Type actualContextType = actualType.getContextType();
        Type requiredContextType = requiredType.getContextType();
        if (actualContextType == null || requiredContextType == null) {
            return false;
        }
        if (!this.conformsTo(actualContextType, requiredContextType, bindings)) {
            return false;
        }
        Type actualResultType = actualType.getResultType();
        Type requiredResultType = requiredType.getResultType();
        if (actualResultType == null || requiredResultType == null) {
            return false;
        }
        if (!this.conformsTo(requiredResultType, actualResultType, bindings)) {
            return false;
        }
        List<Type> actualParameterTypes = actualType.getParameterType();
        List<Type> requiredParameterTypes = requiredType.getParameterType();
        int iMax = actualParameterTypes.size();
        if (iMax != requiredParameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            Type actualParameterType = actualParameterTypes.get(i);
            Type requiredParameterType = requiredParameterTypes.get(i);
            if (actualParameterType == null || requiredParameterType == null) {
                return false;
            }
            if (!this.conformsTo(actualParameterType, requiredParameterType, bindings)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean conformsToMetaclass(@NonNull Metaclass<?> firstType, @NonNull Metaclass<?> secondType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        Type firstElementType = firstType.getInstanceType();
        Type secondElementType = secondType.getInstanceType();
        if (bindings != null) {
            TemplateParameter secondTemplateParameter;
            ParameterableElement parameterableElement;
            TemplateParameter firstTemplateParameter = firstElementType.getOwningTemplateParameter();
            if (firstTemplateParameter != null && (parameterableElement = bindings.get(firstTemplateParameter)) instanceof Type) {
                firstElementType = (Type)parameterableElement;
            }
            if ((secondTemplateParameter = secondElementType.getOwningTemplateParameter()) != null) {
                ParameterableElement parameterableElement2 = bindings.get(secondTemplateParameter);
                if (parameterableElement2 instanceof Type) {
                    secondElementType = (Type)parameterableElement2;
                } else if (parameterableElement2 == null && bindings.containsKey(secondTemplateParameter)) {
                    bindings.put(secondTemplateParameter, firstElementType);
                    return true;
                }
            }
        }
        if (firstElementType == null || secondElementType == null) {
            return false;
        }
        if (firstElementType instanceof UnspecifiedType) {
            Type lowerBound = ((UnspecifiedType)firstElementType).getLowerBound();
            if (lowerBound != null && this.conformsTo(secondElementType, lowerBound, bindings)) {
                ((UnspecifiedType)firstElementType).setLowerBound(secondElementType);
                return true;
            }
            return false;
        }
        if (secondElementType instanceof UnspecifiedType) {
            Type upperBound = ((UnspecifiedType)secondElementType).getUpperBound();
            if (upperBound != null && this.conformsTo(upperBound, firstElementType, bindings)) {
                ((UnspecifiedType)secondElementType).setUpperBound(firstElementType);
                return true;
            }
            return false;
        }
        return this.conformsTo(firstElementType, secondElementType, bindings);
    }

    protected boolean conformsToTupleType(@NonNull TupleType actualType, @NonNull TupleType requiredType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        List<Property> actualProperties = actualType.getOwnedAttribute();
        List<Property> requiredProperties = requiredType.getOwnedAttribute();
        if (actualProperties.size() != requiredProperties.size()) {
            return false;
        }
        for (Property actualProperty : actualProperties) {
            Property requiredProperty = (Property)DomainUtil.getNamedElement(requiredProperties, (String)actualProperty.getName());
            if (requiredProperty == null) {
                return false;
            }
            Type actualPropertyType = actualProperty.getType();
            Type requiredPropertyType = requiredProperty.getType();
            if (actualPropertyType == null || requiredPropertyType == null) {
                return false;
            }
            if (this.conformsTo(actualPropertyType, requiredPropertyType, bindings)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    protected PivotIdResolver createIdResolver() {
        return new PivotIdResolver(this);
    }

    @NonNull
    protected ImplementationManager createImplementationManager() {
        return new ImplementationManager(this);
    }

    @NonNull
    public InvalidLiteralExp createInvalidExpression() {
        InvalidLiteralExp invalidLiteralExp = PivotFactory.eINSTANCE.createInvalidLiteralExp();
        invalidLiteralExp.setType(this.getOclInvalidType());
        return invalidLiteralExp;
    }

    @NonNull
    protected LambdaTypeManager createLambdaManager() {
        return new LambdaTypeManager(this);
    }

    @NonNull
    protected Orphanage createOrphanage() {
        return Orphanage.getOrphanage(this.asResourceSet);
    }

    @NonNull
    public <T extends Package> T createPackage(@NonNull Class<T> pivotClass, @NonNull EClass pivotEClass, @NonNull String name, @Nullable String nsURI) {
        Package asPackage = (Package)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        asPackage.setName(name);
        asPackage.setNsURI(nsURI);
        return (T)asPackage;
    }

    @NonNull
    protected PackageManager createPackageManager() {
        return new PackageManager(this);
    }

    @NonNull
    protected PrecedenceManager createPrecedenceManager() {
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List<String> errors = precedenceManager.compilePrecedences(this.asLibraries);
        for (String error : errors) {
            logger.error((Object)error);
        }
        return precedenceManager;
    }

    @Deprecated
    @NonNull
    public ASResource createResource(@NonNull URI uri, @Nullable String contentType) {
        return this.getResource(uri, contentType);
    }

    @NonNull
    public Root createRoot(String externalURI) {
        return this.createRoot(Root.class, PivotPackage.Literals.ROOT, externalURI);
    }

    @Deprecated
    @NonNull
    public Root createRoot(String name, String externalURI) {
        return this.createRoot(Root.class, PivotPackage.Literals.ROOT, externalURI);
    }

    @Deprecated
    @NonNull
    public <T extends Root> T createRoot(@NonNull Class<T> pivotClass, EClass pivotEClass, String name, String externalURI) {
        return this.createRoot(pivotClass, pivotEClass, externalURI);
    }

    @NonNull
    public <T extends Root> T createRoot(@NonNull Class<T> pivotClass, EClass pivotEClass, String externalURI) {
        assert (pivotEClass != null);
        Root pivotRoot = (Root)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        pivotRoot.setExternalURI(externalURI);
        return (T)pivotRoot;
    }

    @NonNull
    protected TupleTypeManager createTupleManager() {
        return new TupleTypeManager(this);
    }

    @NonNull
    public UnspecifiedType createUnspecifiedType() {
        String value = "<unspecified:" + this.unspecifiedTypeCount++ + ">";
        UnspecifiedType unspecifiedType = PivotFactory.eINSTANCE.createUnspecifiedType();
        unspecifiedType.setName(value);
        unspecifiedType.setLowerBound(this.getOclAnyType());
        unspecifiedType.setUpperBound(this.getOclVoidType());
        this.addOrphanClass(unspecifiedType);
        return unspecifiedType;
    }

    @Override
    public void dispose() {
        if (this.listeners != null) {
            List<MetaModelManagerListener> savedListeners = this.listeners;
            this.listeners = null;
            for (MetaModelManagerListener metaModelManagerListener : savedListeners) {
                metaModelManagerListener.metaModelManagerDisposed(this);
            }
        }
        this.asResourceSet.eAdapters().remove((Object)this);
        for (Resource resource : this.asResourceSet.getResources()) {
            resource.unload();
        }
        this.asResourceSet.getResources().clear();
        this.asResourceSet.setPackageRegistry(null);
        this.asResourceSet.setResourceFactoryRegistry(null);
        this.asResourceSet.setURIConverter(null);
        this.asLibraries.clear();
        this.asLibraryResource = null;
        StandaloneProjectMap.dispose((ResourceSet)this.asResourceSet);
        ResourceSetImpl externalResourceSet2 = this.externalResourceSet;
        if (externalResourceSet2 != null) {
            StandaloneProjectMap.dispose((ResourceSet)externalResourceSet2);
            externalResourceSet2.setPackageRegistry(null);
            externalResourceSet2.setResourceFactoryRegistry(null);
            externalResourceSet2.setURIConverter(null);
            externalResourceSet2.setURIResourceMap(null);
            for (Resource resource : externalResourceSet2.getResources()) {
                resource.unload();
            }
            this.externalResourceSet = null;
        }
        this.globalNamespaces.clear();
        this.globalTypes.clear();
        this.external2PivotMap.clear();
        this.lockingAnnotation = null;
        this.idResolver.dispose();
        this.packageManager.dispose();
        if (this.tupleManager != null) {
            this.tupleManager.dispose();
            this.tupleManager = null;
        }
        if (this.lambdaManager != null) {
            this.lambdaManager.dispose();
            this.lambdaManager = null;
        }
        if (this.precedenceManager != null) {
            this.precedenceManager.dispose();
            this.precedenceManager = null;
        }
        if (this.implementationManager != null) {
            this.implementationManager.dispose();
            this.implementationManager = null;
        }
        this.orphanage = null;
        this.asMetamodel = null;
        super.dispose();
    }

    protected void finalize() throws Throwable {
        if (liveMetaModelManagers != null) {
            System.out.println("Finalize " + PivotUtil.debugSimpleName((Object)this));
            ArrayList<MetaModelManager> keySet = new ArrayList<MetaModelManager>(liveMetaModelManagers.keySet());
            if (!keySet.isEmpty()) {
                StringBuilder s = new StringBuilder();
                s.append(" live");
                for (MetaModelManager metaModelManager : keySet) {
                    s.append(" @" + Integer.toHexString(metaModelManager.hashCode()));
                }
                System.out.println(s);
            }
        }
    }

    @NonNull
    public Iterable<Constraint> getAllInvariants(@NonNull Type pivotType) {
        HashSet<Constraint> knownInvariants = new HashSet<Constraint>();
        for (DomainType domainType : this.getPartialTypes(pivotType)) {
            if (!(domainType instanceof Type)) continue;
            knownInvariants.addAll(((Type)domainType).getOwnedInvariant());
        }
        for (DomainType domainType : this.getAllSuperClasses(pivotType)) {
            if (domainType == null) continue;
            for (DomainType domainType2 : this.getPartialTypes(domainType)) {
                if (!(domainType2 instanceof Type)) continue;
                knownInvariants.addAll(((Type)domainType2).getOwnedInvariant());
            }
        }
        return knownInvariants;
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@NonNull DomainType type, @Nullable FeatureFilter featureFilter) {
        TypeServer typeServer = this.packageManager.getTypeServer(type);
        return typeServer.getAllOperations(featureFilter);
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@NonNull DomainType type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        TypeServer typeServer = this.packageManager.getTypeServer(type);
        return typeServer.getAllOperations(featureFilter, name);
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@NonNull DomainOperation pivotOperation) {
        Iterable<? extends DomainOperation> memberOperations;
        DomainInheritance pivotClass = pivotOperation.getInheritance((DomainStandardLibrary)this);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        ExtensibleTypeServer typeServer = this.packageManager.findTypeServer((DomainType)pivotClass);
        if (typeServer != null && (memberOperations = typeServer.getMemberOperations(pivotOperation)) != null) {
            return memberOperations;
        }
        List<DomainOperation> singletonList = Collections.singletonList(pivotOperation);
        return singletonList;
    }

    @NonNull
    public Iterable<PackageServer> getAllPackages() {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASMetamodel();
        }
        return this.packageManager.getAllPackages();
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@NonNull DomainType type, @Nullable FeatureFilter featureFilter) {
        TypeServer typeServer = this.packageManager.getTypeServer(type);
        return typeServer.getAllProperties(featureFilter);
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@NonNull DomainType type, @Nullable FeatureFilter featureFilter, @NonNull String name) {
        TypeServer typeServer = this.packageManager.getTypeServer(type);
        return typeServer.getAllProperties(featureFilter, name);
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@NonNull DomainProperty pivotProperty) {
        Iterable<? extends DomainProperty> memberProperties;
        DomainInheritance pivotClass = pivotProperty.getInheritance((DomainStandardLibrary)this);
        if (pivotClass == null) {
            throw new IllegalStateException("Missing owning type");
        }
        ExtensibleTypeServer typeServer = this.packageManager.findTypeServer((DomainType)pivotClass);
        if (typeServer != null && (memberProperties = typeServer.getMemberProperties(pivotProperty)) != null) {
            return memberProperties;
        }
        List<DomainProperty> singletonList = Collections.singletonList(pivotProperty);
        return singletonList;
    }

    @NonNull
    public Iterable<? extends DomainType> getAllSuperClasses(@NonNull DomainType type) {
        TypeServer typeServer = this.packageManager.getTypeServer(type);
        return typeServer.getAllSuperClasses();
    }

    @Deprecated
    @NonNull
    public Iterable<Type> getAllTypes(@NonNull Type pivotType) {
        ExtensibleTypeServer typeServer = this.packageManager.findTypeServer(pivotType);
        if (typeServer != null) {
            Iterable filter = Iterables.filter(typeServer.getPartialTypes(), Type.class);
            return filter;
        }
        List<Type> singletonList = Collections.singletonList(pivotType);
        return singletonList;
    }

    @Nullable
    public DomainPackage getASMetamodel() {
        if (this.asMetamodel == null && this.autoLoadASMetamodel) {
            Package stdlibPackage = null;
            this.getOclAnyType();
            if (!this.asLibraries.isEmpty()) {
                stdlibPackage = this.asLibraries.get(0);
            }
            if (stdlibPackage != null) {
                this.loadASMetamodel(stdlibPackage);
            }
        }
        return this.asMetamodel;
    }

    @NonNull
    public ResourceSet getASResourceSet() {
        return this.asResourceSet;
    }

    @NonNull
    public CollectionType getBagType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getBagType(this.getType(elementType), lower, upper);
    }

    @NonNull
    public CollectionType getBagType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType((CollectionType)this.getBagType(), elementType, lower, upper);
    }

    @Nullable
    public OpaqueExpression getBodyExpression(@NonNull Operation operation) {
        OpaqueExpression bodyExpression = null;
        for (DomainOperation domainOperation : this.getAllOperations(operation)) {
            OpaqueExpression anExpression;
            if (!(domainOperation instanceof Operation) || (anExpression = ((Operation)domainOperation).getBodyExpression()) == null) continue;
            if (bodyExpression != null) {
                throw new IllegalStateException("Multiple bodies for " + operation);
            }
            bodyExpression = anExpression;
        }
        return bodyExpression;
    }

    @NonNull
    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return this.getOrderedSetType();
            }
            return this.getSequenceType();
        }
        if (isUnique) {
            return this.getSetType();
        }
        return this.getBagType();
    }

    @NonNull
    public CollectionType getCollectionType(@NonNull DomainType containerType, @NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType((CollectionType)this.getType(containerType), this.getType(elementType), lower, upper);
    }

    @NonNull
    public CollectionType getCollectionType(boolean isOrdered, boolean isUnique, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType(this.getCollectionType(isOrdered, isUnique), elementType, lower, upper);
    }

    @NonNull
    public Type getCollectionType(@NonNull String collectionTypeName, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        if (elementType.eIsProxy()) {
            return this.getOclInvalidType();
        }
        return this.getCollectionType((CollectionType)this.getRequiredLibraryType(collectionTypeName), elementType, lower, upper);
    }

    @NonNull
    public <T extends CollectionType> T getCollectionType(@NonNull T containerType, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        boolean isUnspecialized;
        assert (containerType == PivotUtil.getUnspecializedTemplateableElement(containerType));
        TemplateSignature templateSignature = containerType.getOwnedTemplateSignature();
        if (templateSignature == null) {
            throw new IllegalArgumentException("Collection type must have a template signature");
        }
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() != 1) {
            throw new IllegalArgumentException("Collection type must have exactly one template parameter");
        }
        boolean bl = isUnspecialized = elementType == templateParameters.get(0).getParameteredElement();
        if (isUnspecialized) {
            return containerType;
        }
        TypeServer typeServer2 = this.getTypeServer(containerType);
        CollectionTypeServer typeServer = (CollectionTypeServer)typeServer2;
        CollectionType specializedType = (CollectionType)typeServer.getSpecializedType(elementType, lower, upper);
        return (T)specializedType;
    }

    @NonNull
    public Set<DomainInheritance> getCommonClasses(@NonNull Type leftClass, @NonNull Type rightClass, @NonNull Set<DomainInheritance> commonClasses) {
        if (this.conformsTo(rightClass, leftClass, null)) {
            commonClasses.add(leftClass.getInheritance((DomainStandardLibrary)this));
        }
        for (Type superClass : leftClass.getSuperClass()) {
            if (superClass == null) continue;
            Set<DomainInheritance> commonSuperClasses = this.getCommonClasses(superClass, rightClass, commonClasses);
            commonClasses.addAll(commonSuperClasses);
        }
        return commonClasses;
    }

    @NonNull
    public Type getCommonType(@NonNull Type leftType, @NonNull Type rightType, @Nullable Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions) {
        if (leftType instanceof UnspecifiedType) {
            ((UnspecifiedType)leftType).setUpperBound(rightType);
            return rightType;
        }
        if (rightType instanceof UnspecifiedType) {
            ((UnspecifiedType)rightType).setUpperBound(leftType);
            return leftType;
        }
        if (leftType instanceof TupleType && rightType instanceof TupleType) {
            TupleTypeManager tupleManager = this.getTupleManager();
            Type commonType = tupleManager.getCommonType((TupleType)leftType, (TupleType)rightType, templateParameterSubstitutions);
            if (commonType == null) {
                commonType = this.getOclAnyType();
            }
            return commonType;
        }
        if (leftType instanceof CollectionType && rightType instanceof CollectionType) {
            DomainInheritance leftInheritance = leftType.getInheritance((DomainStandardLibrary)this);
            DomainInheritance rightInheritance = rightType.getInheritance((DomainStandardLibrary)this);
            DomainInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
            Type commonCollectionType = this.getType((DomainType)commonInheritance);
            Type leftElementType = (Type)DomainUtil.nonNullModel((Object)((CollectionType)leftType).getElementType());
            Type rightElementType = (Type)DomainUtil.nonNullModel((Object)((CollectionType)rightType).getElementType());
            Type commonElementType = this.getCommonType(leftElementType, rightElementType, templateParameterSubstitutions);
            return this.getCollectionType(commonCollectionType, (DomainType)commonElementType, null, null);
        }
        if (this.conformsTo(leftType, rightType, templateParameterSubstitutions)) {
            return rightType;
        }
        if (this.conformsTo(rightType, leftType, templateParameterSubstitutions)) {
            return leftType;
        }
        DomainInheritance leftInheritance = leftType.getInheritance((DomainStandardLibrary)this);
        DomainInheritance rightInheritance = rightType.getInheritance((DomainStandardLibrary)this);
        DomainInheritance commonInheritance = leftInheritance.getCommonInheritance(rightInheritance);
        return this.getType((DomainType)commonInheritance);
    }

    @NonNull
    public String getDefaultStandardLibraryURI() {
        return this.defaultStandardLibraryURI;
    }

    @Nullable
    public OpaqueExpression getDefaultExpression(@NonNull Property property) {
        OpaqueExpression defaultExpression = null;
        for (DomainProperty domainProperty : this.getAllProperties(property)) {
            OpaqueExpression anExpression;
            if (!(domainProperty instanceof Property) || (anExpression = ((Property)domainProperty).getDefaultExpression()) == null) continue;
            if (defaultExpression != null) {
                throw new IllegalStateException("Multiple derivations for " + property);
            }
            defaultExpression = anExpression;
        }
        return defaultExpression;
    }

    @Nullable
    public <T extends EObject> T getEcoreOfPivot(@NonNull Class<T> ecoreClass, @NonNull Element element) {
        EObject eTarget = element.getETarget();
        if (eTarget != null) {
            if (!ecoreClass.isAssignableFrom(eTarget.getClass())) {
                logger.error((Object)("Ecore " + eTarget.getClass().getName() + "' element is not a '" + ecoreClass.getName() + "'"));
                return null;
            }
            EObject castTarget = eTarget;
            return (T)castTarget;
        }
        Root root = (Root)EcoreUtil.getRootContainer((EObject)element);
        Resource metaModel = element.eResource();
        if (metaModel == null) {
            return null;
        }
        if (metaModel instanceof OCLstdlib) {
            return null;
        }
        URI ecoreURI = (URI)DomainUtil.nonNullEMF((Object)URI.createURI((String)root.getExternalURI()).appendFileExtension("ecore"));
        Pivot2Ecore converter = new Pivot2Ecore(this, ecoreURI, null);
        converter.convertResource(metaModel, ecoreURI);
        return converter.getCreated(ecoreClass, element);
    }

    @NonNull
    public ElementExtension getElementExtension(@NonNull Element asStereotypedElement, @NonNull Stereotype asStereotype) {
        ElementExtension asElementExtension2;
        List<ElementExtension> extensions = asStereotypedElement.getExtension();
        for (ElementExtension asElementExtension2 : extensions) {
            if (asElementExtension2.getStereotype() != asStereotype) continue;
            return asElementExtension2;
        }
        asElementExtension2 = PivotFactory.eINSTANCE.createElementExtension();
        asElementExtension2.setStereotype(asStereotype);
        asElementExtension2.setName(String.valueOf(((NamedElement)asStereotypedElement).getName()) + "$" + asStereotype.getName());
        extensions.add(asElementExtension2);
        return asElementExtension2;
    }

    @NonNull
    public ResourceSet getExternalResourceSet() {
        ResourceSetImpl externalResourceSet2 = this.externalResourceSet;
        if (externalResourceSet2 == null) {
            externalResourceSet2 = this.externalResourceSet = new ResourceSetImpl();
            StandaloneProjectMap projectMap = this.getProjectMap();
            projectMap.initializeResourceSet((ResourceSet)externalResourceSet2);
            externalResourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emof", new EMOFResourceFactoryImpl());
            MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)externalResourceSet2, this);
            ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)externalResourceSet2);
        }
        return externalResourceSet2;
    }

    @Nullable
    public GenPackage getGenPackage(@NonNull String nsURI) {
        GenPackage genPackage;
        if (this.genPackageMap != null && (genPackage = this.genPackageMap.get(nsURI)) != null) {
            return genPackage;
        }
        ResourceSet externalResourceSet = this.getExternalResourceSet();
        URI uri = (URI)EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false).get(nsURI);
        if (uri != null) {
            Resource resource = externalResourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                for (GenPackage genPackage2 : ((GenModel)eObject).getGenPackages()) {
                    if (genPackage2 == null) continue;
                    return genPackage2;
                }
            }
        }
        return null;
    }

    @NonNull
    public Set<Map.Entry<String, DomainNamespace>> getGlobalNamespaces() {
        Set<Map.Entry<String, DomainNamespace>> entrySet = this.globalNamespaces.entrySet();
        return entrySet;
    }

    @NonNull
    public Iterable<Type> getGlobalTypes() {
        return this.globalTypes;
    }

    @NonNull
    public PivotIdResolver getIdResolver() {
        return this.idResolver;
    }

    @NonNull
    public LibraryFeature getImplementation(@NonNull Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ImplementationManager implementationManager;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementation = (implementationManager = this.getImplementationManager()).loadImplementation(feature)) == null) {
            implementation = UnsupportedOperation.INSTANCE;
        }
        return implementation;
    }

    @NonNull
    public LibraryOperation getImplementation(@NonNull Operation operation) {
        LibraryOperation implementation = (LibraryOperation)operation.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getOperationImplementation(operation);
            operation.setImplementation((LibraryFeature)implementation);
        }
        return implementation;
    }

    @NonNull
    public LibraryProperty getImplementation(@Nullable Object sourceValue, @NonNull Property property) {
        LibraryProperty implementation = (LibraryProperty)property.getImplementation();
        if (implementation == null) {
            ImplementationManager implementationManager = this.getImplementationManager();
            implementation = implementationManager.getPropertyImplementation(sourceValue, property);
            property.setImplementation((LibraryFeature)implementation);
        }
        return implementation;
    }

    @NonNull
    public ImplementationManager getImplementationManager() {
        ImplementationManager implementationManager2 = this.implementationManager;
        if (implementationManager2 == null) {
            implementationManager2 = this.implementationManager = this.createImplementationManager();
        }
        return implementationManager2;
    }

    @Nullable
    public Precedence getInfixPrecedence(@NonNull String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getInfixPrecedence(operatorName);
    }

    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainType type) {
        Type type1 = this.getType(type);
        Type unspecializedType = (Type)type1.getUnspecializedElement();
        Type theType = unspecializedType != null ? unspecializedType : type1;
        TypeServer typeServer = this.getTypeServer(theType);
        return typeServer;
    }

    @NonNull
    public LambdaTypeManager getLambdaManager() {
        LambdaTypeManager lambdaManager2 = this.lambdaManager;
        if (lambdaManager2 == null) {
            lambdaManager2 = this.lambdaManager = this.createLambdaManager();
        }
        return lambdaManager2;
    }

    @NonNull
    public LambdaType getLambdaType(@NonNull String typeName, @NonNull Type contextType, @NonNull List<? extends Type> parameterTypes, @NonNull Type resultType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        LambdaTypeManager lambdaManager = this.getLambdaManager();
        return lambdaManager.getLambdaType(typeName, contextType, parameterTypes, resultType, bindings);
    }

    @NonNull
    public List<Library> getLibraries() {
        return this.asLibraries;
    }

    @Nullable
    public Resource getLibraryResource() {
        return this.asLibraryResource;
    }

    @Nullable
    public Type getLibraryType(@NonNull String string, @NonNull List<? extends ParameterableElement> templateArguments) {
        Type libraryType = this.getRequiredLibraryType(string);
        return this.getLibraryType(libraryType, templateArguments);
    }

    @NonNull
    public <T extends Type> T getLibraryType(@NonNull T libraryType, @NonNull List<? extends ParameterableElement> templateArguments) {
        List<TemplateParameter> templateParameters;
        assert (!(libraryType instanceof Metaclass));
        assert (libraryType == PivotUtil.getUnspecializedTemplateableElement(libraryType));
        TemplateSignature templateSignature = libraryType.getOwnedTemplateSignature();
        List<TemplateParameter> list = templateParameters = templateSignature != null ? templateSignature.getOwnedParameter() : EMPTY_TEMPLATE_PARAMETER_LIST;
        if (templateParameters.isEmpty()) {
            return libraryType;
        }
        if (templateArguments.size() != templateParameters.size()) {
            throw new IllegalArgumentException("Incorrect template bindings for template type");
        }
        boolean isUnspecialized = this.isUnspecialized(templateParameters, templateArguments);
        if (isUnspecialized) {
            return libraryType;
        }
        TypeServer libraryTypeServer = this.getTypeServer(libraryType);
        if (libraryTypeServer instanceof TemplateableTypeServer) {
            TemplateableTypeServer typeServer = (TemplateableTypeServer)libraryTypeServer;
            Type specializedType = typeServer.getSpecializedType(templateArguments);
            return (T)specializedType;
        }
        if (libraryTypeServer instanceof MetaclassServer) {
            MetaclassServer typeServer = (MetaclassServer)libraryTypeServer;
            assert (templateArguments.size() == 1);
            ParameterableElement parameterableElement = templateArguments.get(0);
            assert (parameterableElement instanceof Type);
            Metaclass<?> specializedType = typeServer.getMetaclass((Type)parameterableElement);
            return (T)specializedType;
        }
        if (libraryTypeServer instanceof CollectionTypeServer) {
            CollectionTypeServer typeServer = (CollectionTypeServer)libraryTypeServer;
            assert (templateArguments.size() == 1);
            ParameterableElement parameterableElement = templateArguments.get(0);
            assert (parameterableElement instanceof Type);
            Type specializedType = typeServer.getSpecializedType((Type)parameterableElement, null, null);
            return (T)specializedType;
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Iterable<TypeServer> getLocalClasses(@NonNull Package pkg) {
        return this.getPackageServer(pkg).getMemberTypes();
    }

    public Iterable<Comment> getLocalComments(@NonNull Operation operation) {
        if (operation.getOwningTemplateParameter() != null) {
            return EMPTY_COMMENT_LIST;
        }
        return new CompleteElementCommentsIterable(this.getAllOperations(operation));
    }

    @NonNull
    public Iterable<Comment> getLocalComments(@NonNull Property property) {
        if (property.getOwningTemplateParameter() != null) {
            return EMPTY_COMMENT_LIST;
        }
        return new CompleteElementCommentsIterable(this.getAllProperties(property));
    }

    @NonNull
    public Iterable<Comment> getLocalComments(@NonNull Type type) {
        if (type.getOwningTemplateParameter() != null) {
            return EMPTY_COMMENT_LIST;
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementCommentsIterable(this.getAllTypes(type));
    }

    @NonNull
    public Iterable<Constraint> getLocalInvariants(@NonNull Type type) {
        if (type.getOwningTemplateParameter() != null) {
            return EMPTY_CONSTRAINT_LIST;
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteElementInvariantsIterable(this.getAllTypes(type));
    }

    @Nullable
    public EObject getLockingObject() {
        return this.lockingAnnotation;
    }

    @NonNull
    public Iterable<Operation> getMemberOperations(@NonNull Type type, boolean selectStatic) {
        if (type.getOwningTemplateParameter() != null) {
            return EMPTY_OPERATION_LIST;
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteTypeOperationsIterable(this.getAllTypes(type), selectStatic);
    }

    @NonNull
    public Iterable<? extends PackageServer> getMemberPackages(@NonNull DomainPackage pkg) {
        return this.getPackageServer(pkg).getMemberPackages();
    }

    @Override
    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this;
    }

    @Nullable
    public String getMetamodelNsURI(@NonNull EPackage ePackage) {
        for (ASResourceFactory asResourceFactory : ASResourceFactoryRegistry.INSTANCE.getResourceFactories()) {
            String metamodelNsURI = asResourceFactory.getMetamodelNsURI(ePackage);
            if (metamodelNsURI == null) continue;
            return metamodelNsURI;
        }
        return null;
    }

    @NonNull
    public Iterable<Property> getMemberProperties(@NonNull Type type, boolean selectStatic) {
        if (type.getOwningTemplateParameter() != null) {
            return EMPTY_PROPERTY_LIST;
        }
        type = PivotUtil.getUnspecializedTemplateableElement(type);
        return new CompleteClassPropertiesIterable(this.getAllTypes(type), selectStatic);
    }

    @NonNull
    public Metaclass<?> getMetaclass(@NonNull DomainType domainInstanceType) {
        boolean isUnspecialized;
        DomainType metaclassType;
        Type instanceType = domainInstanceType instanceof Type ? (Type)domainInstanceType : this.getType(domainInstanceType);
        if (instanceType == (metaclassType = this.getMetaclassType())) {
            return metaclassType;
        }
        TemplateSignature templateSignature = metaclassType.getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        boolean bl = isUnspecialized = instanceType == templateParameters.get(0).getParameteredElement();
        if (isUnspecialized) {
            return metaclassType;
        }
        MetaclassServer typeServer = (MetaclassServer)this.getTypeServer(metaclassType);
        Metaclass<?> metaclass = typeServer.getMetaclass(instanceType);
        return metaclass;
    }

    public DomainType getMetaType(@NonNull DomainType instanceType) {
        if (instanceType instanceof PrimitiveType) {
            return this.getPivotType("PrimitiveType");
        }
        return this.getMetaclass(instanceType);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected Type getMutable(@NonNull Type asType) {
        Resource asResource = asType.eResource();
        if (DomainUtil.isRegistered((Resource)asResource)) {
            void var3_8;
            for (DomainType domainType : this.getPartialTypes(asType)) {
                Type asPartialType;
                if (domainType == asType || !(domainType instanceof Type) || DomainUtil.isRegistered((Resource)(asPartialType = (Type)domainType).eResource())) continue;
                if (CREATE_MUTABLE_CLONE.isActive()) {
                    CREATE_MUTABLE_CLONE.println(asType + " " + DomainUtil.debugSimpleName((Object)asType) + " => " + DomainUtil.debugSimpleName((Object)asPartialType));
                }
                return asPartialType;
            }
            Object var3_5 = null;
            Package asPackage = asType.getPackage();
            String name = (String)DomainUtil.nonNullModel((Object)asPackage.getName());
            String nsPrefix = (String)DomainUtil.nonNullModel((Object)asPackage.getNsPrefix());
            String nsURI = (String)DomainUtil.nonNullModel((Object)asPackage.getNsURI());
            if (asPackage instanceof Library) {
                String string = (String)DomainUtil.nonNullModel((Object)asResource.getURI().toString());
                OCLstdlib oCLstdlib = OCLstdlib.create(string, name, nsPrefix, nsURI);
            } else if (asResource instanceof OCLMetaModel) {
                Package package_ = OCLMetaModel.create(this, name, nsPrefix, nsURI);
                Resource resource = package_.eResource();
            }
            if (var3_8 == null) {
                throw new UnsupportedOperationException("No cloned type");
            }
            this.installResource((Resource)var3_8);
            this.asResourceSet.getResources().add((Object)var3_8);
            for (DomainType domainType : this.getPartialTypes(asType)) {
                Type asPartialType;
                if (domainType == asType || !(domainType instanceof Type) || DomainUtil.isRegistered((Resource)(asPartialType = (Type)domainType).eResource())) continue;
                if (CREATE_MUTABLE_CLONE.isActive()) {
                    CREATE_MUTABLE_CLONE.println(asType + " " + DomainUtil.debugSimpleName((Object)asType) + " => " + DomainUtil.debugSimpleName((Object)asPartialType));
                }
                return asPartialType;
            }
            throw new UnsupportedOperationException("No cloned library type " + asType);
        }
        if (CREATE_MUTABLE_CLONE.isActive()) {
            CREATE_MUTABLE_CLONE.println(asType + " " + DomainUtil.debugSimpleName((Object)asType));
        }
        return asType;
    }

    public DomainPackage getNestedPackage(@NonNull DomainPackage domainPackage, @NonNull String name) {
        PackageServer packageServer = this.getPackageServer(domainPackage);
        return packageServer.getMemberPackage(name);
    }

    public DomainType getNestedType(@NonNull DomainPackage domainPackage, @NonNull String name) {
        PackageServer packageServer = this.getPackageServer(domainPackage);
        return packageServer.getMemberType(name);
    }

    public DomainPackage getNsURIPackage(@NonNull String nsURI) {
        return this.packageManager.getPackageByURI(nsURI);
    }

    @Nullable
    public DomainType getOclType(@NonNull String typeName) {
        Type pivotType = this.getPivotType(typeName);
        return pivotType != null ? this.getInheritance(pivotType) : null;
    }

    @Nullable
    public DomainElement getOperationTemplateParameter(@NonNull DomainOperation anOperation, int index) {
        TypeTemplateParameter templateParameter;
        ParameterableElement parameteredElement;
        if (anOperation instanceof Operation) {
            anOperation = PivotUtil.getUnspecializedTemplateableElement((Operation)anOperation);
        }
        if (!((parameteredElement = (templateParameter = (TypeTemplateParameter)anOperation.getTypeParameters().get(index)).getParameteredElement()) instanceof DomainType)) {
            throw new UnsupportedOperationException();
        }
        return parameteredElement;
    }

    @NonNull
    public CollectionType getOrderedSetType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getOrderedSetType(this.getType(elementType), lower, upper);
    }

    @NonNull
    public CollectionType getOrderedSetType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType((CollectionType)this.getOrderedSetType(), elementType, lower, upper);
    }

    @NonNull
    public Orphanage getOrphanage() {
        Orphanage orphanage2 = this.orphanage;
        if (orphanage2 == null) {
            orphanage2 = this.orphanage = this.createOrphanage();
        }
        return orphanage2;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    @NonNull
    public PackageServer getPackageServer(@NonNull DomainPackage asPackage) {
        if (!this.libraryLoadInProgress && this.asMetamodel == null) {
            this.getASMetamodel();
        }
        return this.packageManager.getPackageServer(asPackage);
    }

    @Nullable
    public ParserContext getParserContext(@NonNull Element element, Object ... todoParameters) {
        EObject pivotContainer;
        Element pivotElement = element;
        if (pivotElement instanceof Constraint) {
            pivotContainer = pivotElement.eContainer();
            if (pivotContainer instanceof Operation) {
                Type resultType;
                Operation pivotOperation = (Operation)pivotContainer;
                String resultName = null;
                if (pivotOperation.getPostcondition().contains(pivotElement) && (resultType = pivotOperation.getType()) != null && !(resultType instanceof VoidType)) {
                    resultName = "result";
                }
                return new OperationContext(this, null, pivotOperation, resultName);
            }
        } else if (pivotElement instanceof OpaqueExpression && (pivotContainer = pivotElement.eContainer()) instanceof Operation) {
            Operation pivotOperation = (Operation)pivotContainer;
            return new OperationContext(this, null, pivotOperation, null);
        }
        if (pivotElement instanceof Property) {
            return new PropertyContext(this, null, (Property)pivotElement);
        }
        if (pivotElement instanceof Operation) {
            return new OperationContext(this, null, (Operation)pivotElement, null);
        }
        if (pivotElement instanceof OppositePropertyCallExp) {
            Property referredProperty;
            Property referredOppositeProperty = ((OppositePropertyCallExp)pivotElement).getReferredProperty();
            if (referredOppositeProperty != null && (referredProperty = referredOppositeProperty.getOpposite()) != null) {
                return new PropertyContext(this, null, referredProperty);
            }
        } else if (pivotElement instanceof PropertyCallExp) {
            Property referredProperty = ((PropertyCallExp)pivotElement).getReferredProperty();
            if (referredProperty != null) {
                return new PropertyContext(this, null, referredProperty);
            }
        } else if (pivotElement instanceof OperationCallExp) {
            Operation referredOperation = ((OperationCallExp)pivotElement).getReferredOperation();
            if (referredOperation != null) {
                return new OperationContext(this, null, referredOperation, null);
            }
        } else if (pivotElement instanceof LoopExp) {
            Iteration referredIteration = ((LoopExp)pivotElement).getReferredIteration();
            if (referredIteration != null) {
                return new OperationContext(this, null, referredIteration, null);
            }
        } else {
            Element eObject = element;
            while (eObject != null) {
                if (eObject instanceof Type && ((Type)eObject).getPackage() != null) {
                    return new ClassContext(this, null, (Type)eObject);
                }
                eObject = eObject.eContainer();
            }
        }
        return null;
    }

    @NonNull
    public Iterable<? extends DomainPackage> getPartialPackages(@NonNull DomainPackage pkg, boolean loadASMetamodelFirst) {
        if (!this.libraryLoadInProgress && loadASMetamodelFirst && this.asMetamodel == null) {
            this.getASMetamodel();
        }
        PackageServer packageServer = this.packageManager.getPackageServer(pkg);
        return packageServer.getPartialPackages();
    }

    @NonNull
    public Iterable<? extends DomainType> getPartialTypes(@NonNull DomainType pivotType) {
        TypeServer typeServer = this.packageManager.getTypeServer(pivotType);
        return typeServer.getPartialTypes();
    }

    @Nullable
    public <T extends Element> T getPivotOf(@NonNull Class<T> pivotClass, @Nullable EObject eObject) throws ParserException {
        ASResourceFactory bestHelper;
        if (eObject != null && (bestHelper = ASResourceFactoryRegistry.INSTANCE.getResourceFactory(eObject)) != null) {
            return bestHelper.getASElement(this, pivotClass, eObject);
        }
        return null;
    }

    @Nullable
    public <T extends Element> T getPivotOfEcore(@NonNull Class<T> pivotClass, @Nullable EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource metaModel = eObject.eResource();
        if (metaModel == null) {
            return null;
        }
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(metaModel, this);
        if (ecore2Pivot == null) {
            return null;
        }
        return ecore2Pivot.getCreated(pivotClass, eObject);
    }

    @Nullable
    public Type getPivotType(@NonNull String className) {
        if (this.asMetamodel == null) {
            this.getASMetamodel();
            if (this.asMetamodel == null) {
                return null;
            }
        }
        return (Type)DomainUtil.getNamedElement((Iterable)this.asMetamodel.getOwnedType(), (String)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected PrecedenceManager getPrecedenceManager() {
        if (this.precedenceManager == null) {
            MetaModelManager metaModelManager = this;
            synchronized (metaModelManager) {
                if (this.precedenceManager == null) {
                    MetaModelManager metaModelManager2 = this;
                    synchronized (metaModelManager2) {
                        this.precedenceManager = this.createPrecedenceManager();
                    }
                }
            }
        }
        return this.precedenceManager;
    }

    @Nullable
    public Precedence getPrefixPrecedence(@NonNull String operatorName) {
        PrecedenceManager precedenceManager = this.getPrecedenceManager();
        return precedenceManager.getPrefixPrecedence(operatorName);
    }

    @NonNull
    public <T extends EObject> T getPrimaryElement(@NonNull T element) {
        if (element instanceof DomainOperation) {
            return (T)((EObject)this.getPrimaryOperation((DomainOperation)element));
        }
        if (element instanceof DomainPackage) {
            return (T)((EObject)this.getPrimaryPackage((DomainPackage)element));
        }
        if (element instanceof DomainProperty) {
            return (T)((EObject)this.getPrimaryProperty((DomainProperty)element));
        }
        if (element instanceof Type) {
            return (T)this.getPrimaryType((DomainType)element);
        }
        return element;
    }

    @NonNull
    public DomainOperation getPrimaryOperation(@NonNull DomainOperation pivotOperation) {
        DomainOperation operation;
        ExtensibleTypeServer typeServer;
        DomainInheritance pivotClass = pivotOperation.getInheritance((DomainStandardLibrary)this);
        if (pivotClass != null && (typeServer = this.packageManager.findTypeServer((DomainType)pivotClass)) != null && (operation = typeServer.getMemberOperation(pivotOperation)) != null) {
            return operation;
        }
        return pivotOperation;
    }

    @Nullable
    public PackageServer getPrimaryPackage(@NonNull String nsURI, String ... subPackagePath) {
        PackageServer packageServer = this.packageManager.getPackageByURI(nsURI);
        if (packageServer == null) {
            return null;
        }
        if (subPackagePath != null) {
            String[] stringArray = subPackagePath;
            int n = subPackagePath.length;
            int n2 = 0;
            while (n2 < n) {
                String subPackageName = stringArray[n2];
                if (subPackageName == null) {
                    return null;
                }
                if ((packageServer = packageServer.getMemberPackage(subPackageName)) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return packageServer;
    }

    @NonNull
    public DomainPackage getPrimaryPackage(@NonNull DomainPackage aPackage) {
        return this.getPackageServer(aPackage).getPivotPackage();
    }

    @NonNull
    public DomainProperty getPrimaryProperty(@NonNull DomainProperty pivotProperty) {
        if (pivotProperty instanceof Property && ((Property)pivotProperty).eContainer() instanceof TupleType) {
            return pivotProperty;
        }
        DomainInheritance owningInheritance = pivotProperty.getInheritance((DomainStandardLibrary)this);
        if (owningInheritance != null) {
            String name = (String)DomainUtil.nonNullModel((Object)pivotProperty.getName());
            DomainProperty opposite = pivotProperty.getOpposite();
            String oppositeName = opposite != null ? opposite.getName() : null;
            TypeServer typeServer = this.packageManager.getTypeServer((DomainType)owningInheritance);
            Iterator<DomainProperty> memberProperties = typeServer.getMemberProperties(name);
            if (memberProperties != null) {
                while (memberProperties.hasNext()) {
                    String memberOppositeName;
                    DomainProperty memberProperty = memberProperties.next();
                    if (memberProperty == null || memberProperty.isStatic() != pivotProperty.isStatic()) continue;
                    DomainProperty memberOpposite = memberProperty.getOpposite();
                    String string = memberOppositeName = memberOpposite != null ? memberOpposite.getName() : null;
                    if (oppositeName != null && !oppositeName.equals(memberOppositeName)) continue;
                    return memberProperty;
                }
            }
        }
        return pivotProperty;
    }

    @NonNull
    public Type getPrimaryType(@NonNull DomainType type) {
        if (!this.isTypeServeable(type)) {
            return (Type)type;
        }
        return this.getTypeServer(type).getPivotType();
    }

    @Nullable
    public Type getPrimaryType(@NonNull String nsURI, @NonNull String path, String ... extraPath) {
        PackageServer packageServer = this.packageManager.getPackageByURI(nsURI);
        if (packageServer == null) {
            return null;
        }
        if (extraPath == null || extraPath.length == 0) {
            return packageServer.getMemberType(path);
        }
        if ((packageServer = packageServer.getMemberPackage(path)) == null) {
            return null;
        }
        int iMax = extraPath.length - 1;
        int i = 0;
        while (i < iMax) {
            String subPackageName = extraPath[i];
            if (subPackageName == null) {
                return null;
            }
            if ((packageServer = packageServer.getMemberPackage(subPackageName)) == null) {
                return null;
            }
            ++i;
        }
        String subPackageName = extraPath[iMax];
        if (subPackageName == null) {
            return null;
        }
        return packageServer.getMemberType(subPackageName);
    }

    @NonNull
    public StandaloneProjectMap getProjectMap() {
        return ProjectMap.getAdapter((ResourceSet)this.asResourceSet);
    }

    @NonNull
    public ASResource getResource(@NonNull URI uri, @Nullable String contentType) {
        Object asResourceFactory = this.asResourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get(contentType);
        if (asResourceFactory == null) {
            throw new IllegalStateException("No registration for content type '" + contentType + "'");
        }
        if (!(asResourceFactory instanceof ASResourceFactory)) {
            throw new IllegalStateException("Non ASResourceFactory registration for content type '" + contentType + "'");
        }
        Resource asResource = this.asResourceSet.getResource(uri, false);
        if (asResource == null) {
            asResource = this.asResourceSet.createResource(uri, contentType);
        }
        if (asResource == null) {
            throw new IllegalStateException("Failed to create '" + uri + "'");
        }
        if (!(asResource instanceof ASResource)) {
            throw new IllegalStateException("Non ASResource created for content type '" + contentType + "'");
        }
        return (ASResource)asResource;
    }

    @Deprecated
    public URI getResourceIdentifier(Object uniqueContext, String subContext) {
        return URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + ".essentialocl"));
    }

    @Nullable
    public Package getRootPackage(@NonNull String name) {
        return this.packageManager.getRootPackage(name);
    }

    @NonNull
    public CollectionType getSequenceType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getSequenceType(this.getType(elementType), lower, upper);
    }

    @NonNull
    public CollectionType getSequenceType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType((CollectionType)this.getSequenceType(), elementType, lower, upper);
    }

    @NonNull
    public CollectionType getSetType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getSetType(this.getType(elementType), lower, upper);
    }

    @NonNull
    public CollectionType getSetType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType((CollectionType)this.getSetType(), elementType, lower, upper);
    }

    @NonNull
    protected CollectionType getSpecializedCollectionType(@NonNull CollectionType type, @NonNull Map<TemplateParameter, ParameterableElement> usageBindings) {
        CollectionType unspecializedType = PivotUtil.getUnspecializedTemplateableElement(type);
        Map<TemplateParameter, ParameterableElement> typeBindings = PivotUtil.getAllTemplateParametersAsBindings(type);
        PivotUtil.getAllTemplateParameterSubstitutions(typeBindings, type);
        if (typeBindings != null && !typeBindings.isEmpty()) {
            this.rebindTemplateBindings(typeBindings, usageBindings);
            TemplateParameter templateParameter = unspecializedType.getOwnedTemplateSignature().getOwnedParameter().get(0);
            ParameterableElement templateArgument = typeBindings.get(templateParameter);
            if (templateArgument == null) {
                templateArgument = templateParameter.getParameteredElement();
            }
            if (templateArgument instanceof Type) {
                Type templateTypeArgument = (Type)templateArgument;
                templateTypeArgument = this.getSpecializedType(templateTypeArgument, usageBindings);
                return this.getCollectionType((CollectionType)unspecializedType, templateTypeArgument, (IntegerValue)null, (IntegerValue)null);
            }
        }
        return type;
    }

    @NonNull
    protected Type getSpecializedLambdaType(@NonNull LambdaType type, @Nullable Map<TemplateParameter, ParameterableElement> usageBindings) {
        String typeName = (String)DomainUtil.nonNullModel((Object)type.getName());
        Type contextType = (Type)DomainUtil.nonNullModel((Object)type.getContextType());
        List<Type> parameterType = type.getParameterType();
        Type resultType = (Type)DomainUtil.nonNullModel((Object)type.getResultType());
        LambdaType specializedLambdaType = this.getLambdaType(typeName, contextType, parameterType, resultType, usageBindings);
        return specializedLambdaType;
    }

    @NonNull
    protected Metaclass<?> getSpecializedMetaclass(@NonNull Metaclass<?> type, @NonNull Map<TemplateParameter, ParameterableElement> usageBindings) {
        Map<TemplateParameter, ParameterableElement> typeBindings = PivotUtil.getAllTemplateParametersAsBindings(type);
        PivotUtil.getAllTemplateParameterSubstitutions(typeBindings, type);
        if (typeBindings != null && !typeBindings.isEmpty()) {
            this.rebindTemplateBindings(typeBindings, usageBindings);
            TemplateParameter templateParameter = this.getMetaclassType().getOwnedTemplateSignature().getOwnedParameter().get(0);
            ParameterableElement templateArgument = typeBindings.get(templateParameter);
            if (templateArgument == null) {
                templateArgument = this.getOclAnyType();
            }
            if (templateArgument instanceof Type) {
                templateArgument = this.getSpecializedType((Type)templateArgument, usageBindings);
            }
            return this.getMetaclass((DomainType)templateArgument);
        }
        return type;
    }

    @NonNull
    public Type getSpecializedType(@NonNull Type type, @Nullable Map<TemplateParameter, ParameterableElement> usageBindings) {
        TemplateParameter owningTemplateParameter = type.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            if (usageBindings == null) {
                return type;
            }
            ParameterableElement parameterableElement = usageBindings.get(owningTemplateParameter);
            return parameterableElement instanceof Type ? (Type)parameterableElement : type;
        }
        if (usageBindings == null) {
            return type;
        }
        if (type instanceof CollectionType) {
            return this.getSpecializedCollectionType((CollectionType)type, usageBindings);
        }
        if (type instanceof Metaclass) {
            return this.getSpecializedMetaclass((Metaclass)type, usageBindings);
        }
        if (type instanceof TupleType) {
            return this.getTupleType((TupleType)type, usageBindings);
        }
        if (type instanceof LambdaType) {
            return this.getSpecializedLambdaType((LambdaType)type, usageBindings);
        }
        Type unspecializedType = PivotUtil.getUnspecializedTemplateableElement(type);
        Map<TemplateParameter, ParameterableElement> typeBindings = PivotUtil.getAllTemplateParametersAsBindings(type);
        PivotUtil.getAllTemplateParameterSubstitutions(typeBindings, type);
        if (typeBindings != null && !typeBindings.isEmpty()) {
            this.rebindTemplateBindings(typeBindings, usageBindings);
            List<TemplateParameter> templateParameters = PivotUtil.getAllTemplateParameters(unspecializedType);
            if (templateParameters != null) {
                ArrayList<ParameterableElement> templateArguments = new ArrayList<ParameterableElement>(templateParameters.size());
                for (TemplateParameter templateParameter : templateParameters) {
                    ParameterableElement templateArgument = typeBindings.get(templateParameter);
                    if (templateArgument == null) {
                        templateArgument = templateParameter.getParameteredElement();
                    }
                    if (templateArgument instanceof Type) {
                        templateArgument = this.getSpecializedType((Type)templateArgument, usageBindings);
                    }
                    templateArguments.add(templateArgument);
                }
                return this.getLibraryType(unspecializedType, templateArguments);
            }
        }
        return type;
    }

    public Iterable<Type> getSuperClasses(Type pivotType) {
        if (pivotType == null || pivotType.getOwningTemplateParameter() != null) {
            return Collections.singletonList(this.getOclAnyType());
        }
        if (!this.libraryLoadInProgress && this.asMetamodel == null && pivotType == this.getClassType()) {
            this.getASMetamodel();
        }
        return new CompleteClassSuperClassesIterable(this.getAllTypes(pivotType));
    }

    public ResourceSet getTarget() {
        return this.asResourceSet;
    }

    public TupleTypeManager getTupleManager() {
        if (this.tupleManager == null) {
            this.tupleManager = this.createTupleManager();
        }
        return this.tupleManager;
    }

    @NonNull
    public TupleType getTupleType(@NonNull String typeName, @NonNull Collection<? extends DomainTypedElement> parts, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        TupleTypeManager tupleManager = this.getTupleManager();
        return tupleManager.getTupleType(typeName, parts, bindings);
    }

    @NonNull
    public TupleType getTupleType(@NonNull TupleType tupleType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        TupleTypeManager tupleManager = this.getTupleManager();
        return tupleManager.getTupleType(tupleType, bindings);
    }

    @NonNull
    public Type getType(@NonNull DomainType dType) {
        PackageServer packageServer;
        Type primaryType;
        if (dType instanceof Type) {
            return this.getPrimaryType(dType);
        }
        DomainPackage dPackage = dType.getPackage();
        if (dPackage != null && (primaryType = (packageServer = this.getPackageServer(dPackage)).getMemberType(dType.getName())) != null) {
            return primaryType;
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public TypeServer getTypeServer(@NonNull DomainType pivotType) {
        if (!(this.libraryLoadInProgress || this.asMetamodel != null || pivotType instanceof CollectionType || pivotType instanceof VoidType || pivotType instanceof InvalidType)) {
            this.getASMetamodel();
        }
        return this.packageManager.getTypeServer(pivotType);
    }

    public void installPropertyDeclaration(@NonNull Property thisProperty) {
        if ((thisProperty.isTransient() || thisProperty.isVolatile()) && !thisProperty.isDerived()) {
            return;
        }
        Property opposite = thisProperty.getOpposite();
        if (opposite != null) {
            return;
        }
        Type thatType = thisProperty.getType();
        if (thatType instanceof CollectionType) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        if (thatType == null || thatType instanceof DataType) {
            return;
        }
        Type thisType = thisProperty.getOwningType();
        if (thisType == null) {
            return;
        }
        String name = thisType.getName();
        if (name == null) {
            return;
        }
        Property newOpposite = PivotFactory.eINSTANCE.createProperty();
        newOpposite.setImplicit(true);
        newOpposite.setName(name);
        if (thisProperty.isComposite()) {
            newOpposite.setType(thisType);
            newOpposite.setIsRequired(false);
        } else {
            newOpposite.setType(this.getCollectionType(false, false, thisType, PivotConstants.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE, PivotConstants.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE));
            newOpposite.setIsRequired(true);
        }
        thatType = this.getMutable(thatType);
        thatType.getOwnedAttribute().add(newOpposite);
        newOpposite.setOpposite(thisProperty);
        thisProperty.setOpposite(newOpposite);
    }

    public void installResource(@NonNull Resource asResource) {
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Root)) continue;
            this.installRoot((Root)eObject);
        }
        if (!this.libraryLoadInProgress && this.asLibraryResource == null && asResource instanceof OCLstdlib && this.asLibraries.size() > 0) {
            this.getOclAnyType();
        }
    }

    public void installRoot(@NonNull Root pivotRoot) {
        this.packageManager.addRoot(pivotRoot);
        for (DomainPackage domainPackage : pivotRoot.getNestedPackage()) {
            if (!(domainPackage instanceof Library) || this.asLibraries.contains(domainPackage)) continue;
            Library asLibrary = (Library)domainPackage;
            String uri = asLibrary.getNsURI();
            if (this.asLibraries.isEmpty()) {
                if (uri == null) {
                    throw new IllegalLibraryException(OCLMessages.MissingLibraryURI_ERROR_);
                }
                this.setDefaultStandardLibraryURI(uri);
            } else {
                String libraryURI = this.getDefaultStandardLibraryURI();
                if (uri != null && !uri.equals(libraryURI)) {
                    throw new IllegalLibraryException(NLS.bind((String)OCLMessages.ImportedLibraryURI_ERROR_, (Object)uri, (Object)libraryURI));
                }
            }
            this.asLibraries.add(asLibrary);
        }
    }

    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == MetaModelManager.class;
    }

    public boolean isSuperClassOf(@NonNull Type unspecializedFirstType, @NonNull Type secondType) {
        Type unspecializedSecondType = PivotUtil.getUnspecializedTemplateableElement(secondType);
        if (unspecializedFirstType == unspecializedSecondType) {
            return true;
        }
        for (Type superClass : this.getSuperClasses(unspecializedSecondType)) {
            if (superClass == null || !this.isSuperClassOf(unspecializedFirstType, superClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeServeable(@NonNull DomainType type) {
        if (!(type instanceof Type)) {
            return false;
        }
        Type pivotType = (Type)type;
        if (pivotType.getOwningTemplateParameter() != null) {
            return false;
        }
        if (pivotType instanceof LambdaType) {
            return false;
        }
        return !(pivotType.eContainer() instanceof TemplateParameterSubstitution);
    }

    public boolean isUnderspecified(@Nullable ParameterableElement type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TemplateableElement) {
            for (TemplateBinding templateBinding : ((TemplateableElement)((Object)type)).getTemplateBinding()) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                    if (!this.isUnderspecified(templateParameterSubstitution.getActual())) continue;
                    return true;
                }
            }
        }
        if (type instanceof UnspecifiedType) {
            return true;
        }
        if (type instanceof CollectionType) {
            return this.isUnderspecified(((CollectionType)type).getElementType());
        }
        if (type instanceof TupleType) {
            for (Property part : ((TupleType)type).getOwnedAttribute()) {
                if (!this.isUnderspecified(part.getType())) continue;
                return true;
            }
        }
        if (type instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)type;
            if (this.isUnderspecified(lambdaType.getContextType())) {
                return true;
            }
            for (Type parameterType : lambdaType.getParameterType()) {
                if (!this.isUnderspecified(parameterType)) continue;
                return true;
            }
            if (this.isUnderspecified(lambdaType.getResultType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean isUnspecialized(@NonNull List<TemplateParameter> templateParameters, @NonNull List<? extends ParameterableElement> templateArguments) {
        int iMax = templateParameters.size();
        assert (templateArguments.size() == iMax);
        boolean isUnspecialized = true;
        int i = 0;
        while (i < iMax) {
            if (templateArguments.get(i) != templateParameters.get(i).getParameteredElement()) {
                isUnspecialized = false;
            }
            ++i;
        }
        return isUnspecialized;
    }

    protected void loadASMetamodel(@NonNull Package asLibrary) {
        for (DomainPackage domainPackage : this.getPartialPackages(asLibrary, false)) {
            if (DomainUtil.getNamedElement((Iterable)domainPackage.getOwnedType(), (String)PivotPackage.Literals.ELEMENT.getName()) == null) continue;
            this.setASMetamodel(domainPackage);
            return;
        }
        String string = (String)DomainUtil.nonNullState((Object)asLibrary.getName());
        String nsURI = (String)DomainUtil.nonNullState((Object)asLibrary.getNsURI());
        Package oclMetamodel = OCLMetaModel.create(this, string, asLibrary.getNsPrefix(), nsURI);
        this.asResourceSet.getResources().add((Object)oclMetamodel.eResource());
        this.setASMetamodel(oclMetamodel);
        Resource asResource = oclMetamodel.eResource();
        this.installResource(asResource);
        this.packageManager.addPackageNsURISynonym("http://www.eclipse.org/ocl/3.1.0/Pivot", nsURI);
    }

    @Override
    @Nullable
    protected Resource loadDefaultLibrary(@Nullable String uri) {
        boolean savedLibraryLoadInProgress = this.libraryLoadInProgress;
        this.libraryLoadInProgress = true;
        try {
            if (this.asLibraries.isEmpty()) {
                if (uri == null) {
                    return null;
                }
                StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uri);
                if (contribution == null) {
                    return null;
                }
                this.installResource(contribution.getResource());
            }
            assert (this.asLibraryResource == null);
            if (!this.asLibraries.isEmpty()) {
                this.asLibraryResource = this.asLibraries.get(0).eResource();
                for (Library asLibrary : this.asLibraries) {
                    if (asLibrary == null) continue;
                    PackageServer packageServer = this.packageManager.getPackageServer(asLibrary);
                    packageServer.getMemberTypes();
                    for (Type type : asLibrary.getOwnedType()) {
                        Type primaryType;
                        if (type == null || type != (primaryType = this.getPrimaryType(type)) || !PivotUtil.isLibraryType(type)) continue;
                        this.defineLibraryType(primaryType);
                    }
                }
            }
            Resource resource = this.asLibraryResource;
            return resource;
        }
        finally {
            this.libraryLoadInProgress = savedLibraryLoadInProgress;
        }
    }

    @Nullable
    public Element loadResource(@NonNull URI uri, String alias, @Nullable ResourceSet resourceSet) throws ParserException {
        EPackage ePackage;
        ResourceSet externalResourceSet = resourceSet != null ? resourceSet : this.getExternalResourceSet();
        EPackage.Registry packageRegistry = externalResourceSet.getPackageRegistry();
        URI resourceURI = uri.trimFragment();
        String uriString = resourceURI.toString();
        String fragment = uri.fragment();
        Resource resource = null;
        if (fragment == null) {
            ePackage = packageRegistry.getEPackage(uriString);
            if (ePackage != null) {
                return this.getPivotOf(Element.class, (EObject)ePackage);
            }
            if (uriString.equals(this.defaultStandardLibraryURI)) {
                EObject eObject;
                resource = this.asLibraryResource != null ? this.asLibraryResource : this.loadDefaultLibrary(uriString);
                if (resource instanceof XMLResource && (eObject = ((XMLResource)resource).getEObject(fragment)) instanceof Element) {
                    return (Element)eObject;
                }
            } else {
                StandardLibraryContribution contribution = StandardLibraryContribution.REGISTRY.get(uriString);
                if (contribution != null) {
                    resource = contribution.getResource();
                }
            }
        } else {
            Element asElement;
            EObject eObject;
            Resource eResource;
            ePackage = packageRegistry.getEPackage(uriString);
            if (ePackage != null && (eResource = ePackage.eResource()) instanceof XMLResource && (eObject = ((XMLResource)eResource).getEObject(fragment)) != null && (asElement = this.getPivotOf(Element.class, eObject)) != null) {
                return asElement;
            }
        }
        if (resource == null) {
            External2Pivot external2Pivot = this.external2PivotMap.get(uri);
            if (external2Pivot != null) {
                resource = external2Pivot.getResource();
            } else {
                try {
                    resource = externalResourceSet.getResource(resourceURI, true);
                }
                catch (RuntimeException e) {
                    resource = externalResourceSet.getResource(resourceURI, false);
                    if (resource != null) {
                        externalResourceSet.getResources().remove((Object)resource);
                        resource = null;
                    }
                    throw e;
                }
                if (resource != null) {
                    EObject firstContent;
                    EList contents;
                    if (resource instanceof StandaloneProjectMap.DelegatedSinglePackageResource) {
                        resource = ((StandaloneProjectMap.DelegatedSinglePackageResource)resource).getResource();
                    }
                    if ((contents = resource.getContents()).size() > 0 && (firstContent = (EObject)contents.get(0)) != null) {
                        for (ASResourceFactory resourceFactory : ASResourceFactoryRegistry.INSTANCE.getResourceFactories()) {
                            Resource knownResource;
                            URI packageURI = resourceFactory.getPackageURI(firstContent);
                            if (packageURI == null) continue;
                            External2Pivot external2Pivot2 = this.external2PivotMap.get(packageURI);
                            if (external2Pivot2 == null || (knownResource = external2Pivot2.getResource()) == null || knownResource == resource) break;
                            for (EObject eContent : resource.getContents()) {
                                Element pivot;
                                if (!(eContent instanceof Pivotable) || !((pivot = ((Pivotable)firstContent).getPivot()) instanceof Root)) continue;
                                Root root = (Root)pivot;
                                this.packageManager.removeRoot(root);
                                Resource asResource = root.eResource();
                                if (asResource == null) continue;
                                this.asResourceSet.getResources().remove((Object)asResource);
                                asResource.unload();
                            }
                            if (!resourceFactory.isCompatibleResource(resource, knownResource)) {
                                logger.error((Object)("Resource '" + resource.getURI() + "' already loaded as '" + knownResource.getURI() + "'"));
                            }
                            resource.getResourceSet().getResources().remove((Object)resource);
                            resource = knownResource;
                            break;
                        }
                    }
                }
            }
        }
        if (resource != null) {
            return this.loadResource(resource, uri);
        }
        logger.warn((Object)("Cannot load package with URI '" + uri + "'"));
        return null;
    }

    public EPackage loadEPackage(@NonNull EPackage ePackage) {
        ResourceSet externalResourceSet = this.getExternalResourceSet();
        return externalResourceSet.getPackageRegistry().getEPackage(ePackage.getNsURI());
    }

    @Nullable
    public Element loadResource(@NonNull Resource resource, @Nullable URI uri) throws ParserException {
        ASResourceFactory bestFactory = ASResourceFactoryRegistry.INSTANCE.getResourceFactory(resource);
        if (bestFactory != null) {
            return bestFactory.importFromResource(this, resource, uri);
        }
        throw new ParserException("Cannot create pivot from '" + uri + "'");
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull DomainOperation dynamicOperation) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getImplementation((Operation)dynamicOperation);
    }

    public void notifyChanged(Notification notification) {
    }

    protected void rebindTemplateBindings(@NonNull Map<TemplateParameter, ParameterableElement> typeBindings, @NonNull Map<TemplateParameter, ParameterableElement> usageBindings) {
        for (TemplateParameter templateParameter : typeBindings.keySet()) {
            ParameterableElement aParameterableElement;
            ParameterableElement parameterableElement = typeBindings.get(templateParameter);
            if (parameterableElement == null) continue;
            TemplateParameter aTemplateParameter = parameterableElement.getOwningTemplateParameter();
            if (aTemplateParameter != null) {
                aParameterableElement = usageBindings.get(aTemplateParameter);
                if (aParameterableElement == null) continue;
                typeBindings.put(templateParameter, aParameterableElement);
                continue;
            }
            if (!(parameterableElement instanceof SelfType) || (aParameterableElement = usageBindings.get(null)) == null) continue;
            typeBindings.put(templateParameter, aParameterableElement);
        }
    }

    public void removeExternalResource(@NonNull External2Pivot external2Pivot) {
        this.external2PivotMap.remove(external2Pivot.getURI());
    }

    public void removeListener(@NonNull MetaModelManagerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void resolveAllOperations(@NonNull Set<Operation> allOperations, @NonNull Type forType, @Nullable FeatureFilter featureFilter, @NonNull String operationName, @NonNull List<Parameter> parameters) {
        int iMax = parameters.size();
        for (DomainOperation domainOperation : this.getAllOperations(forType, featureFilter, operationName)) {
            List<Parameter> candidateParameters;
            if (!(domainOperation instanceof Operation) || (candidateParameters = ((Operation)domainOperation).getOwnedParameter()).size() != iMax) continue;
            int i = 0;
            while (i < iMax) {
                Type candidateType;
                Type type = parameters.get(i).getType();
                if (type != (candidateType = candidateParameters.get(i).getType())) break;
                ++i;
            }
            if (i < iMax) continue;
            allOperations.add((Operation)domainOperation);
        }
    }

    @NonNull
    public Operation resolveBaseOperation(@NonNull Operation operation) {
        HashSet<Operation> allOperations = new HashSet<Operation>();
        Type owningType = operation.getOwningType();
        String operationName = operation.getName();
        List<Parameter> ownedParameter = operation.getOwnedParameter();
        this.resolveAllOperations(allOperations, owningType, operation.isStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC, operationName, ownedParameter);
        Operation baseOperation = operation;
        for (Operation candidateOperation : allOperations) {
            Type candidateType;
            Type baseType;
            if (candidateOperation == operation || !this.conformsTo(baseType = baseOperation.getOwningType(), candidateType = candidateOperation.getOwningType(), null)) continue;
            baseOperation = candidateOperation;
        }
        return baseOperation;
    }

    @Nullable
    public Set<Operation> resolveLocalOperation(@NonNull Type pivotClass, @NonNull String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = null;
        HashSet<Operation> pivotOperations = null;
        for (Operation pivotOperation : pivotClass.getOwnedOperation()) {
            List<Parameter> pivotParameters;
            if (!operationName.equals(pivotOperation.getName()) || pivotArguments.length != (pivotParameters = pivotOperation.getOwnedParameter()).size()) continue;
            boolean typesConform = true;
            int i = 0;
            while (i < pivotArguments.length) {
                Type argumentType = pivotArguments[i];
                if (argumentType == null) {
                    typesConform = false;
                    break;
                }
                Parameter pivotParameter = pivotParameters.get(i);
                if (pivotParameter == null) {
                    typesConform = false;
                    break;
                }
                Type parameterType = PivotUtil.getType(pivotParameter);
                if (parameterType == null) {
                    typesConform = false;
                    break;
                }
                if (!this.conformsTo(argumentType, parameterType, templateParameterSubstitutions)) {
                    typesConform = false;
                    break;
                }
                ++i;
            }
            if (!typesConform) continue;
            if (pivotOperations == null) {
                pivotOperations = new HashSet<Operation>();
            }
            pivotOperations.add(pivotOperation);
        }
        return pivotOperations;
    }

    public Operation resolveOperation(@NonNull Type leftType, @NonNull String operationName, Type ... rightTypes) {
        Set<Operation> candidateOperations = this.resolveOperations(leftType, operationName, rightTypes);
        if (candidateOperations == null) {
            return null;
        }
        if (candidateOperations.size() > 1) {
            logger.warn((Object)("Ambiguous operation '" + operationName + "'"));
        }
        return candidateOperations.iterator().next();
    }

    public Set<Operation> resolveOperations(@NonNull Type pivotClass, @NonNull String operationName, Type ... pivotArguments) {
        Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, pivotClass);
        Set<Operation> pivotOperations = this.resolveLocalOperation(pivotClass, operationName, pivotArguments);
        for (TemplateBinding templateBinding : pivotClass.getTemplateBinding()) {
            Set<Operation> morePivotOperations;
            TemplateSignature signature = templateBinding.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (!(template instanceof Type) || (morePivotOperations = this.resolveLocalOperation((Type)template, operationName, pivotArguments)) == null) continue;
            if (pivotOperations == null) {
                pivotOperations = morePivotOperations;
                continue;
            }
            pivotOperations.addAll(morePivotOperations);
        }
        if (pivotOperations == null) {
            List<Type> superClasses = pivotClass.getSuperClass();
            if (!superClasses.isEmpty()) {
                for (Type superClass : superClasses) {
                    Set<Operation> superOperations;
                    if (superClass == null || (superOperations = this.resolveOperations(superClass, operationName, pivotArguments)) == null) continue;
                    if (pivotOperations == null) {
                        pivotOperations = superOperations;
                        continue;
                    }
                    pivotOperations.addAll(superOperations);
                }
            } else {
                AnyType oclAnyType = this.getOclAnyType();
                if (pivotClass != oclAnyType) {
                    pivotOperations = this.resolveOperations(oclAnyType, operationName, pivotArguments);
                }
            }
        }
        return pivotOperations;
    }

    public void setASMetamodel(DomainPackage asPackage) {
        this.asMetamodel = asPackage;
    }

    public void setAutoLoadASMetamodel(boolean autoLoadASMetamodel) {
        this.autoLoadASMetamodel = autoLoadASMetamodel;
    }

    public void setDefaultStandardLibraryURI(@NonNull String defaultStandardLibraryURI) {
        assert (!PivotUtil.isASURI(defaultStandardLibraryURI));
        this.defaultStandardLibraryURI = defaultStandardLibraryURI;
    }

    public void setLibraryLoadInProgress(boolean libraryLoadInProgress) {
        this.libraryLoadInProgress = libraryLoadInProgress;
    }

    public void setMetamodelNsURI(@NonNull String metaNsURI) {
        if (this.asMetamodel == null) {
            if (StandardLibraryContribution.REGISTRY.get(metaNsURI) == null) {
                StandardLibraryContribution.REGISTRY.put(metaNsURI, new OCLstdlib.RenamingLoader(metaNsURI));
            }
            this.setDefaultStandardLibraryURI(metaNsURI);
            this.getASMetamodel();
        } else if (!metaNsURI.equals(this.asMetamodel.getNsURI())) {
            throw new IllegalMetamodelException(this.asMetamodel.getNsURI(), metaNsURI);
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassPropertiesIterable
    extends CompleteElementIterable<Type, Property> {
        protected final Boolean selectStatic;

        public CompleteClassPropertiesIterable(Iterable<Type> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        @NonNull
        protected Iterable<Property> getInnerIterable(@NonNull Type model) {
            return (Iterable)DomainUtil.nonNullEMF(model.getOwnedAttribute());
        }

        @Override
        @Nullable
        protected Property getInnerValue(@NonNull Property element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteClassSuperClassesIterable
    extends CompleteElementIterable<Type, Type> {
        public CompleteClassSuperClassesIterable(Iterable<Type> types) {
            super(types);
        }

        @Override
        @NonNull
        protected Iterable<Type> getInnerIterable(@NonNull Type model) {
            return (Iterable)DomainUtil.nonNullEMF(model.getSuperClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteElementCommentsIterable
    extends CompleteElementIterable<DomainElement, Comment> {
        public CompleteElementCommentsIterable(Iterable<? extends DomainElement> models) {
            super(models);
        }

        @Override
        protected Iterable<Comment> getInnerIterable(@NonNull DomainElement model) {
            if (model instanceof Element) {
                return (Iterable)DomainUtil.nonNullEMF(((Element)model).getOwnedComment());
            }
            return EMPTY_COMMENT_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteElementInvariantsIterable
    extends CompleteElementIterable<Type, Constraint> {
        public CompleteElementInvariantsIterable(Iterable<? extends Type> models) {
            super(models);
        }

        @Override
        @NonNull
        protected Iterable<Constraint> getInnerIterable(@NonNull Type model) {
            return (Iterable)DomainUtil.nonNullEMF(model.getOwnedInvariant());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompleteTypeOperationsIterable
    extends CompleteElementIterable<Type, Operation> {
        protected final Boolean selectStatic;

        public CompleteTypeOperationsIterable(Iterable<Type> types, boolean selectStatic) {
            super(types);
            this.selectStatic = selectStatic;
        }

        @Override
        @NonNull
        protected Iterable<Operation> getInnerIterable(@NonNull Type model) {
            return (Iterable)DomainUtil.nonNullEMF(model.getOwnedOperation());
        }

        @Override
        @Nullable
        protected Operation getInnerValue(@NonNull Operation element) {
            if (this.selectStatic != null && element.isStatic() != this.selectStatic.booleanValue()) {
                return null;
            }
            return element;
        }
    }
}

