/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.library.ConstrainedProperty;
import org.eclipse.ocl.examples.pivot.uml.UMLElementExtension;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class StereotypeProperty
extends ConstrainedProperty {
    public StereotypeProperty(@NonNull Property property) {
        super(property);
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        IdResolver idResolver = evaluator.getIdResolver();
        EObject eObject = StereotypeProperty.asNavigableObject((Object)sourceValue, (Object)this.property);
        if (eObject instanceof Metaclass) {
            eObject = ((Metaclass)eObject).getInstanceType();
        }
        Object boxedValue = null;
        if (eObject instanceof UMLElementExtension) {
            return ((UMLElementExtension)eObject).getValue(idResolver, this.property);
        }
        if (eObject instanceof ElementExtension) {
            OCLExpression bodyExpression;
            ExpressionInOCL expr;
            String body;
            ElementExtension elementExtension = (ElementExtension)eObject;
            String propertyName = this.property.getName();
            Property extensionProperty = (Property)DomainUtil.getNamedElement(elementExtension.getOwnedAttribute(), (String)propertyName);
            if (extensionProperty == null) {
                EClass eClass;
                EStructuralFeature eStructuralFeature;
                EObject umlStereotypeApplication;
                boolean gotIt = false;
                String defaultValue = null;
                OpaqueExpression defaultExpression = null;
                if (elementExtension.isApplied() && (umlStereotypeApplication = elementExtension.getETarget()) != null && (eStructuralFeature = (EStructuralFeature)EcoreUtils.getNamedElement((Collection)(eClass = umlStereotypeApplication.eClass()).getEAllStructuralFeatures(), (String)propertyName)) != null) {
                    Object value = umlStereotypeApplication.eGet(eStructuralFeature);
                    defaultValue = value != null ? value.toString() : null;
                    gotIt = true;
                }
                if (!gotIt && (elementExtension.isApplied() || elementExtension.isRequired())) {
                    Property theProperty = (Property)DomainUtil.getNamedElement(elementExtension.getStereotype().getOwnedAttribute(), (String)propertyName);
                    defaultValue = theProperty.getDefault();
                    defaultExpression = theProperty.getDefaultExpression();
                    gotIt = true;
                }
                extensionProperty = PivotFactory.eINSTANCE.createProperty();
                extensionProperty.setName(propertyName);
                extensionProperty.setIsRequired(this.property.isRequired());
                extensionProperty.setIsStatic(this.property.isStatic());
                extensionProperty.setType(this.property.getType());
                extensionProperty.setDefault(defaultValue);
                extensionProperty.setDefaultExpression(defaultExpression);
                elementExtension.getOwnedAttribute().add(extensionProperty);
            }
            String defaultValueLiteral = extensionProperty.getDefault();
            OpaqueExpression defaultExpression = extensionProperty.getDefaultExpression();
            if (defaultValueLiteral != null) {
                boxedValue = idResolver.createInstance(this.property.getTypeId(), defaultValueLiteral);
            } else if (defaultExpression != null && (body = PivotUtil.getBody(defaultExpression)) != null && (expr = PivotUtil.getExpressionInOCL((NamedElement)elementExtension, body)) != null && (bodyExpression = expr.getBodyExpression()) != null) {
                boxedValue = evaluator.evaluate((DomainExpression)bodyExpression);
            }
        } else {
            EClass eClass = eObject.eClass();
            EStructuralFeature eFeature = (EStructuralFeature)EcoreUtils.getNamedElement((Collection)eClass.getEAllStructuralFeatures(), (String)this.property.getName());
            if (eFeature != null) {
                Object value = eObject.eGet(eFeature);
                boxedValue = value != null ? idResolver.boxedValueOf(value, (ETypedElement)eFeature, returnTypeId) : null;
            }
        }
        return boxedValue;
    }
}

