/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class ImplicitNonCompositionProperty
extends AbstractProperty {
    @NonNull
    protected DomainProperty property;

    public ImplicitNonCompositionProperty(@NonNull DomainProperty property) {
        this.property = property;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        DomainModelManager modelManager = evaluator.getModelManager();
        DomainProperty thatProperty = this.property.getOpposite();
        DomainType thatType = (DomainType)DomainUtil.nonNullModel((Object)this.property.getType());
        boolean isMany = thatType instanceof DomainCollectionType;
        if (isMany) {
            thatType = ((DomainCollectionType)thatType).getElementType();
        }
        ArrayList<EObject> results = new ArrayList<EObject>();
        if (thatType != null) {
            for (EObject eObject : modelManager.get(thatType)) {
                EClass eClass = eObject.eClass();
                EStructuralFeature eFeature = eClass.getEStructuralFeature(thatProperty.getName());
                Object eGet = eObject.eGet(eFeature);
                if (eFeature.isMany()) {
                    for (Object eReference : (List)eGet) {
                        if (eReference != sourceValue) continue;
                        results.add(eObject);
                    }
                    continue;
                }
                if (eGet != sourceValue) continue;
                results.add(eObject);
            }
        }
        if (isMany) {
            return evaluator.getIdResolver().createCollectionOfAll(false, false, returnTypeId, results);
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new InvalidValueException("Multiple opposites for " + this.property, new Object[0]);
    }
}

