/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.ClassImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassImpl<T>
extends ClassImpl
implements Metaclass<T> {
    protected Type instanceType;

    protected MetaclassImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.METACLASS;
    }

    @Override
    public Type getInstanceType() {
        if (this.instanceType != null && this.instanceType.eIsProxy()) {
            InternalEObject oldInstanceType = (InternalEObject)this.instanceType;
            this.instanceType = (Type)this.eResolveProxy(oldInstanceType);
            if (this.instanceType != oldInstanceType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 23, (Object)oldInstanceType, (Object)this.instanceType));
            }
        }
        return this.instanceType;
    }

    public Type basicGetInstanceType() {
        return this.instanceType;
    }

    @Override
    public void setInstanceType(Type newInstanceType) {
        Type oldInstanceType = this.instanceType;
        this.instanceType = newInstanceType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldInstanceType, (Object)this.instanceType));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtension();
            }
            case 1: {
                return this.getOwnedAnnotation();
            }
            case 2: {
                return this.getOwnedComment();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getOwnedTemplateSignature();
            }
            case 6: {
                return this.getTemplateBinding();
            }
            case 7: {
                return this.getUnspecializedElement();
            }
            case 8: {
                return this.getOwningTemplateParameter();
            }
            case 9: {
                if (resolve) {
                    return this.getTemplateParameter();
                }
                return this.basicGetTemplateParameter();
            }
            case 10: {
                return this.getExtendedBys();
            }
            case 11: {
                return this.getInstanceClassName();
            }
            case 12: {
                return this.getOwnedAttribute();
            }
            case 13: {
                return this.getOwnedInvariant();
            }
            case 14: {
                return this.getOwnedOperation();
            }
            case 15: {
                return this.getPackage();
            }
            case 16: {
                return this.getSuperClass();
            }
            case 17: {
                return this.getOwnedRule();
            }
            case 18: {
                return this.isAbstract();
            }
            case 19: {
                return this.isActive();
            }
            case 20: {
                return this.isInterface();
            }
            case 21: {
                return this.getNestedType();
            }
            case 22: {
                return this.getOwnedBehavior();
            }
            case 23: {
                if (resolve) {
                    return this.getInstanceType();
                }
                return this.basicGetInstanceType();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setOwnedTemplateSignature((TemplateSignature)newValue);
                return;
            }
            case 6: {
                this.getTemplateBinding().clear();
                this.getTemplateBinding().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setUnspecializedElement((TemplateableElement)newValue);
                return;
            }
            case 8: {
                this.setOwningTemplateParameter((TemplateParameter)newValue);
                return;
            }
            case 9: {
                this.setTemplateParameter((TemplateParameter)newValue);
                return;
            }
            case 10: {
                this.getExtendedBys().clear();
                this.getExtendedBys().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 12: {
                this.getOwnedAttribute().clear();
                this.getOwnedAttribute().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getOwnedInvariant().clear();
                this.getOwnedInvariant().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getOwnedOperation().clear();
                this.getOwnedOperation().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setPackage((Package)newValue);
                return;
            }
            case 16: {
                this.getSuperClass().clear();
                this.getSuperClass().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getOwnedRule().clear();
                this.getOwnedRule().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setIsAbstract((Boolean)newValue);
                return;
            }
            case 19: {
                this.setIsActive((Boolean)newValue);
                return;
            }
            case 20: {
                this.setIsInterface((Boolean)newValue);
                return;
            }
            case 21: {
                this.getNestedType().clear();
                this.getNestedType().addAll((Collection)newValue);
                return;
            }
            case 22: {
                this.getOwnedBehavior().clear();
                this.getOwnedBehavior().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.setInstanceType((Type)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setOwnedTemplateSignature(null);
                return;
            }
            case 6: {
                this.getTemplateBinding().clear();
                return;
            }
            case 7: {
                this.setUnspecializedElement(null);
                return;
            }
            case 8: {
                this.setOwningTemplateParameter(null);
                return;
            }
            case 9: {
                this.setTemplateParameter(null);
                return;
            }
            case 10: {
                this.getExtendedBys().clear();
                return;
            }
            case 11: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 12: {
                this.getOwnedAttribute().clear();
                return;
            }
            case 13: {
                this.getOwnedInvariant().clear();
                return;
            }
            case 14: {
                this.getOwnedOperation().clear();
                return;
            }
            case 15: {
                this.setPackage(null);
                return;
            }
            case 16: {
                this.getSuperClass().clear();
                return;
            }
            case 17: {
                this.getOwnedRule().clear();
                return;
            }
            case 18: {
                this.setIsAbstract(false);
                return;
            }
            case 19: {
                this.setIsActive(false);
                return;
            }
            case 20: {
                this.setIsInterface(false);
                return;
            }
            case 21: {
                this.getNestedType().clear();
                return;
            }
            case 22: {
                this.getOwnedBehavior().clear();
                return;
            }
            case 23: {
                this.setInstanceType(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 1: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 2: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.ownedTemplateSignature != null;
            }
            case 6: {
                return this.templateBinding != null && !this.templateBinding.isEmpty();
            }
            case 7: {
                return this.unspecializedElement != null;
            }
            case 8: {
                return this.getOwningTemplateParameter() != null;
            }
            case 9: {
                return this.templateParameter != null;
            }
            case 10: {
                return this.extendedBys != null && !this.extendedBys.isEmpty();
            }
            case 11: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 12: {
                return this.ownedAttribute != null && !this.ownedAttribute.isEmpty();
            }
            case 13: {
                return this.ownedInvariant != null && !this.ownedInvariant.isEmpty();
            }
            case 14: {
                return this.ownedOperation != null && !this.ownedOperation.isEmpty();
            }
            case 15: {
                return this.getPackage() != null;
            }
            case 16: {
                return this.superClass != null && !this.superClass.isEmpty();
            }
            case 17: {
                return this.ownedRule != null && !this.ownedRule.isEmpty();
            }
            case 18: {
                return (this.eFlags & 0x200) != 0;
            }
            case 19: {
                return (this.eFlags & 0x400) != 0;
            }
            case 20: {
                return (this.eFlags & 0x800) != 0;
            }
            case 21: {
                return this.nestedType != null && !this.nestedType.isEmpty();
            }
            case 22: {
                return this.ownedBehavior != null && !this.ownedBehavior.isEmpty();
            }
            case 23: {
                return this.instanceType != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitMetaclass(this);
    }

    @NonNull
    public MetaclassId computeId() {
        if (this.getUnspecializedElement() == null) {
            return TypeId.METACLASS;
        }
        return TypeId.METACLASS.getSpecializedId((ElementId)this.getInstanceType().getTypeId());
    }

    @Override
    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        Type instanceType = this.getInstanceType();
        if (instanceType instanceof ElementExtension) {
            instanceType = ((ElementExtension)instanceType).getStereotype();
            return instanceType.conformsTo(standardLibrary, type);
        }
        String metaTypeName = instanceType.getMetaTypeName();
        DomainType metaType = standardLibrary.getOclType(metaTypeName);
        if (type instanceof DomainMetaclass) {
            return instanceType.conformsTo(standardLibrary, (DomainType)DomainUtil.nonNullModel((Object)((DomainMetaclass)type).getInstanceType()));
        }
        boolean conformsTo2 = metaType.conformsTo(standardLibrary, type);
        return conformsTo2;
    }

    public DomainType getContainerType() {
        return (DomainType)this.getUnspecializedElement();
    }

    @Override
    public TemplateableElement getUnspecializedElement() {
        TemplateableElement unspecializedElement2 = super.getUnspecializedElement();
        if (unspecializedElement2 != null) {
            return unspecializedElement2;
        }
        if (this.getOwnedTemplateSignature() != null) {
            return unspecializedElement2;
        }
        Resource resource = this.eResource();
        if (resource != null) {
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof Root)) continue;
                for (Package pkg : ((Root)eObject).getNestedPackage()) {
                    Type type = (Type)DomainUtil.getNamedElement(pkg.getOwnedType(), (String)this.getName());
                    if (!(type instanceof Metaclass)) continue;
                    this.setUnspecializedElement(type);
                    return type;
                }
            }
        }
        return unspecializedElement2;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

