/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.DataTypeImpl;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeImpl
extends DataTypeImpl
implements CollectionType {
    protected Type elementType;
    protected static final Number LOWER_EDEFAULT = (Number)PivotFactory.eINSTANCE.createFromString(PivotPackage.eINSTANCE.getInteger(), "0");
    protected Number lower = LOWER_EDEFAULT;
    protected static final Number UPPER_EDEFAULT = (Number)PivotFactory.eINSTANCE.createFromString(PivotPackage.eINSTANCE.getUnlimitedNatural(), "*");
    protected Number upper = UPPER_EDEFAULT;

    protected CollectionTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.COLLECTION_TYPE;
    }

    @Override
    public Type getElementType() {
        if (this.elementType != null && this.elementType.eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = (Type)this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 25, (Object)oldElementType, (Object)this.elementType));
            }
        }
        return this.elementType;
    }

    public Type basicGetElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(Type newElementType) {
        Type oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, (Object)oldElementType, (Object)this.elementType));
        }
    }

    @Override
    public Number getLower() {
        return this.lower;
    }

    @Override
    public void setLower(Number newLower) {
        Number oldLower = this.lower;
        this.lower = newLower;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 26, (Object)oldLower, (Object)this.lower));
        }
    }

    @Override
    public Number getUpper() {
        return this.upper;
    }

    @Override
    public void setUpper(Number newUpper) {
        Number oldUpper = this.upper;
        this.upper = newUpper;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 27, (Object)oldUpper, (Object)this.upper));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtension();
            }
            case 1: {
                return this.getOwnedAnnotation();
            }
            case 2: {
                return this.getOwnedComment();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getOwnedTemplateSignature();
            }
            case 6: {
                return this.getTemplateBinding();
            }
            case 7: {
                return this.getUnspecializedElement();
            }
            case 8: {
                return this.getOwningTemplateParameter();
            }
            case 9: {
                if (resolve) {
                    return this.getTemplateParameter();
                }
                return this.basicGetTemplateParameter();
            }
            case 10: {
                return this.getExtendedBys();
            }
            case 11: {
                return this.getInstanceClassName();
            }
            case 12: {
                return this.getOwnedAttribute();
            }
            case 13: {
                return this.getOwnedInvariant();
            }
            case 14: {
                return this.getOwnedOperation();
            }
            case 15: {
                return this.getPackage();
            }
            case 16: {
                return this.getSuperClass();
            }
            case 17: {
                return this.getOwnedRule();
            }
            case 18: {
                return this.isAbstract();
            }
            case 19: {
                return this.isActive();
            }
            case 20: {
                return this.isInterface();
            }
            case 21: {
                return this.getNestedType();
            }
            case 22: {
                return this.getOwnedBehavior();
            }
            case 23: {
                if (resolve) {
                    return this.getBehavioralType();
                }
                return this.basicGetBehavioralType();
            }
            case 24: {
                return this.isSerializable();
            }
            case 25: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 26: {
                return this.getLower();
            }
            case 27: {
                return this.getUpper();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setOwnedTemplateSignature((TemplateSignature)newValue);
                return;
            }
            case 6: {
                this.getTemplateBinding().clear();
                this.getTemplateBinding().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setUnspecializedElement((TemplateableElement)newValue);
                return;
            }
            case 8: {
                this.setOwningTemplateParameter((TemplateParameter)newValue);
                return;
            }
            case 9: {
                this.setTemplateParameter((TemplateParameter)newValue);
                return;
            }
            case 10: {
                this.getExtendedBys().clear();
                this.getExtendedBys().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 12: {
                this.getOwnedAttribute().clear();
                this.getOwnedAttribute().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getOwnedInvariant().clear();
                this.getOwnedInvariant().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getOwnedOperation().clear();
                this.getOwnedOperation().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setPackage((Package)newValue);
                return;
            }
            case 16: {
                this.getSuperClass().clear();
                this.getSuperClass().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getOwnedRule().clear();
                this.getOwnedRule().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setIsAbstract((Boolean)newValue);
                return;
            }
            case 19: {
                this.setIsActive((Boolean)newValue);
                return;
            }
            case 20: {
                this.setIsInterface((Boolean)newValue);
                return;
            }
            case 21: {
                this.getNestedType().clear();
                this.getNestedType().addAll((Collection)newValue);
                return;
            }
            case 22: {
                this.getOwnedBehavior().clear();
                this.getOwnedBehavior().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.setBehavioralType((Type)newValue);
                return;
            }
            case 24: {
                this.setIsSerializable((Boolean)newValue);
                return;
            }
            case 25: {
                this.setElementType((Type)newValue);
                return;
            }
            case 26: {
                this.setLower((Number)newValue);
                return;
            }
            case 27: {
                this.setUpper((Number)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setOwnedTemplateSignature(null);
                return;
            }
            case 6: {
                this.getTemplateBinding().clear();
                return;
            }
            case 7: {
                this.setUnspecializedElement(null);
                return;
            }
            case 8: {
                this.setOwningTemplateParameter(null);
                return;
            }
            case 9: {
                this.setTemplateParameter(null);
                return;
            }
            case 10: {
                this.getExtendedBys().clear();
                return;
            }
            case 11: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 12: {
                this.getOwnedAttribute().clear();
                return;
            }
            case 13: {
                this.getOwnedInvariant().clear();
                return;
            }
            case 14: {
                this.getOwnedOperation().clear();
                return;
            }
            case 15: {
                this.setPackage(null);
                return;
            }
            case 16: {
                this.getSuperClass().clear();
                return;
            }
            case 17: {
                this.getOwnedRule().clear();
                return;
            }
            case 18: {
                this.setIsAbstract(false);
                return;
            }
            case 19: {
                this.setIsActive(false);
                return;
            }
            case 20: {
                this.setIsInterface(false);
                return;
            }
            case 21: {
                this.getNestedType().clear();
                return;
            }
            case 22: {
                this.getOwnedBehavior().clear();
                return;
            }
            case 23: {
                this.setBehavioralType(null);
                return;
            }
            case 24: {
                this.setIsSerializable(true);
                return;
            }
            case 25: {
                this.setElementType(null);
                return;
            }
            case 26: {
                this.setLower(LOWER_EDEFAULT);
                return;
            }
            case 27: {
                this.setUpper(UPPER_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 1: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 2: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.ownedTemplateSignature != null;
            }
            case 6: {
                return this.templateBinding != null && !this.templateBinding.isEmpty();
            }
            case 7: {
                return this.unspecializedElement != null;
            }
            case 8: {
                return this.getOwningTemplateParameter() != null;
            }
            case 9: {
                return this.templateParameter != null;
            }
            case 10: {
                return this.extendedBys != null && !this.extendedBys.isEmpty();
            }
            case 11: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 12: {
                return this.ownedAttribute != null && !this.ownedAttribute.isEmpty();
            }
            case 13: {
                return this.ownedInvariant != null && !this.ownedInvariant.isEmpty();
            }
            case 14: {
                return this.ownedOperation != null && !this.ownedOperation.isEmpty();
            }
            case 15: {
                return this.getPackage() != null;
            }
            case 16: {
                return this.superClass != null && !this.superClass.isEmpty();
            }
            case 17: {
                return this.ownedRule != null && !this.ownedRule.isEmpty();
            }
            case 18: {
                return (this.eFlags & 0x200) != 0;
            }
            case 19: {
                return (this.eFlags & 0x400) != 0;
            }
            case 20: {
                return (this.eFlags & 0x800) != 0;
            }
            case 21: {
                return this.nestedType != null && !this.nestedType.isEmpty();
            }
            case 22: {
                return this.ownedBehavior != null && !this.ownedBehavior.isEmpty();
            }
            case 23: {
                return this.behavioralType != null;
            }
            case 24: {
                return (this.eFlags & 0x1000) == 0;
            }
            case 25: {
                return this.elementType != null;
            }
            case 26: {
                return LOWER_EDEFAULT == null ? this.lower != null : !LOWER_EDEFAULT.equals(this.lower);
            }
            case 27: {
                return UPPER_EDEFAULT == null ? this.upper != null : !UPPER_EDEFAULT.equals(this.upper);
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCollectionType(this);
    }

    @Override
    @NonNull
    public TypeId computeId() {
        if (this.getUnspecializedElement() == null) {
            if ("Collection".equals(this.name)) {
                return TypeId.COLLECTION;
            }
            if ("UniqueCollection".equals(this.name)) {
                return TypeId.UNIQUE_COLLECTION;
            }
            String name2 = this.name;
            assert (name2 != null);
            return IdManager.getCollectionTypeId((String)name2);
        }
        return TypeId.COLLECTION.getSpecializedId(new ElementId[]{this.getElementType().getTypeId()});
    }

    @Override
    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (type instanceof DomainCollectionType) {
            return standardLibrary.conformsToCollectionType((DomainCollectionType)this, (DomainCollectionType)type);
        }
        if (this.getUnspecializedElement() != null) {
            return ((Type)this.getUnspecializedElement()).conformsTo(standardLibrary, type);
        }
        return super.conformsTo(standardLibrary, type);
    }

    @Override
    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        DomainStandardLibrary standardLibrary = idResolver.getStandardLibrary();
        DomainInheritance thisInheritance = this.getInheritance(standardLibrary);
        DomainInheritance thatInheritance = type.getInheritance(standardLibrary);
        DomainInheritance commonInheritance = thisInheritance.getCommonInheritance(thatInheritance);
        if (type instanceof DomainCollectionType) {
            Type thisElementType = this.getElementType();
            DomainType thatElementType = (DomainType)DomainUtil.nonNullEMF((Object)((DomainCollectionType)type).getElementType());
            DomainType commonElementType = thisElementType.getCommonType(idResolver, thatElementType);
            if (commonInheritance instanceof TypeServer) {
                DomainCollectionType commonCollectionType = (DomainCollectionType)((TypeServer)commonInheritance).getPivotType();
                return standardLibrary.getCollectionType((DomainType)commonCollectionType, commonElementType, null, null);
            }
            if (commonInheritance.isOrdered()) {
                if (commonInheritance.isUnique()) {
                    return standardLibrary.getOrderedSetType(commonElementType, null, null);
                }
                return standardLibrary.getSequenceType(commonElementType, null, null);
            }
            if (commonInheritance.isUnique()) {
                return standardLibrary.getSetType(commonElementType, null, null);
            }
            return standardLibrary.getBagType(commonElementType, null, null);
        }
        return commonInheritance;
    }

    @NonNull
    public CollectionType getContainerType() {
        TemplateableElement unspecializedElement2 = this.unspecializedElement;
        return unspecializedElement2 != null ? (CollectionType)unspecializedElement2 : this;
    }

    @NonNull
    public CollectionTypeId getTypeId() {
        return (CollectionTypeId)super.getTypeId();
    }

    @Override
    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainCollectionType)) {
            return false;
        }
        return standardLibrary.isEqualToCollectionType((DomainCollectionType)this, (DomainCollectionType)type);
    }

    @NonNull
    public IntegerValue getLowerValue() {
        Number lower2 = this.lower;
        assert (lower2 != null);
        return ValuesUtil.integerValueOf((Object)lower2);
    }

    @NonNull
    public IntegerValue getUpperValue() {
        Number upper2 = this.upper;
        assert (upper2 != null);
        return ValuesUtil.integerValueOf((Object)upper2);
    }

    @Override
    public void setLowerValue(@NonNull IntegerValue lower) {
        this.setLower(lower.intValue());
    }

    @Override
    public void setUpperValue(@NonNull IntegerValue upper) {
        this.setUpper((Number)(upper.isUnlimited() ? Unlimited.INSTANCE : Integer.valueOf(upper.intValue())));
    }
}

