/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Import;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.delegate.DelegateInstaller;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreDeclarationVisitor
extends AbstractExtendingVisitor<Object, Pivot2Ecore> {
    @NonNull
    public static final DuplicateConstraintsFilter duplicateConstraintsFilter = new DuplicateConstraintsFilter();
    @NonNull
    public static final DuplicateOperationsFilter duplicateOperationsFilter = new DuplicateOperationsFilter();
    @NonNull
    public static final DuplicatePropertiesFilter duplicatePropertiesFilter = new DuplicatePropertiesFilter();
    @NonNull
    public static final NonDuplicateConstraintsFilter nonDuplicateConstraintsFilter = new NonDuplicateConstraintsFilter();
    @NonNull
    public static final NonDuplicateOperationsFilter nonDuplicateOperationsFilter = new NonDuplicateOperationsFilter();
    @NonNull
    public static final NonDuplicatePropertiesFilter nonDuplicatePropertiesFilter = new NonDuplicatePropertiesFilter();
    @NonNull
    protected final DelegateInstaller delegateInstaller;

    public Pivot2EcoreDeclarationVisitor(@NonNull Pivot2Ecore context) {
        super(context);
        this.delegateInstaller = context.getDelegateInstaller();
    }

    protected void copyClassifier(@NonNull EClassifier eClassifier, @NonNull Type pivotType) {
        this.copyNamedElement((ENamedElement)eClassifier, pivotType);
        EList eTypeParameters = eClassifier.getETypeParameters();
        this.copyTemplateSignature((List<ETypeParameter>)eTypeParameters, pivotType);
        EList eAnnotations = eClassifier.getEAnnotations();
        this.safeVisitAll((List)eAnnotations, (Iterable<? extends Element>)pivotType.getOwnedAnnotation());
        if (pivotType.eIsSet((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME)) {
            eClassifier.setInstanceClassName(pivotType.getInstanceClassName());
        } else {
            eClassifier.eUnset((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
        }
        this.delegateInstaller.installDelegates(eClassifier, pivotType);
        for (Constraint pivotInvariant : pivotType.getOwnedInvariant()) {
            if (pivotInvariant.isCallable()) continue;
            this.safeVisit(pivotInvariant);
        }
    }

    @Nullable
    protected EAnnotation copyConstraint(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint) {
        EAnnotation eAnnotation = this.delegateInstaller.createConstraintDelegate(eModelElement, pivotConstraint, ((Pivot2Ecore)this.context).getEcoreURI());
        if (eAnnotation != null) {
            if (eModelElement instanceof EOperation) {
                Pivot2Ecore.copyAnnotationComments(eAnnotation, pivotConstraint);
            } else {
                Pivot2Ecore.copyComments((EModelElement)eAnnotation, pivotConstraint);
            }
        }
        return eAnnotation;
    }

    protected void copyDataTypeOrEnum(@NonNull EDataType eDataType, @NonNull DataType pivotDataType) {
        this.copyClassifier((EClassifier)eDataType, pivotDataType);
        eDataType.setSerializable(pivotDataType.isSerializable());
    }

    protected void copyDetails(@NonNull EAnnotation eAnnotation, @NonNull Annotation pivotAnnotation) {
        this.copyModelElement((EModelElement)eAnnotation, pivotAnnotation);
        EList eAnnotations = eAnnotation.getEAnnotations();
        this.safeVisitAll((List)eAnnotations, (Iterable<? extends Element>)pivotAnnotation.getOwnedAnnotation());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetail()) {
            String name = pivotDetail.getName();
            String value = StringUtils.splice(pivotDetail.getValue(), (String)"");
            eAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyModelElement(@NonNull EModelElement eModelElement, @NonNull Element pivotModelElement) {
        ((Pivot2Ecore)this.context).putCreated(pivotModelElement, eModelElement);
        Pivot2Ecore.copyComments(eModelElement, pivotModelElement);
    }

    protected void copyNamedElement(@NonNull ENamedElement eNamedElement, @NonNull NamedElement pivotNamedElement) {
        EObject eContainer;
        this.copyModelElement((EModelElement)eNamedElement, pivotNamedElement);
        String name = pivotNamedElement.getName();
        if ("containingActivity".equals(name)) {
            EObject eContainer2 = pivotNamedElement.eContainer();
            if (eContainer2 instanceof Type && "ActivityNode".equals(((Type)eContainer2).getName())) {
                name = "ActivityNode_" + name;
            }
        } else if ("inActivity".equals(name) && (eContainer = pivotNamedElement.eContainer()) instanceof Type && "StructuredActivityNode".equals(((Type)eContainer).getName())) {
            name = "activity";
        }
        eNamedElement.setName(name);
    }

    protected void copyTemplateSignature(@NonNull List<ETypeParameter> eTypeParameters, TemplateableElement pivotElement) {
        TemplateSignature templateSignature = pivotElement.getOwnedTemplateSignature();
        if (templateSignature != null) {
            List<TemplateParameter> parameters = templateSignature.getOwnedParameter();
            this.safeVisitAll(eTypeParameters, parameters);
        }
    }

    protected void copyTypedElement(@NonNull ETypedElement eTypedElement, @NonNull TypedMultiplicityElement pivotTypedElement) {
        this.copyNamedElement((ENamedElement)eTypedElement, pivotTypedElement);
        EList eAnnotations = eTypedElement.getEAnnotations();
        this.safeVisitAll((List)eAnnotations, (Iterable<? extends Element>)pivotTypedElement.getOwnedAnnotation());
        ((Pivot2Ecore)this.context).defer(pivotTypedElement);
    }

    @Nullable
    protected EAnnotation createOppositeEAnnotation(@NonNull Property property) {
        String name;
        IntegerValue upperValue;
        IntegerValue lowerValue;
        Type type;
        String lower = null;
        String ordered = null;
        String unique = null;
        String upper = null;
        Type propertyType = property.getType();
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            type = collectionType.getElementType();
            lowerValue = collectionType.getLowerValue();
            upperValue = collectionType.getUpperValue();
            if (collectionType.isOrdered()) {
                ordered = Boolean.toString(collectionType.isOrdered());
            }
            if (collectionType.isUnique()) {
                unique = Boolean.toString(collectionType.isUnique());
            }
            if (!PivotConstants.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
                lower = lowerValue.toString();
            }
            if (!PivotConstants.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE.equals(upperValue)) {
                upper = upperValue.toString();
            }
        } else {
            type = propertyType;
            lowerValue = property.isRequired() ? ValuesUtil.ONE_VALUE : ValuesUtil.ZERO_VALUE;
            upperValue = ValuesUtil.ONE_VALUE;
            if (!ValuesUtil.ZERO_VALUE.equals(lowerValue)) {
                lower = lowerValue.toString();
            }
            if (!ValuesUtil.ONE_VALUE.equals(upperValue)) {
                upper = upperValue.toString();
            }
        }
        if ((name = property.getName()).equals(type.getName()) && lower == null && ordered == null && unique == null && upper == null) {
            return null;
        }
        lower = null;
        ordered = null;
        unique = null;
        upper = null;
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            if (collectionType.isOrdered()) {
                ordered = Boolean.toString(collectionType.isOrdered());
            }
            if (!collectionType.isUnique()) {
                unique = Boolean.toString(collectionType.isUnique());
            }
        }
        if (!PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
            lower = lowerValue.toString();
        }
        if (!PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE.equals(upperValue)) {
            upper = upperValue.toString();
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
        EMap details = eAnnotation.getDetails();
        details.put((Object)"body", (Object)name);
        if (lower != null) {
            details.put((Object)"lower", (Object)lower);
        }
        if (ordered != null) {
            details.put((Object)"ordered", (Object)ordered);
        }
        if (unique != null) {
            details.put((Object)"unique", (Object)unique);
        }
        if (upper != null) {
            details.put((Object)"upper", (Object)upper);
        }
        return eAnnotation;
    }

    public <T extends EObject> void safeVisitAll(@NonNull List<T> eObjects, @NonNull Iterable<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Declaration pass");
    }

    @Override
    public EObject visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(eAnnotation, pivotAnnotation);
        eAnnotation.setSource(pivotAnnotation.getName());
        EList contents = eAnnotation.getContents();
        this.safeVisitAll((List)contents, (Iterable<? extends Element>)pivotAnnotation.getOwnedContent());
        if (!pivotAnnotation.getReference().isEmpty()) {
            ((Pivot2Ecore)this.context).defer(pivotAnnotation);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        if (pivotClass.getTemplateBinding().size() > 0) {
            return null;
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotClass);
        eClass.setAbstract(pivotClass.isAbstract());
        eClass.setInterface(pivotClass.isInterface());
        ((Pivot2Ecore)this.context).defer(pivotClass);
        EList eOperations = eClass.getEOperations();
        Iterable nonDuplicateConstraints = Iterables.filter(pivotClass.getOwnedInvariant(), (Predicate)nonDuplicateConstraintsFilter);
        Iterable nonDuplicateOperations = Iterables.filter(pivotClass.getOwnedOperation(), (Predicate)nonDuplicateOperationsFilter);
        this.safeVisitAll((List)eOperations, nonDuplicateOperations);
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        Iterable nonDuplicateProperties = Iterables.filter(pivotClass.getOwnedAttribute(), (Predicate)nonDuplicatePropertiesFilter);
        this.safeVisitAll((List)eStructuralFeatures, nonDuplicateProperties);
        for (Constraint pivotInvariant : nonDuplicateConstraints) {
            if (!pivotInvariant.isCallable()) continue;
            EOperation eOperation = Pivot2Ecore.createConstraintEOperation(pivotInvariant, pivotInvariant.getName(), ((Pivot2Ecore)this.context).getOptions());
            eOperations.add(eOperation);
            ((Pivot2Ecore)this.context).putCreated(pivotInvariant, (EModelElement)eOperation);
            this.copyConstraint((EModelElement)eOperation, pivotInvariant);
        }
        if (!((Pivot2Ecore)this.context).isSuppressDuplicates()) {
            ArrayList<Object> eDuplicates = null;
            Iterable duplicateConstraints = Iterables.filter(pivotClass.getOwnedInvariant(), (Predicate)duplicateConstraintsFilter);
            for (Constraint asConstraint : duplicateConstraints) {
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList<Object>();
                }
                if (!asConstraint.isCallable()) continue;
                EOperation eOperation = Pivot2Ecore.createConstraintEOperation(asConstraint, asConstraint.getName(), ((Pivot2Ecore)this.context).getOptions());
                eOperations.add(eOperation);
                ((Pivot2Ecore)this.context).putCreated(asConstraint, (EModelElement)eOperation);
                this.copyConstraint((EModelElement)eOperation, asConstraint);
                eDuplicates.add(eOperation);
                ((Pivot2Ecore)this.context).defer(asConstraint);
            }
            Iterable duplicateOperations = Iterables.filter(pivotClass.getOwnedOperation(), (Predicate)duplicateOperationsFilter);
            for (Operation asOperation : duplicateOperations) {
                Object eOperation;
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList();
                }
                if (!((eOperation = this.safeVisit(asOperation)) instanceof EOperation)) continue;
                eDuplicates.add((EOperation)eOperation);
            }
            Iterable duplicateProperties = Iterables.filter(pivotClass.getOwnedAttribute(), (Predicate)duplicatePropertiesFilter);
            for (Property asProperty : duplicateProperties) {
                Object eStructuralFeature;
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList();
                }
                if (!((eStructuralFeature = this.safeVisit(asProperty)) instanceof EStructuralFeature)) continue;
                eDuplicates.add((EStructuralFeature)eStructuralFeature);
            }
            if (eDuplicates != null) {
                EAnnotation eAnnotation = eClass.getEAnnotation("duplicates");
                if (eAnnotation == null) {
                    eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource("duplicates");
                    eClass.getEAnnotations().add((Object)eAnnotation);
                }
                ((Pivot2Ecore)this.context).refreshList(eAnnotation.getContents(), eDuplicates);
            }
        }
        return eClass;
    }

    @Override
    public EObject visitConstraint(@NonNull Constraint pivotConstraint) {
        EModelElement eModelElement;
        Element eContainer = (Element)pivotConstraint.eContainer();
        if (eContainer != null && (eModelElement = ((Pivot2Ecore)this.context).getCreated(EModelElement.class, eContainer)) != null) {
            this.copyConstraint(eModelElement, pivotConstraint);
            return null;
        }
        return null;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        if (pivotDataType.getTemplateBinding().size() > 0) {
            return null;
        }
        EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.copyDataTypeOrEnum(eDataType, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitEnumeration(@NonNull Enumeration pivotEnumeration) {
        if (pivotEnumeration.getTemplateBinding().size() > 0) {
            return null;
        }
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.copyDataTypeOrEnum((EDataType)eEnum, pivotEnumeration);
        EList eLiterals = eEnum.getELiterals();
        this.safeVisitAll((List)eLiterals, (Iterable<? extends Element>)pivotEnumeration.getOwnedLiteral());
        return eEnum;
    }

    @Override
    public EObject visitEnumerationLiteral(@NonNull EnumerationLiteral pivotEnumLiteral) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        this.copyNamedElement((ENamedElement)eEnumLiteral, pivotEnumLiteral);
        if (pivotEnumLiteral.eIsSet((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE)) {
            eEnumLiteral.setValue(pivotEnumLiteral.getValue().intValue());
        } else {
            eEnumLiteral.eUnset((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE);
        }
        return eEnumLiteral;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        if (pivotOperation.getTemplateBinding().size() > 0) {
            return null;
        }
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        this.copyTypedElement((ETypedElement)eOperation, pivotOperation);
        EList eTypeParameters = eOperation.getETypeParameters();
        this.copyTemplateSignature((List<ETypeParameter>)eTypeParameters, pivotOperation);
        EList eParameters = eOperation.getEParameters();
        this.safeVisitAll((List)eParameters, (Iterable<? extends Element>)pivotOperation.getOwnedParameter());
        OpaqueExpression bodyExpression = pivotOperation.getBodyExpression();
        if (bodyExpression != null) {
            EAnnotation eAnnotation = this.delegateInstaller.createOperationDelegate(eOperation, bodyExpression, ((Pivot2Ecore)this.context).getEcoreURI());
        }
        for (Constraint pivotConstraint : pivotOperation.getPrecondition()) {
            this.safeVisit(pivotConstraint);
        }
        for (Constraint pivotConstraint : pivotOperation.getPostcondition()) {
            this.safeVisit(pivotConstraint);
        }
        return eOperation;
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.copyNamedElement((ENamedElement)ePackage, pivotPackage);
        EList eAnnotations = ePackage.getEAnnotations();
        this.safeVisitAll((List)eAnnotations, (Iterable<? extends Element>)pivotPackage.getOwnedAnnotation());
        ((Pivot2Ecore)this.context).defer(pivotPackage);
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_PREFIX)) {
            ePackage.setNsPrefix(pivotPackage.getNsPrefix());
        }
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_URI)) {
            ePackage.setNsURI(pivotPackage.getNsURI());
        }
        EList eSubpackages = ePackage.getESubpackages();
        this.safeVisitAll((List)eSubpackages, (Iterable<? extends Element>)pivotPackage.getNestedPackage());
        EList eClassifiers = ePackage.getEClassifiers();
        this.safeVisitAll((List)eClassifiers, (Iterable<? extends Element>)pivotPackage.getOwnedType());
        return ePackage;
    }

    @Override
    public EObject visitParameter(@NonNull Parameter pivotParameter) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        this.copyTypedElement((ETypedElement)eParameter, pivotParameter);
        return eParameter;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        EAnnotation eAnnotation;
        EAttribute eStructuralFeature;
        if (pivotProperty.isImplicit()) {
            return null;
        }
        Type type = pivotProperty.getType();
        CollectionType ecoreCollectionType = ((Pivot2Ecore)this.context).isEcoreCollection(type);
        if (ecoreCollectionType != null) {
            type = ecoreCollectionType.getElementType();
        }
        if (type instanceof DataType) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            eAttribute.setID(pivotProperty.isID());
            eStructuralFeature = eAttribute;
        } else {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
                ((Pivot2Ecore)this.context).defer(pivotProperty);
            }
            eReference.setContainment(pivotProperty.isComposite());
            eReference.setResolveProxies(pivotProperty.isResolveProxies());
            eStructuralFeature = eReference;
        }
        Property opposite = pivotProperty.getOpposite();
        if (opposite != null && opposite.isImplicit() && (eAnnotation = this.createOppositeEAnnotation(opposite)) != null) {
            eStructuralFeature.getEAnnotations().add((Object)eAnnotation);
        }
        this.copyTypedElement((ETypedElement)eStructuralFeature, pivotProperty);
        eStructuralFeature.setChangeable(!pivotProperty.isReadOnly());
        eStructuralFeature.setDerived(pivotProperty.isDerived());
        eStructuralFeature.setTransient(pivotProperty.isTransient());
        eStructuralFeature.setUnsettable(pivotProperty.isUnsettable());
        eStructuralFeature.setVolatile(pivotProperty.isVolatile());
        if (pivotProperty.eIsSet((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT)) {
            eStructuralFeature.setDefaultValueLiteral(pivotProperty.getDefault());
        } else {
            eStructuralFeature.eUnset((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL);
        }
        OpaqueExpression defaultExpression = pivotProperty.getDefaultExpression();
        if (defaultExpression != null) {
            this.delegateInstaller.createPropertyDelegate((EStructuralFeature)eStructuralFeature, defaultExpression, ((Pivot2Ecore)this.context).getEcoreURI());
        }
        return eStructuralFeature;
    }

    @Override
    public Object visitRoot(@NonNull Root pivotRoot) {
        EModelElement firstElement = null;
        ArrayList<EObject> outputObjects = new ArrayList<EObject>();
        for (Package pivotObject : pivotRoot.getNestedPackage()) {
            Object ecoreObject;
            if (Orphanage.isTypeOrphanage(pivotObject) || !((ecoreObject = this.safeVisit(pivotObject)) instanceof EObject)) continue;
            outputObjects.add((EObject)ecoreObject);
            if (firstElement != null || !(ecoreObject instanceof EModelElement)) continue;
            firstElement = (EModelElement)ecoreObject;
        }
        List<Import> imports = pivotRoot.getImports();
        if (imports.size() > 0) {
            if (imports.size() > 0) {
                imports = new ArrayList<Import>(imports);
                Collections.sort(imports, new Comparator<Import>(){

                    @Override
                    public int compare(Import o1, Import o2) {
                        String n1 = o1.getName();
                        String n2 = o2.getName();
                        if (n1 == null) {
                            n1 = "";
                        }
                        if (n2 == null) {
                            n1 = "";
                        }
                        return n1.compareTo(n2);
                    }
                });
            }
            EAnnotation importAnnotation = null;
            URI ecoreURI = ((Pivot2Ecore)this.context).getEcoreURI();
            for (Import anImport : imports) {
                EObject eTarget;
                Namespace importedNamespace = anImport.getImportedNamespace();
                if (importedNamespace == null) continue;
                if (importAnnotation == null) {
                    importAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    importAnnotation.setSource("http://www.eclipse.org/OCL/Import");
                }
                if ((eTarget = importedNamespace.getETarget()) != null) {
                    String nsURI;
                    URI uri = null;
                    if (eTarget instanceof EPackage && DomainUtil.isRegistered((Resource)eTarget.eResource()) && (nsURI = ((EPackage)eTarget).getNsURI()) != null) {
                        uri = URI.createURI((String)nsURI);
                    }
                    if (uri == null) {
                        uri = EcoreUtil.getURI((EObject)eTarget);
                    }
                    URI uri2 = uri.deresolve(ecoreURI, true, true, true);
                    importAnnotation.getDetails().put((Object)anImport.getName(), (Object)uri2.toString());
                    continue;
                }
                if (importedNamespace instanceof Package) {
                    importAnnotation.getDetails().put((Object)anImport.getName(), (Object)((Package)importedNamespace).getNsURI());
                    continue;
                }
                importAnnotation.getDetails().put((Object)anImport.getName(), (Object)importedNamespace.toString());
            }
            if (firstElement != null && importAnnotation != null) {
                firstElement.getEAnnotations().add(importAnnotation);
            }
        }
        return outputObjects;
    }

    @Override
    public EObject visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        eTypeParameter.setName(((Type)pivotTypeTemplateParameter.getParameteredElement()).getName());
        ((Pivot2Ecore)this.context).putCreated(pivotTypeTemplateParameter, (EModelElement)eTypeParameter);
        if (!pivotTypeTemplateParameter.getConstrainingType().isEmpty()) {
            ((Pivot2Ecore)this.context).defer(pivotTypeTemplateParameter);
        }
        return eTypeParameter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DuplicateConstraintsFilter
    implements Predicate<Constraint> {
        protected DuplicateConstraintsFilter() {
        }

        public boolean apply(@Nullable Constraint aConstraint) {
            if (aConstraint == null) {
                return false;
            }
            return aConstraint.getRedefinedConstraint().size() != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DuplicateOperationsFilter
    implements Predicate<Operation> {
        protected DuplicateOperationsFilter() {
        }

        public boolean apply(@Nullable Operation anOperation) {
            if (anOperation == null) {
                return false;
            }
            if (anOperation.getRedefinedOperation().size() == 0) {
                return false;
            }
            return !"containingActivity".equals(anOperation.getName()) || !"ActivityNode".equals(anOperation.getOwningType().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DuplicatePropertiesFilter
    implements Predicate<Property> {
        protected DuplicatePropertiesFilter() {
        }

        public boolean apply(@Nullable Property aProperty) {
            if (aProperty == null) {
                return false;
            }
            if (aProperty.getRedefinedProperty().size() == 0) {
                return false;
            }
            return DomainUtil.safeEquals((Object)aProperty.getName(), (Object)aProperty.getRedefinedProperty().get(0).getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonDuplicateConstraintsFilter
    implements Predicate<Constraint> {
        protected NonDuplicateConstraintsFilter() {
        }

        public boolean apply(@Nullable Constraint aConstraint) {
            if (aConstraint == null) {
                return false;
            }
            return aConstraint.getRedefinedConstraint().size() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonDuplicateOperationsFilter
    implements Predicate<Operation> {
        protected NonDuplicateOperationsFilter() {
        }

        public boolean apply(@Nullable Operation anOperation) {
            if (anOperation == null) {
                return false;
            }
            if (anOperation.getRedefinedOperation().size() == 0) {
                return true;
            }
            return "containingActivity".equals(anOperation.getName()) && "ActivityNode".equals(anOperation.getOwningType().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonDuplicatePropertiesFilter
    implements Predicate<Property> {
        protected NonDuplicatePropertiesFilter() {
        }

        public boolean apply(@Nullable Property aProperty) {
            if (aProperty == null) {
                return false;
            }
            if (aProperty.getRedefinedProperty().size() == 0) {
                return true;
            }
            return !DomainUtil.safeEquals((Object)aProperty.getName(), (Object)aProperty.getRedefinedProperty().get(0).getName());
        }
    }
}

