/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.delegate.DelegateInstaller;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreDeclarationVisitor;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreReferenceVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.options.OCLinEcoreOptions;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2Ecore
extends AbstractConversion {
    public static final Logger logger = Logger.getLogger(Pivot2Ecore.class);
    @NonNull
    public static final String OPTION_ADD_INVARIANT_COMMENTS = "addInvariantComments";
    @NonNull
    public static final String OPTION_BOOLEAN_INVARIANTS = "booleanInvariants";
    @NonNull
    public static final String OPTION_SUPPRESS_DUPLICATES = "suppressDuplicates";
    @NonNull
    private final Map<Element, EModelElement> createMap = new HashMap<Element, EModelElement>();
    @NonNull
    private final Set<Element> deferMap = new HashSet<Element>();
    @Nullable
    private List<Resource.Diagnostic> errors = null;
    @NonNull
    protected final Map<String, Object> options;
    @NonNull
    protected final DelegateInstaller delegateInstaller;
    @NonNull
    protected final Pivot2EcoreDeclarationVisitor pass1;
    @NonNull
    protected final Pivot2EcoreReferenceVisitor pass2;
    @NonNull
    protected final URI ecoreURI;
    @Nullable
    protected final String primitiveTypesUriPrefix;

    public static void copyAnnotationComments(@NonNull EAnnotation eModelElement, @NonNull Constraint pivotConstraint) {
        String key = DelegateInstaller.getAnnotationKey(pivotConstraint);
        EAnnotation commentAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        List<Comment> newComments = pivotConstraint.getOwnedComment();
        int iMax = newComments.size();
        if (iMax > 0) {
            if (commentAnnotation == null) {
                commentAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                commentAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                eModelElement.getEAnnotations().add((Object)commentAnnotation);
            }
            StringBuilder s = new StringBuilder();
            int iComment = 0;
            while (iComment < iMax) {
                if (iComment > 0) {
                    s.append("\n");
                }
                s.append(newComments.get(iComment).getBody());
                ++iComment;
            }
            commentAnnotation.getDetails().put((Object)key, (Object)s.toString());
        } else if (commentAnnotation != null) {
            commentAnnotation.getDetails().remove((Object)key);
        }
    }

    public static void copyComments(EModelElement eModelElement, Element pivotElement) {
        EList allEAnnotations = eModelElement.getEAnnotations();
        List<Comment> newComments = pivotElement.getOwnedComment();
        int iComment = 0;
        int iMax = newComments.size();
        ArrayList<EAnnotation> removals = null;
        for (EAnnotation eAnnotation : allEAnnotations) {
            if (!"http://www.eclipse.org/emf/2002/GenModel".equals(eAnnotation.getSource())) continue;
            if (iComment >= iMax) {
                if (removals == null) {
                    removals = new ArrayList<EAnnotation>();
                }
                removals.add(eAnnotation);
            } else {
                String body = newComments.get(iComment).getBody();
                eAnnotation.getDetails().put((Object)"documentation", (Object)body);
            }
            ++iComment;
        }
        while (iComment < iMax) {
            EAnnotation eAnnotation;
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            String body = newComments.get(iComment).getBody();
            eAnnotation.getDetails().put((Object)"documentation", (Object)body);
            allEAnnotations.add((Object)eAnnotation);
            ++iComment;
        }
        if (removals != null) {
            allEAnnotations.removeAll(removals);
        }
    }

    @Deprecated
    @NonNull
    public static EOperation createConstraintEOperation(Constraint pivotConstraint, String operationName) {
        return Pivot2Ecore.createConstraintEOperation(pivotConstraint, operationName, null);
    }

    @NonNull
    public static EOperation createConstraintEOperation(Constraint pivotConstraint, String operationName, @Nullable Map<String, Object> options) {
        String body;
        OpaqueExpression specification;
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        boolean addInvariantComments = Pivot2Ecore.isAddInvariantComments(options);
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(operationName != null ? operationName : "");
        eOperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        EParameter firstParameter = EcoreFactory.eINSTANCE.createEParameter();
        firstParameter.setName("diagnostics");
        firstParameter.setEType((EClassifier)EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
        eOperation.getEParameters().add((Object)firstParameter);
        if (addInvariantComments) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            eAnnotation.getDetails().put((Object)"documentation", (Object)"The chain of diagnostics to which problems are to be appended.");
            firstParameter.getEAnnotations().add((Object)eAnnotation);
        }
        EParameter secondParameter = EcoreFactory.eINSTANCE.createEParameter();
        secondParameter.setName("context");
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)EcorePackage.Literals.EMAP);
        EGenericType firstTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        firstTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)firstTypeArgument);
        EGenericType secondTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        secondTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)secondTypeArgument);
        secondParameter.setEGenericType(eGenericType);
        eOperation.getEParameters().add((Object)secondParameter);
        if (addInvariantComments) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            eAnnotation.getDetails().put((Object)"documentation", (Object)"The cache of context-specific information.");
            secondParameter.getEAnnotations().add((Object)eAnnotation);
        }
        if ((specification = pivotConstraint.getSpecification()) != null && (body = PivotUtil.getBody(specification)) != null) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(Pivot2Ecore.getExportDelegateURI(options));
            if (DelegateInstaller.isBooleanInvariants(options)) {
                body = "result = (" + body + ")";
            }
            eAnnotation.getDetails().put((Object)"body", (Object)body);
            eOperation.getEAnnotations().add((Object)eAnnotation);
        }
        Pivot2Ecore.copyComments((EModelElement)eOperation, pivotConstraint);
        return eOperation;
    }

    @NonNull
    public static XMLResource createResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource asResource, @NonNull URI ecoreURI, @Nullable Map<String, Object> options) {
        Pivot2Ecore converter = new Pivot2Ecore(metaModelManager, ecoreURI, options);
        return converter.convertResource(asResource, ecoreURI);
    }

    @NonNull
    public static Boolean getBoolean(@Nullable Map<String, Object> options, @NonNull String key) {
        if (options == null) {
            return false;
        }
        Object value = options.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            logger.error((Object)("Non-Boolean '" + key + "' for '" + value + "'"));
        }
        return false;
    }

    @Nullable
    public static String getExportDelegateURI(@Nullable Map<String, Object> options) {
        String exportDelegateURI = options != null ? (String)options.get("http://www.eclipse.org/emf/2002/Ecore/OCL") : null;
        return exportDelegateURI != null ? exportDelegateURI : (String)OCLinEcoreOptions.EXPORT_DELEGATION_URI.getPreferredValue();
    }

    @Nullable
    public static String getString(@Nullable Map<String, Object> options, @NonNull String key) {
        if (options == null) {
            return null;
        }
        Object value = options.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            logger.error((Object)("Non-String '" + key + "' for '" + value + "'"));
        }
        return null;
    }

    public static boolean isAddInvariantComments(@NonNull Map<String, Object> options) {
        return Boolean.valueOf(String.valueOf(options.get(OPTION_ADD_INVARIANT_COMMENTS)));
    }

    public static boolean isBooleanInvariants(@NonNull Map<String, Object> options) {
        return Boolean.valueOf(String.valueOf(options.get(OPTION_BOOLEAN_INVARIANTS)));
    }

    public Pivot2Ecore(@NonNull MetaModelManager metaModelManager, @NonNull URI ecoreURI, @Nullable Map<String, Object> options) {
        super(metaModelManager);
        this.options = options != null ? options : new HashMap<String, Object>();
        this.delegateInstaller = new DelegateInstaller(metaModelManager, options);
        this.pass1 = new Pivot2EcoreDeclarationVisitor(this);
        this.pass2 = new Pivot2EcoreReferenceVisitor(this);
        this.ecoreURI = ecoreURI;
        this.primitiveTypesUriPrefix = Pivot2Ecore.getString(options, "PRIMITIVE_TYPES_URI_PREFIX");
    }

    @Nullable
    protected Object convert(@NonNull Element pivotObject) {
        Object eObject = this.pass1.safeVisit(pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit(eKey);
        }
        return eObject;
    }

    @NonNull
    public XMLResource convertResource(@NonNull Resource asResource, @NonNull URI ecoreURI) {
        ResourceSet resourceSet = this.metaModelManager.getExternalResourceSet();
        this.setGenerationInProgress(asResource, true);
        try {
            XMLResource ecoreResource = (XMLResource)resourceSet.createResource(ecoreURI);
            EList contents = ecoreResource.getContents();
            for (EObject eContent : asResource.getContents()) {
                Object results;
                if (!(eContent instanceof Root) || !((results = this.pass1.safeVisit((Root)eContent)) instanceof List)) continue;
                List results2 = (List)results;
                contents.addAll(results2);
            }
            for (Element eKey : this.deferMap) {
                this.pass2.safeVisit(eKey);
            }
            for (Element pivotElement : this.createMap.keySet()) {
                EObject eObject = (EObject)this.createMap.get(pivotElement);
                ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)eObject);
            }
            XMLResource xMLResource = ecoreResource;
            return xMLResource;
        }
        finally {
            this.setGenerationInProgress(asResource, false);
        }
    }

    public void defer(@NonNull Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    protected void error(@NonNull String message) {
        List<Resource.Diagnostic> errors2 = this.errors;
        if (errors2 == null) {
            this.errors = errors2 = new ArrayList<Resource.Diagnostic>();
        }
        errors2.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends EObject> T getCreated(@NonNull Class<T> requiredClass, @NonNull Element pivotElement) {
        Element primaryElement;
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null && pivotElement != (primaryElement = this.metaModelManager.getPrimaryElement(pivotElement))) {
            eModelElement = this.createMap.get(primaryElement);
        }
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            logger.error((Object)("Ecore " + eModelElement.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
            return null;
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    @NonNull
    public DelegateInstaller getDelegateInstaller() {
        return this.delegateInstaller;
    }

    @NonNull
    public final URI getEcoreURI() {
        return this.ecoreURI;
    }

    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getPrimitiveTypesUriPrefix() {
        return this.primitiveTypesUriPrefix;
    }

    @Nullable
    public CollectionType isEcoreCollection(@Nullable Type asType) {
        if (!(asType instanceof CollectionType)) {
            return null;
        }
        if (asType.getUnspecializedElement() == this.metaModelManager.getCollectionType()) {
            return null;
        }
        return (CollectionType)asType;
    }

    public boolean isPivot(@NonNull Package asPackage) {
        List<Type> asTypes = asPackage.getOwnedType();
        if (DomainUtil.getNamedElement(asTypes, (String)PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (DomainUtil.getNamedElement(asTypes, (String)PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (DomainUtil.getNamedElement(asTypes, (String)PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return DomainUtil.getNamedElement(asTypes, (String)PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    public boolean isSuppressDuplicates() {
        return Boolean.valueOf(String.valueOf(this.options.get(OPTION_SUPPRESS_DUPLICATES)));
    }

    public void putCreated(@NonNull Element pivotElement, @NonNull EModelElement eModelElement) {
        Element primaryElement = this.metaModelManager.getPrimaryElement(pivotElement);
        EModelElement oldPivot = this.createMap.put(pivotElement, eModelElement);
        assert (oldPivot == null);
        if (pivotElement != primaryElement && !this.createMap.containsKey(primaryElement)) {
            this.createMap.put(primaryElement, eModelElement);
        }
    }

    protected void setGenerationInProgress(@NonNull Resource asResource, boolean isLoading) {
        for (EObject eRoot : asResource.getContents()) {
            if (!(eRoot instanceof Root)) continue;
            for (Package asPackage : ((Root)eRoot).getNestedPackage()) {
                if (asPackage == null) continue;
                this.setGenerationInProgress(asPackage, isLoading);
            }
        }
    }

    protected void setGenerationInProgress(@NonNull Package asPackage, boolean isGenerating) {
        URI nsURI;
        StandaloneProjectMap projectMap;
        StandaloneProjectMap.IPackageDescriptor packageDescriptor;
        String nsUri = asPackage.getNsURI();
        if (nsUri != null && (packageDescriptor = (projectMap = this.metaModelManager.getProjectMap()).getPackageDescriptor(nsURI = URI.createURI((String)nsUri))) != null) {
            StandaloneProjectMap.IResourceDescriptor resourceDescriptor = packageDescriptor.getResourceDescriptor();
            ResourceSet resourceSet = this.metaModelManager.getExternalResourceSet();
            StandaloneProjectMap.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
            resourceLoadStatus.setGenerationInProgress(isGenerating);
        }
        for (Package asNestedPackage : asPackage.getNestedPackage()) {
            if (asNestedPackage == null) continue;
            this.setGenerationInProgress(asNestedPackage, isGenerating);
        }
    }
}

