/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.EvaluationException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.ConstraintEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLValidationDelegate
implements ValidationDelegate {
    @NonNull
    protected final OCLDelegateDomain delegateDomain;
    @NonNull
    protected final EClassifier eClassifier;

    public OCLValidationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    @NonNull
    public ExpressionInOCL getExpressionInOCL(@NonNull MetaModelManager metaModelManager, @NonNull Constraint constraint) {
        ExpressionInOCL query = null;
        OpaqueExpression valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOCL) {
            query = (ExpressionInOCL)valueSpecification;
        } else {
            Type contextType = (Type)((Object)constraint.getContext());
            if (contextType != null) {
                ClassContext classContext = new ClassContext(metaModelManager, null, contextType);
                query = ValidationBehavior.INSTANCE.getExpressionInOCL(classContext, constraint);
            }
        }
        if (query == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{constraint.getContext()});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return query;
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        MetaModelManager metaModelManager = this.delegateDomain.getMetaModelManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)DomainUtil.nonNullEMF((Object)invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getExpressionInOCL(metaModelManager, operation);
            InvocationBehavior.INSTANCE.validate(operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = this.getExpressionInOCL(metaModelManager, constraint);
            ValidationBehavior.INSTANCE.validate(constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new ClassCastException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    @Override
    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull EOperation invariant, String expression, int severity, String source, int code) {
        MetaModelManager metaModelManager = this.delegateDomain.getMetaModelManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)DomainUtil.nonNullEMF((Object)invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getExpressionInOCL(metaModelManager, operation);
            InvocationBehavior.INSTANCE.validate(operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = this.getExpressionInOCL(metaModelManager, constraint);
            ValidationBehavior.INSTANCE.validate(constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, diagnostics, context, invariant.getName(), source, code, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new ClassCastException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraintName, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eClass, eObject, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context, constraintName, source, code);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraintName, String expression) {
        if (eDataType == null) {
            throw new NullPointerException("Null EClass");
        }
        if (value == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eDataType, value, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(@NonNull EDataType eDataType, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context, constraintName, source, code);
    }

    protected boolean validateExpressionInOCL(@NonNull EClassifier eClassifier, final @NonNull Object value, final @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, final String source, final int code, @NonNull ExpressionInOCL query) {
        CheckingConstraintEvaluator constraintEvaluator = new CheckingConstraintEvaluator(eClassifier, query){

            protected String getObjectLabel() {
                return EcoreUtils.qualifiedNameFor((Object)value);
            }

            protected Boolean handleFailureResult(@Nullable Object result) {
                if (result == null) {
                    String message = this.getConstraintResultMessage(result);
                    throw new OCLDelegateException((Exception)new EvaluationException(message));
                }
                if (diagnostics != null) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
                }
                return Boolean.FALSE;
            }
        };
        OCL ocl = this.delegateDomain.getOCL();
        EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor(value, query);
        return (Boolean)((ConstraintEvaluator)constraintEvaluator).evaluate(evaluationVisitor);
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String source, int code) {
        MetaModelManager metaModelManager = this.delegateDomain.getMetaModelManager();
        Type type = this.delegateDomain.getPivot(Type.class, (EObject)eClassifier);
        Constraint constraint = ValidationBehavior.INSTANCE.getConstraint(metaModelManager, eClassifier, constraintName);
        if (constraint == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        ExpressionInOCL query = null;
        OpaqueExpression valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOCL) {
            query = (ExpressionInOCL)valueSpecification;
        } else if (type != null) {
            ClassContext classContext = new ClassContext(metaModelManager, null, type);
            query = ValidationBehavior.INSTANCE.getExpressionInOCL(classContext, constraint);
        }
        if (query == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return this.validateExpressionInOCL(eClassifier, value, diagnostics, context, constraintName, source, code, query);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CheckingConstraintEvaluator
    extends ConstraintEvaluator<Boolean> {
        @NonNull
        protected final EClassifier eClassifier;

        protected CheckingConstraintEvaluator(@NonNull EClassifier eClassifier, @NonNull ExpressionInOCL query) {
            super(query);
            this.eClassifier = eClassifier;
        }

        @Override
        public Boolean evaluate(@NonNull EvaluationVisitor evaluationVisitor) {
            if (!this.isBooleanConstraint()) {
                String objectLabel = DomainUtil.getLabel((EObject)this.expression.getType());
                String checkMessage = DomainUtil.bind((String)OCLMessages.ValidationConstraintIsNotBooleanType_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), objectLabel});
                throw new OCLDelegateException((Exception)new EvaluationException(checkMessage));
            }
            return (Boolean)super.evaluate(evaluationVisitor);
        }

        @Override
        protected String getObjectLabel() {
            return DomainUtil.getLabel((EClassifier)this.eClassifier, null, null);
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString()});
            throw new OCLDelegateException((Exception)new EvaluationException(message, e));
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            if (result == null) {
                String message = this.getConstraintResultMessage(result);
                throw new OCLDelegateException((Exception)new EvaluationException(message));
            }
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            throw new OCLDelegateException((Exception)new EvaluationException(message));
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
            throw new OCLDelegateException((Exception)new EvaluationException(message, e));
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }
}

