/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.AbstractMetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public abstract class AbstractParserContext
implements ParserContext {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final URI uri;

    protected AbstractParserContext(@NonNull MetaModelManager metaModelManager, @Nullable URI uri) {
        this.metaModelManager = metaModelManager;
        this.uri = uri != null ? uri : (URI)DomainUtil.nonNullEMF((Object)URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + ".essentialocl")));
    }

    @NonNull
    public BaseResource createBaseResource(@NonNull String expression) throws IOException, ParserException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(expression, "UTF-8");
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(this.uri);
            if (resource == null) {
                throw new ParserException("Failed to load '" + this.uri + "'");
            }
            if (!(resource instanceof BaseResource)) {
                throw new ParserException("Failed to create Xtext resource for '" + this.uri + "'\n\tMake sure EssentialOCL has been initialized.");
            }
            BaseResource baseResource = (BaseResource)resource;
            MetaModelManagerResourceAdapter.getAdapter(resource, this.metaModelManager);
            baseResource.setParserContext(this);
            baseResource.load((InputStream)inputStream, null);
            BaseResource baseResource2 = baseResource;
            return baseResource2;
        }
        finally {
            inputStream.close();
        }
    }

    @Nullable
    public Type getClassContext() {
        return null;
    }

    @NonNull
    public ExpressionInOCL getExpression(@NonNull BaseResource resource) throws ParserException {
        Element pivotElement;
        EList contents = resource.getContents();
        int size = contents.size();
        if (size < 1) {
            throw new ParserException("Missing parse returns");
        }
        if (size > 1) {
            throw new ParserException("Extra parse returns");
        }
        EObject csObject = (EObject)contents.get(0);
        if (csObject instanceof Pivotable && (pivotElement = ((Pivotable)csObject).getPivot()) instanceof ExpressionInOCL) {
            return (ExpressionInOCL)pivotElement;
        }
        throw new ParserException("Non-expression ignored");
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public void initialize(@NonNull Base2PivotConversion conversion, @NonNull ExpressionInOCL expression) {
        List<String> language = expression.getLanguage();
        language.clear();
        language.add("OCL");
    }

    @Deprecated
    @NonNull
    public ExpressionInOCL parse(@NonNull String expression) throws ParserException {
        return this.parse(null, expression);
    }

    @NonNull
    public ExpressionInOCL parse(@Nullable EObject owner, @NonNull String expression) throws ParserException {
        BaseResource resource = null;
        try {
            resource = this.createBaseResource(expression);
            String childName = owner instanceof Nameable ? ((Nameable)owner).getName() : "<unknown>";
            EObject eContainer = owner != null ? owner.eContainer() : null;
            String parentName = eContainer instanceof Nameable ? ((Nameable)eContainer).getName() : "<unknown>";
            PivotUtil.checkResourceErrors(DomainUtil.bind((String)OCLMessages.ValidationConstraintIsInvalid_ERROR_, (Object[])new Object[]{parentName, childName, expression.trim()}), resource);
            ExpressionInOCL expressionInOCL = this.getExpression(resource);
            PivotUtil.setBody(expressionInOCL, expression);
            ExpressionInOCL expressionInOCL2 = expressionInOCL;
            return expressionInOCL2;
        }
        catch (IOException e) {
            ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
            InvalidLiteralExp invalidValueBody = this.metaModelManager.createInvalidExpression();
            PivotUtil.setBody(specification, invalidValueBody, null);
            ExpressionInOCL expressionInOCL = specification;
            return expressionInOCL;
        }
        finally {
            if (resource != null) {
                resource.unload();
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    resourceSet.getResources().remove((Object)resource);
                }
                AbstractMetaModelManagerResourceAdapter.disposeAll(resource);
            }
        }
    }
}

