/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBase2PivotConversion
extends AbstractConversion
implements Base2PivotConversion {
    private HashSet<TypedElement> underspecifiedTypedElements = null;

    protected AbstractBase2PivotConversion(@NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
    }

    protected void addUnderspecifiedTypedElement(@NonNull TypedElement pivotElement) {
        if (this.underspecifiedTypedElements == null) {
            this.underspecifiedTypedElements = new HashSet();
        }
        this.underspecifiedTypedElements.add(pivotElement);
    }

    public void refreshName(@NonNull NamedElement pivotNamedElement, @Nullable String newName) {
        String oldName = pivotNamedElement.getName();
        if (!(newName == oldName || newName != null && newName.equals(oldName))) {
            pivotNamedElement.setName(newName);
        }
    }

    public void refreshNsURI(@NonNull Package pivotPackage, String newNsURI) {
        String oldNsURI = pivotPackage.getNsURI();
        if (!(newNsURI == oldNsURI || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotPackage.setNsURI(newNsURI);
        }
    }

    protected void resolveUnderspecifiedTypes() {
        if (this.underspecifiedTypedElements != null) {
            for (TypedElement underspecifiedTypedElement : this.underspecifiedTypedElements) {
                Type underspecifiedType = (Type)DomainUtil.nonNullModel((Object)underspecifiedTypedElement.getType());
                Type resolvedType = this.resolveUnderspecifiedType(underspecifiedType);
                underspecifiedTypedElement.setType(resolvedType);
            }
        }
    }

    @NonNull
    protected Type resolveUnderspecifiedType(@NonNull Type type) {
        if (type instanceof UnspecifiedType) {
            return (Type)DomainUtil.nonNullModel((Object)((UnspecifiedType)type).getLowerBound());
        }
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Type resolvedElementType = this.resolveUnderspecifiedType((Type)DomainUtil.nonNullModel((Object)collectionType.getElementType()));
            return this.metaModelManager.getCollectionType(PivotUtil.getUnspecializedTemplateableElement(collectionType), resolvedElementType, (IntegerValue)null, (IntegerValue)null);
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Property> resolvedProperties = new ArrayList<Property>();
            for (Property part : ((TupleType)type).getOwnedAttribute()) {
                if (this.metaModelManager.isUnderspecified(part.getType())) {
                    Property prop = PivotFactory.eINSTANCE.createProperty();
                    prop.setName(part.getName());
                    prop.setType(this.resolveUnderspecifiedType((Type)DomainUtil.nonNullModel((Object)part.getType())));
                    resolvedProperties.add(prop);
                    continue;
                }
                resolvedProperties.add(part);
            }
            return this.metaModelManager.getTupleType(DomainUtil.getSafeName((Nameable)tupleType), resolvedProperties, null);
        }
        if (type instanceof Metaclass) {
            Metaclass metaclass = (Metaclass)type;
            Type resolvedElementType = this.resolveUnderspecifiedType((Type)DomainUtil.nonNullModel((Object)metaclass.getInstanceType()));
            return this.metaModelManager.getMetaclass(resolvedElementType);
        }
        return type;
    }

    public void setBehavioralType(@NonNull TypedElement targetElement, @NonNull TypedElement sourceElement) {
        Type type;
        if (!(sourceElement.eIsProxy() || (type = PivotUtil.getType(sourceElement)) != null && type.eIsProxy())) {
            this.setType(targetElement, type);
            return;
        }
        this.setType(targetElement, null);
    }

    @Override
    public void setContextVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull String selfVariableName, @Nullable Type contextType) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextVariable == null) {
            Variable nonNullContextVariable;
            contextVariable = nonNullContextVariable = PivotFactory.eINSTANCE.createVariable();
            pivotSpecification.setContextVariable(contextVariable);
        }
        this.refreshName(contextVariable, selfVariableName);
        this.setType(contextVariable, contextType);
    }

    @Override
    public void setClassifierContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Type contextType) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextVariable != null) {
            if (contextType.eIsProxy()) {
                this.setType(contextVariable, null);
            } else {
                this.setType(contextVariable, contextType);
            }
        }
    }

    public void setOperationContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Operation contextOperation, @Nullable String resultName) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextVariable != null && !contextOperation.eIsProxy()) {
            this.setType(contextVariable, contextOperation.getOwningType());
            this.setParameterVariables(pivotSpecification, (List)DomainUtil.nonNullEMF(contextOperation.getOwnedParameter()));
        }
        if (resultName != null) {
            this.setResultVariable(pivotSpecification, contextOperation, resultName);
        }
    }

    @Override
    public void setParameterVariables(@NonNull ExpressionInOCL pivotSpecification, @NonNull List<Parameter> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>(pivotSpecification.getParameterVariable());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            Variable param = (Variable)DomainUtil.getNamedElement(oldVariables, (String)name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setBehavioralType(param, parameter);
            param.setRepresentedParameter(parameter);
            newVariables.add(param);
        }
        this.refreshList((List)DomainUtil.nonNullModel(pivotSpecification.getParameterVariable()), newVariables);
    }

    @Override
    public void setParameterVariables(@NonNull ExpressionInOCL pivotSpecification, @NonNull Map<String, Type> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>(pivotSpecification.getParameterVariable());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (String name : parameters.keySet()) {
            Type type = parameters.get(name);
            Variable param = (Variable)DomainUtil.getNamedElement(oldVariables, (String)name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setType(param, type);
            newVariables.add(param);
        }
        this.refreshList((List)DomainUtil.nonNullModel(pivotSpecification.getParameterVariable()), newVariables);
    }

    public void setPropertyContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Property contextProperty) {
        Variable contextVariable = pivotSpecification.getContextVariable();
        if (contextVariable != null && !contextProperty.eIsProxy()) {
            this.setType(contextVariable, contextProperty.getOwningType());
        }
    }

    @Override
    public void setResultVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull Operation contextOperation, @NonNull String resultName) {
        Type returnType = contextOperation.getType();
        if (returnType != null) {
            Variable resultVariable = pivotSpecification.getResultVariable();
            if (resultVariable == null) {
                resultVariable = PivotFactory.eINSTANCE.createVariable();
            }
            resultVariable.setName(resultName);
            this.setBehavioralType(resultVariable, contextOperation);
            pivotSpecification.setResultVariable(resultVariable);
        } else {
            pivotSpecification.setResultVariable(null);
        }
    }

    @Deprecated
    public void setType(@NonNull TypedElement pivotElement, Type type) {
        this.setType(pivotElement, type, pivotElement.isRequired());
    }

    public void setType(@NonNull TypedElement pivotElement, Type type, boolean isRequired) {
        boolean wasRequired;
        Type primaryType;
        Type type2 = primaryType = type != null ? this.metaModelManager.getPrimaryType(type) : null;
        if (primaryType != pivotElement.getType()) {
            pivotElement.setType(primaryType);
            if (this.metaModelManager.isUnderspecified(primaryType)) {
                this.addUnderspecifiedTypedElement(pivotElement);
            }
        }
        if ((wasRequired = pivotElement.isRequired()) != isRequired) {
            pivotElement.setIsRequired(isRequired);
        }
        if (primaryType != null) {
            PivotUtil.debugWellContainedness(primaryType);
        }
    }
}

