/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.pivot.AbstractEnvironment;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironmentFactory
implements EnvironmentFactory,
Adaptable {
    private boolean traceEvaluation;

    protected AbstractEnvironmentFactory() {
    }

    protected Environment createPackageContext(@NonNull Environment parent, @NonNull Package context) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextPackage(context);
        }
        return result;
    }

    @Override
    @NonNull
    public Environment createClassifierContext(@NonNull Environment parent, @NonNull Type context) {
        Environment result = this.createEnvironment(parent);
        Variable self = parent.getOCLFactory().createVariable();
        self.setName("self");
        self.setType(context);
        result.setSelfVariable(self);
        return result;
    }

    @Override
    @NonNull
    public Environment createInstanceContext(@NonNull Environment parent, @NonNull Object context) {
        return this.createClassifierContext(parent, this.getClassifier(context));
    }

    @Override
    @NonNull
    public Environment createOperationContext(@NonNull Environment parent, @NonNull Operation operation) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextOperation(operation);
        }
        PivotFactory oclFactory = parent.getOCLFactory();
        for (Parameter next : operation.getOwnedParameter()) {
            Variable var = oclFactory.createVariable();
            var.setName(next.getName());
            var.setType(next.getType());
            var.setRepresentedParameter(next);
        }
        return result;
    }

    @Override
    @NonNull
    public Environment createPropertyContext(@NonNull Environment parent, @NonNull Property property) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextProperty(property);
        }
        return result;
    }

    @Override
    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@Nullable Environment environment, @Nullable Object context, @NonNull ExpressionInOCL expression, @Nullable DomainModelManager modelManager) {
        if (environment == null) {
            environment = this.createEnvironment();
        }
        EvaluationEnvironment evaluationEnvironment = this.createEvaluationEnvironment();
        Variable contextVariable = expression.getContextVariable();
        if (contextVariable != null) {
            PivotIdResolver idResolver = evaluationEnvironment.getMetaModelManager().getIdResolver();
            Object value = idResolver.boxedValueOf(context);
            evaluationEnvironment.add(contextVariable, value);
        }
        for (Variable parameterVariable : expression.getParameterVariable()) {
            if (parameterVariable == null) continue;
            evaluationEnvironment.add(parameterVariable, null);
        }
        DomainModelManager extents = modelManager;
        if (extents == null) {
            extents = evaluationEnvironment.createModelManager(context);
        }
        return this.createEvaluationVisitor(environment, evaluationEnvironment, extents);
    }

    @Override
    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull DomainModelManager modelManager) {
        AbstractExtendingVisitor result = new EvaluationVisitorImpl(env, evalEnv, modelManager);
        if (this.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor((EvaluationVisitor)((Object)result));
        }
        return result;
    }

    @NonNull
    protected abstract Type getClassifier(@NonNull Object var1);

    protected boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEnvironmentFactory result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }
}

