/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.ordering;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.OrderingFactory;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public final class RefreshOrderingHelper {
    private static final Predicate<DDiagramElement> DELIMITED_EVENT_PREDICATE = Predicates.or((Predicate[])new Predicate[]{AbstractNodeEvent.viewpointElementPredicate(), State.viewpointElementPredicate(), InteractionUse.viewpointElementPredicate(), CombinedFragment.viewpointElementPredicate(), Operand.viewpointElementPredicate()});

    private RefreshOrderingHelper() {
    }

    public static <T> void updateIfNeeded(List<T> oldValue, List<T> newValue) {
        if (RefreshOrderingHelper.differentContents(oldValue, newValue)) {
            oldValue.clear();
            oldValue.addAll(newValue);
        }
    }

    public static <T> boolean differentContents(List<T> oldValue, List<T> newValue) {
        if (oldValue.size() != newValue.size()) {
            return true;
        }
        return !Iterables.elementsEqual(oldValue, newValue);
    }

    public static Iterable<? extends EventEnd> getAllEventEnds(SequenceDDiagram sequenceDiagram) {
        ArrayListMultimap semanticEndToSingleEventEnds = ArrayListMultimap.create();
        ArrayList result = Lists.newArrayList();
        RefreshOrderingHelper.addAllSingleEventEnds(sequenceDiagram, (Multimap<EObject, SingleEventEnd>)semanticEndToSingleEventEnds);
        RefreshOrderingHelper.minimizeEventEnds(result, (Multimap<EObject, SingleEventEnd>)semanticEndToSingleEventEnds);
        return result;
    }

    private static void minimizeEventEnds(List<EventEnd> result, Multimap<EObject, SingleEventEnd> semanticEndToSingleEventEnds) {
        for (EObject semanticEnd : semanticEndToSingleEventEnds.keySet()) {
            Collection sees = semanticEndToSingleEventEnds.get((Object)semanticEnd);
            if (sees.isEmpty()) continue;
            if (sees.size() == 1) {
                result.add((EventEnd)sees.iterator().next());
                continue;
            }
            CompoundEventEnd cee = OrderingFactory.eINSTANCE.createCompoundEventEnd();
            cee.setSemanticEnd(semanticEnd);
            if (sees.size() == 2 && RefreshOrderingHelper.countEvents(sees) == 1) {
                Iterables.addAll(cee.getEventEnds(), (Iterable)Iterables.filter((Iterable)sees, EventEndHelper.IS_START));
                Iterables.addAll(cee.getEventEnds(), (Iterable)Iterables.filter((Iterable)sees, (Predicate)Predicates.not(EventEndHelper.IS_START)));
            } else {
                Iterables.addAll(cee.getEventEnds(), (Iterable)Iterables.filter((Iterable)sees, (Predicate)Predicates.not(EventEndHelper.IS_START)));
                Iterables.addAll(cee.getEventEnds(), (Iterable)Iterables.filter((Iterable)sees, EventEndHelper.IS_START));
            }
            result.add(cee);
        }
    }

    private static int countEvents(Collection<SingleEventEnd> sees) {
        HashSet events = Sets.newHashSet();
        for (SingleEventEnd see : sees) {
            events.add(see.getSemanticEvent());
        }
        return events.size();
    }

    private static void addAllSingleEventEnds(SequenceDDiagram sequenceDiagram, Multimap<EObject, SingleEventEnd> semanticEndToSingleEventEnd) {
        for (DEdge edge : Iterables.filter((Iterable)sequenceDiagram.getEdges(), Message.viewpointElementPredicate())) {
            if (edge.getTarget() == null) continue;
            RefreshOrderingHelper.add(RefreshOrderingHelper.getStartingEnd((DDiagramElement)edge, DescriptionPackage.eINSTANCE.getMessageMapping_SendingEndFinderExpression()), semanticEndToSingleEventEnd);
            RefreshOrderingHelper.add(RefreshOrderingHelper.getFinishingEnd((DDiagramElement)edge, DescriptionPackage.eINSTANCE.getMessageMapping_ReceivingEndFinderExpression()), semanticEndToSingleEventEnd);
        }
        for (DDiagramElement node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)sequenceDiagram), DDiagramElement.class), DELIMITED_EVENT_PREDICATE)) {
            if (node.getTarget() == null) continue;
            SingleEventEnd startingEnd = RefreshOrderingHelper.getStartingEnd(node, DescriptionPackage.eINSTANCE.getDelimitedEventMapping_StartingEndFinderExpression());
            SingleEventEnd finishingEnd = RefreshOrderingHelper.getFinishingEnd(node, DescriptionPackage.eINSTANCE.getDelimitedEventMapping_FinishingEndFinderExpression());
            RefreshOrderingHelper.add(startingEnd, semanticEndToSingleEventEnd);
            RefreshOrderingHelper.add(finishingEnd, semanticEndToSingleEventEnd);
        }
    }

    private static void add(SingleEventEnd see, Multimap<EObject, SingleEventEnd> endToEventEnds) {
        if (see != null && see.getSemanticEnd() != null) {
            endToEventEnds.put((Object)see.getSemanticEnd(), (Object)see);
        }
    }

    public static SingleEventEnd createStartingEventEnd(EObject semanticEvent, EObject semanticEnd) {
        SingleEventEnd result = OrderingFactory.eINSTANCE.createSingleEventEnd();
        result.setStart(true);
        result.setSemanticEvent(semanticEvent);
        result.setSemanticEnd(semanticEnd);
        return result;
    }

    public static SingleEventEnd createFinishingEventEnd(EObject semanticEvent, EObject semanticEnd) {
        SingleEventEnd result = OrderingFactory.eINSTANCE.createSingleEventEnd();
        result.setStart(false);
        result.setSemanticEvent(semanticEvent);
        result.setSemanticEnd(semanticEnd);
        return result;
    }

    private static SingleEventEnd getStartingEnd(DDiagramElement dde, EAttribute startingEnd) {
        EObject semanticEvent = dde.getTarget();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)dde);
        RuntimeLoggerInterpreter loggerInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        EObject sendingEnd = loggerInterpreter.evaluateEObject(semanticEvent, (EObject)dde.getDiagramElementMapping(), (EStructuralFeature)startingEnd);
        return RefreshOrderingHelper.createStartingEventEnd(semanticEvent, sendingEnd);
    }

    private static SingleEventEnd getFinishingEnd(DDiagramElement dde, EAttribute finishingEnd) {
        EObject semanticEvent = dde.getTarget();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)dde);
        RuntimeLoggerInterpreter loggerInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        EObject receivingEnd = loggerInterpreter.evaluateEObject(semanticEvent, (EObject)dde.getDiagramElementMapping(), (EStructuralFeature)finishingEnd);
        return RefreshOrderingHelper.createFinishingEventEnd(semanticEvent, receivingEnd);
    }
}

