/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.symbols.provider;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.uml.diagram.symbols.Activator;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.svg.SVGDocument;

public class ActorShapeProvider
extends AbstractShapeProvider {
    public List<RenderedImage> getShapes(EObject view) {
        List<SVGDocument> documents;
        if (this.providesShapes(view) && (documents = this.getSVGDocument(view)) != null) {
            LinkedList<RenderedImage> result = new LinkedList<RenderedImage>();
            for (SVGDocument document : documents) {
                try {
                    result.add(this.renderSVGDocument(view, document));
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
            return result;
        }
        return null;
    }

    public boolean providesShapes(EObject view) {
        if (!(view instanceof View)) {
            return false;
        }
        EObject element = ((View)view).getElement();
        return element instanceof Actor || element instanceof TypedElement && ((TypedElement)element).getType() instanceof Actor;
    }

    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
        if (view == null || !(view instanceof View)) {
            return null;
        }
        ActorShapeProviderNotificationManager notificationManager = new ActorShapeProviderNotificationManager(diagramEventBroker, view, listener);
        return notificationManager;
    }

    public List<SVGDocument> getSVGDocument(EObject view) {
        if (this.providesShapes(view)) {
            URI uri = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.uml.diagram.common/icons/symbols/actor.svg", (boolean)true);
            String path = uri.toString();
            SVGDocument document = this.getSVGDocument(path);
            if (document == null) {
                return null;
            }
            return Arrays.asList(this.getSVGDocument(path));
        }
        return null;
    }

    public class ActorShapeProviderNotificationManager
    extends ProviderNotificationManager
    implements NotificationListener {
        public ActorShapeProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
            super(diagramEventBroker, view, listener);
        }

        protected void registerListeners() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            Object semanticElement = BusinessModelResolver.getInstance().getBusinessModel((Object)this.view);
            if (semanticElement instanceof Element) {
                this.diagramEventBroker.addNotificationListener((EObject)((Element)semanticElement), (NotificationListener)this);
            }
        }

        public void dispose() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            Object semanticElement = BusinessModelResolver.getInstance().getBusinessModel((Object)this.view);
            if (semanticElement instanceof Element) {
                this.diagramEventBroker.removeNotificationListener((EObject)((Element)semanticElement), (NotificationListener)this);
            }
            super.dispose();
        }

        public void notifyChanged(Notification notification) {
            if (this.listener == null) {
                return;
            }
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(notification.getFeature())) {
                this.listener.notifyChanged(notification);
            }
        }
    }
}

