/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;

public class CDOChangeSetSegment
implements CDOBranchPoint {
    private CDOBranchPoint branchPoint;
    private long endTime;

    public CDOChangeSetSegment(CDOBranch branch, long timeStamp, long endTime) {
        this.branchPoint = new CDOBranchPointImpl(branch, timeStamp);
        this.endTime = endTime;
    }

    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public CDOBranchPoint getEndPoint() {
        return this.getBranch().getPoint(this.endTime);
    }

    public boolean isOpenEnded() {
        return this.endTime == 0L;
    }

    public String toString() {
        return MessageFormat.format("Segment[{0}, {1}, {2}]", this.getBranch(), this.getTimeStamp(), this.endTime);
    }

    public static CDOChangeSetSegment[] createFrom(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        LinkedList<CDOChangeSetSegment> result = new LinkedList<CDOChangeSetSegment>();
        CDOBranch startBranch = startPoint.getBranch();
        CDOBranch endBranch = endPoint.getBranch();
        while (startBranch != endBranch) {
            CDOBranchPoint base = endBranch.getBase();
            result.addFirst(new CDOChangeSetSegment(endBranch, base.getTimeStamp(), endPoint.getTimeStamp()));
            endPoint = base;
            endBranch = base.getBranch();
        }
        result.addFirst(new CDOChangeSetSegment(startBranch, startPoint.getTimeStamp(), endPoint.getTimeStamp()));
        return result.toArray(new CDOChangeSetSegment[result.size()]);
    }
}

