/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.infra.services.markerlistener.providers.AbstractMarkerMonitor;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

public class WorkspaceMarkerMonitor
extends AbstractMarkerMonitor {
    private MarkerObserver fileObserver;

    public void initialize(ModelSet modelSet) {
        super.initialize(modelSet);
        this.fileObserver = new MarkerObserver(modelSet.getTransactionalEditingDomain());
        FileChangeManager.getInstance().addFileObserver((IFileObserver)this.fileObserver);
    }

    public void dispose() {
        FileChangeManager.getInstance().removeFileObserver((IFileObserver)this.fileObserver);
        this.fileObserver = null;
        super.dispose();
    }

    class MarkerObserver
    implements IFileObserver {
        private final TransactionalEditingDomain domain;

        public MarkerObserver(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            this.handleMarkerChanged(marker);
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            EObject eObjectFromMarker = MarkerListenerUtils.eObjectFromMarkerOrMap(null, attributes, (EditingDomain)this.domain);
            Resource resource = eObjectFromMarker != null ? eObjectFromMarker.eResource() : null;
            WorkspaceMarkerMonitor.this.fireMarkerRemoved(PapyrusMarkerAdapter.wrap(resource, marker, attributes));
        }

        public void handleMarkerChanged(IMarker marker) {
            EObject eObjectFromMarker = MarkerListenerUtils.eObjectFromMarkerOrMap(marker, null, (EditingDomain)this.domain);
            if (eObjectFromMarker != null) {
                Resource resource = eObjectFromMarker.eResource();
                WorkspaceMarkerMonitor.this.fireMarkerAdded(PapyrusMarkerAdapter.wrap(resource, marker));
            }
        }
    }
}

