/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IMarkerEventListener;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerMonitor;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerMonitorRegistry;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkersMonitorService
implements IService {
    private ServicesRegistry servicesRegistry;
    protected List<IMarkerEventListener> registeredMarkerEventListeners;
    private List<IMarkerMonitor> monitorExtensions;
    private final IMarkerEventListener relay = this.createRelayListener();

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void setServicesRegistry(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        this.registeredMarkerEventListeners = this.getRegisteredMarkerEventListeners();
        this.monitorExtensions = new MarkerMonitorRegistry().getMarkerMonitors();
        this.checkMarkers();
    }

    protected List<IMarkerEventListener> getRegisteredMarkerEventListeners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor("org.eclipse.papyrus.infra.services.markerlistener.markereventlistener");
        this.registeredMarkerEventListeners = new ArrayList<IMarkerEventListener>();
        try {
            int i = 0;
            while (i < config.length) {
                Object o = config[i].createExecutableExtension("class");
                try {
                    this.registeredMarkerEventListeners.add((IMarkerEventListener)this.servicesRegistry.getService(o.getClass()));
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.registeredMarkerEventListeners;
    }

    public void startService() throws ServiceException {
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.servicesRegistry);
        for (IMarkerMonitor next : this.monitorExtensions) {
            try {
                next.initialize(modelSet);
                next.addMarkerEventListener(this.relay);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in initialization of marker monitor.", (Throwable)e);
            }
        }
    }

    public void disposeService() throws ServiceException {
        for (IMarkerMonitor next : this.monitorExtensions) {
            try {
                next.removeMarkerEventListener(this.relay);
                next.dispose();
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in initialization of marker monitor.", (Throwable)e);
            }
        }
    }

    void checkMarkers() {
        try {
            EList resources = ServiceUtils.getInstance().getModelSet((Object)this.servicesRegistry).getResources();
            BasicEList resourcesCopy = new BasicEList((Collection)resources);
            for (Resource resource : resourcesCopy) {
                try {
                    Collection<? extends IPapyrusMarker> markers = this.getMarkers(resource, null, true);
                    for (IPapyrusMarker iPapyrusMarker : markers) {
                        EObject eObjectFromMarker = iPapyrusMarker.getEObject();
                        if (eObjectFromMarker == null || this.registeredMarkerEventListeners == null) continue;
                        for (IMarkerEventListener listener : this.registeredMarkerEventListeners) {
                            if (!listener.isNotifiedOnInitialMarkerCheck()) continue;
                            listener.notifyMarkerChange(eObjectFromMarker, iPapyrusMarker, 1);
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (ServiceException e1) {
            Activator.log.error(e1.getMessage(), (Throwable)e1);
        }
    }

    public Collection<? extends IPapyrusMarker> getMarkers(Resource resource, String type, boolean includeSubtypes) throws CoreException {
        LinkedList<? extends IPapyrusMarker> result = new LinkedList<IPapyrusMarker>();
        for (IMarkerProvider provider : MarkerListenerUtils.getMarkerProviders(resource)) {
            result.addAll(provider.getMarkers(resource, type, includeSubtypes));
        }
        return result;
    }

    private IMarkerEventListener createRelayListener() {
        return new IMarkerEventListener(){

            public void notifyMarkerChange(EObject eObjectOfMarker, IPapyrusMarker marker, int addedOrRemoved) {
                for (IMarkerEventListener next : MarkersMonitorService.this.registeredMarkerEventListeners) {
                    try {
                        next.notifyMarkerChange(eObjectOfMarker, marker, addedOrRemoved);
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in marker listener.", (Throwable)e);
                    }
                }
            }

            public void startService() {
            }

            public void init(ServicesRegistry servicesRegistry) {
            }

            public void disposeService() {
            }

            public boolean isNotifiedOnInitialMarkerCheck() {
                return false;
            }
        };
    }
}

