/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.papyrus.uml.tools.utils.TypedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;

public class OperationUtil {
    public static String getCustomLabel(Message e, int paramIndex, Parameter parameter, Collection<String> displayValue) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (displayValue.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        }
        if (displayValue.contains("parametersDirection")) {
            buffer.append(" ");
            buffer.append(parameter.getDirection().getLiteral());
        }
        boolean showEqualMark = false;
        if (displayValue.contains("parametersName")) {
            buffer.append(" ");
            String name = StringHelper.trimToEmpty((String)parameter.getName());
            if (name.trim().length() > 0) {
                showEqualMark = true;
            }
            buffer.append(name);
        }
        if (displayValue.contains("parametersType")) {
            if (parameter.getType() != null) {
                buffer.append(": " + StringHelper.trimToEmpty((String)parameter.getType().getName()));
            } else {
                buffer.append(": <Undefined>");
            }
            showEqualMark = true;
        }
        if (displayValue.contains("parametersMultiplicity")) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
            buffer.append(multiplicity);
        }
        if (displayValue.contains("derived")) {
            String value = OperationUtil.getValue(e, paramIndex, parameter);
            if (value != null) {
                if (showEqualMark) {
                    buffer.append(" = ");
                }
                buffer.append(value);
            }
        } else if (displayValue.contains("parametersDefault") && parameter.getDefault() != null) {
            if (showEqualMark) {
                buffer.append(" = ");
            }
            buffer.append(parameter.getDefault());
        }
        if (displayValue.contains("modifiers") && !(modifiers = ParameterUtil.getModifiersAsString((Parameter)parameter, (boolean)(multiLine = displayValue.contains("multiline")))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private static String getValue(Message e, int paramIndex, Parameter parameter) {
        try {
            EList arguments = e.getArguments();
            if (arguments.size() > paramIndex) {
                return ValueSpecificationUtil.getSpecificationValue((ValueSpecification)((ValueSpecification)arguments.get(paramIndex)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getCustomLabel(Message message, Operation operation, Collection<String> displayValue) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (displayValue.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)operation));
        }
        if (displayValue.contains("name")) {
            buffer.append(" ");
            buffer.append(StringHelper.trimToEmpty((String)operation.getName()));
        }
        buffer.append("(");
        buffer.append(OperationUtil.getParametersAsString(message, operation, displayValue));
        buffer.append(")");
        if (displayValue.contains("returnType") || displayValue.contains("type")) {
            buffer.append(OperationUtil.getReturnTypeAsString(operation, displayValue));
        }
        if (displayValue.contains("modifiers") && !(modifiers = OperationUtil.getModifiersAsString(operation)).equals("")) {
            buffer.append("{");
            buffer.append(modifiers);
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static String getModifiersAsString(Operation operation) {
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null) {
            if (!returnParameter.isUnique()) {
                buffer.append("nonunique");
                needsComma = true;
            }
            if (returnParameter.isOrdered()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                buffer.append("ordered");
                needsComma = true;
            }
        }
        if (operation.isQuery()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("query");
            needsComma = true;
        }
        for (Operation currentOperation : operation.getRedefinedOperations()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("redefines ");
            buffer.append(currentOperation.getName());
            needsComma = true;
        }
        for (Constraint constraint : operation.getOwnedRules()) {
            if (needsComma) {
                buffer.append(", ");
            }
            if (constraint.getSpecification() != null) {
                buffer.append(constraint.getSpecification().stringValue());
            }
            needsComma = true;
        }
        return buffer.toString();
    }

    private static String getReturnTypeAsString(Operation operation, Collection<String> displayValue) {
        boolean displayType = displayValue.contains("returnType") || displayValue.contains("type");
        boolean displayMultiplicity = displayValue.contains("returnMultiplicity") || displayValue.contains("multiplicity");
        StringBuffer label = new StringBuffer("");
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null && (displayType || displayMultiplicity)) {
            label.append(": ");
            if (displayType) {
                label.append(TypedElementUtil.getTypeAsString((TypedElement)returnParameter));
            }
            if (displayMultiplicity) {
                label.append(MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)returnParameter));
            }
        }
        return label.toString();
    }

    private static Parameter getReturnParameter(Operation operation) {
        Parameter returnParameter = null;
        Iterator it = operation.getOwnedParameters().iterator();
        while (returnParameter == null && it.hasNext()) {
            Parameter parameter = (Parameter)it.next();
            if (!parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            returnParameter = parameter;
        }
        return returnParameter;
    }

    private static String getParametersAsString(Message e, Operation operation, Collection<String> displayValue) {
        StringBuffer paramString = new StringBuffer();
        Iterator paramIterator = operation.getOwnedParameters().iterator();
        boolean firstParameter = true;
        int paramIndex = 0;
        while (paramIterator.hasNext()) {
            Parameter parameter = (Parameter)paramIterator.next();
            if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            String parameterString = OperationUtil.getCustomLabel(e, paramIndex, parameter, displayValue).trim();
            ++paramIndex;
            if (parameterString.equals("")) continue;
            if (!firstParameter) {
                paramString.append(", ");
            }
            paramString.append(parameterString);
            firstParameter = false;
        }
        return paramString.toString();
    }
}

