/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.service;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class DurationCreationTool
extends AspectUnspecifiedTypeCreationTool {
    private static Cursor CURSOR_TARGET_MENU = new Cursor((Device)Display.getDefault(), 21);
    protected static final int STATE_CONNECTION_STARTED = 64;
    private static final int FLAG_SOURCE_FEEDBACK = 64;
    protected static final int MAX_STATE = 64;
    protected static final int MAX_FLAG = 64;
    private EditPart connectionSource;
    private EditPartViewer viewer;
    private EditPartListener.Stub deactivationListener = new EditPartListener.Stub(){

        public void partDeactivated(EditPart editpart) {
            DurationCreationTool.this.handleSourceDeactivated();
        }
    };

    public DurationCreationTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.setDefaultCursor(SharedCursors.CURSOR_PLUG);
        this.setDisabledCursor(SharedCursors.NO);
    }

    protected boolean handleDrag() {
        if (this.isInState(64)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(32)) {
            return this.handleMove();
        }
        if (this.isInState(4)) {
            this.updateTargetRequest();
            this.setCurrentCommand(this.getCommand());
            this.showTargetFeedback();
            return true;
        }
        return false;
    }

    protected String getDebugNameForState(int s) {
        if (s == 64 || s == 32) {
            return "Connection Started";
        }
        return super.getDebugNameForState(s);
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
    }

    protected void setTargetRequest(Request req) {
        if (req == null && this.connectionSource != null) {
            return;
        }
        super.setTargetRequest(req);
    }

    protected void handleSourceDeactivated() {
        this.setState(8);
        this.handleInvalidInput();
        this.handleFinished();
    }

    protected boolean handleCreateConnection() {
        this.eraseSourceFeedback();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseSourceFeedback();
        this.setConnectionSource(null);
        return super.handleInvalidInput();
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.stateTransition(64, 0x40000000)) {
            return this.handleCreateConnection();
        }
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.setConnectionSource(this.getTargetEditPart());
            if (this.getTargetEditPart() instanceof InteractionInteractionCompartmentEditPart) {
                return super.handleButtonDown(button);
            }
            Command command = this.getCommand();
            Request request = this.getTargetRequest();
            if (command != null) {
                this.setState(64);
                this.setCurrentCommand(command);
                this.viewer = this.getCurrentViewer();
                Map extendedData = request.getExtendedData();
                extendedData.put("Nearest occurrence specification (end)", null);
                extendedData.put("Nearest occurrence specification location (end)", null);
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    protected boolean handleMove() {
        if (this.isInState(64) && this.viewer != this.getCurrentViewer()) {
            return false;
        }
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        if (this.isInState(64)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected void setConnectionSource(EditPart source) {
        if (this.connectionSource != null) {
            this.connectionSource.removeEditPartListener((EditPartListener)this.deactivationListener);
        }
        this.connectionSource = source;
        if (this.connectionSource != null) {
            this.connectionSource.addEditPartListener((EditPartListener)this.deactivationListener);
        }
    }

    protected boolean isShowingSourceFeedback() {
        return this.getFlag(64);
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingSourceFeedback()) {
            return;
        }
        this.setFlag(64, false);
        if (this.connectionSource != null) {
            this.connectionSource.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        if (this.isInState(65)) {
            this.performViewerMouseWheel(event, viewer);
        }
    }

    protected Request getSourceRequest() {
        return this.getTargetRequest();
    }

    protected void showSourceFeedback() {
        if (this.connectionSource != null) {
            this.connectionSource.showSourceFeedback(this.getSourceRequest());
        }
        this.setFlag(64, true);
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(64)) {
            this.handleCreateConnection();
        }
        if (this.stateTransition(6, 0x40000000)) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.performCreation(button);
        }
        this.setState(0x40000000);
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleCommandStackChanged() {
        if (!this.isInState(1)) {
            if (this.getCurrentInput().isMouseButtonDown(1)) {
                this.setState(8);
            } else {
                this.setState(1);
            }
            this.handleInvalidInput();
            return true;
        }
        return false;
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        this.setConnectionSource(null);
        super.deactivate();
        this.setState(0x40000000);
        this.viewer = null;
    }

    protected Cursor calculateCursor() {
        EditPart ep;
        Command command;
        if (this.isInState(64)) {
            Control control;
            if (this.getAutoexposeHelper() != null) {
                return SharedCursors.HAND;
            }
            if (this.getCurrentViewer() != null && (control = this.getCurrentViewer().getControl()) instanceof FigureCanvas) {
                Viewport viewport = ((FigureCanvas)control).getViewport();
                Rectangle rect = Rectangle.SINGLETON;
                viewport.getClientArea(rect);
                viewport.translateToParent((Translatable)rect);
                viewport.translateToAbsolute((Translatable)rect);
                if (!rect.contains(this.getLocation())) {
                    return this.getDisabledCursor();
                }
            }
        }
        if ((command = this.getCurrentCommand()) != null && command.canExecute() && ((ep = this.getTargetEditPart()) instanceof DiagramEditPart || ep instanceof CompartmentEditPart)) {
            return CURSOR_TARGET_MENU;
        }
        return super.calculateCursor();
    }

    protected Command getCommand() {
        if (!this.antiScroll) {
            EditPart targetPart = this.getTargetEditPart();
            if (targetPart == null) {
                return null;
            }
            Request req = this.getTargetRequest();
            if (targetPart instanceof InteractionInteractionCompartmentEditPart || targetPart instanceof ConnectionNodeEditPart) {
                return targetPart.getCommand(req);
            }
            if ((targetPart = this.getInteractionEditPart(targetPart)) != null) {
                return targetPart.getCommand(req);
            }
        }
        return null;
    }

    private EditPart getInteractionEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof InteractionInteractionCompartmentEditPart) {
            return editPart;
        }
        return this.getInteractionEditPart(editPart.getParent());
    }
}

