/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.menu.actions.SizeAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SizeHandler;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class CustomSizeHandler
extends SizeHandler {
    protected Command getCommand() {
        super.getCommand();
        CustomSizeAction action = new CustomSizeAction(this.parameter, this.getSelectedElements());
        Command cmd = action.getCommand();
        return cmd == null ? UnexecutableCommand.INSTANCE : cmd;
    }

    public class CustomSizeAction
    extends SizeAction {
        public CustomSizeAction(String parameter, List<IGraphicalEditPart> selectedElements) {
            super(parameter, selectedElements);
        }

        protected Command getHeightCommand() {
            if (this.selectedElements.size() <= 1) {
                return UnexecutableCommand.INSTANCE;
            }
            CompoundCommand doResizeCmd = new CompoundCommand();
            Iterator iter = this.selectedElements.iterator();
            Dimension primarySize = this.getPrimarySize();
            while (iter.hasNext()) {
                IGraphicalEditPart toResize = (IGraphicalEditPart)iter.next();
                View resizeView = (View)toResize.getModel();
                Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
                Dimension delta = new Dimension(0, primarySize.height - previousSize.height);
                if (this.isLifelines()) {
                    Rectangle constraint = this.getLifelineConstraint();
                    Rectangle previousRect = SequenceUtil.getAbsoluteBounds(toResize);
                    delta.height = constraint.bottom() - previousRect.bottom();
                }
                ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
                bRequest.setResizeDirection(4);
                bRequest.setSizeDelta(delta);
                bRequest.setType((Object)"resize");
                Command resizeCommand = toResize.getCommand((Request)bRequest);
                doResizeCmd.add(resizeCommand);
            }
            return doResizeCmd.unwrap();
        }

        protected Dimension getPrimarySize() {
            if (this.selectedElements.isEmpty()) {
                return null;
            }
            int last = this.selectedElements.size() - 1;
            IGraphicalEditPart primary = (IGraphicalEditPart)this.selectedElements.get(last);
            return this.getPrimarySize(primary);
        }

        private boolean isLifelines() {
            if (this.selectedElements.isEmpty()) {
                return true;
            }
            boolean isLifelines = true;
            int i = 0;
            while (i < this.selectedElements.size()) {
                isLifelines &= this.selectedElements.get(i) instanceof LifelineEditPart;
                ++i;
            }
            return isLifelines;
        }

        protected Rectangle getLifelineConstraint() {
            Rectangle constraint = new Rectangle();
            int i = 0;
            while (i < this.selectedElements.size()) {
                LifelineEditPart lifelineEditPart = (LifelineEditPart)((Object)this.selectedElements.get(i));
                Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)lifelineEditPart);
                constraint.union(rect);
                ++i;
            }
            return constraint;
        }

        protected Dimension getPrimarySize(IGraphicalEditPart primaryChild) {
            View primaryView = (View)primaryChild.getModel();
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension primarySize = width == -1 || height == -1 ? primaryChild.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
            return primarySize;
        }

        protected Command getWidthCommand() {
            if (this.selectedElements.size() <= 1) {
                return UnexecutableCommand.INSTANCE;
            }
            CompoundCommand doResizeCmd = new CompoundCommand();
            Iterator iter = this.selectedElements.iterator();
            Dimension primarySize = this.getPrimarySize();
            while (iter.hasNext()) {
                IGraphicalEditPart toResize = (IGraphicalEditPart)iter.next();
                View resizeView = (View)toResize.getModel();
                Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
                Dimension delta = new Dimension(primarySize.width - previousSize.width, 0);
                ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
                bRequest.setResizeDirection(16);
                bRequest.setSizeDelta(delta);
                bRequest.setType((Object)"resize");
                Command resizeCommand = toResize.getCommand((Request)bRequest);
                doResizeCmd.add(resizeCommand);
            }
            return doResizeCmd.unwrap();
        }

        protected Command getBothCommand() {
            if (this.selectedElements.size() <= 1) {
                return UnexecutableCommand.INSTANCE;
            }
            CompoundCommand doResizeCmd = new CompoundCommand();
            Iterator iter = this.selectedElements.iterator();
            int last = this.selectedElements.size() - 1;
            IGraphicalEditPart primary = (IGraphicalEditPart)this.selectedElements.get(last);
            View primaryView = (View)primary.getModel();
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
            while (iter.hasNext()) {
                IGraphicalEditPart toResize = (IGraphicalEditPart)iter.next();
                View resizeView = (View)toResize.getModel();
                Integer previousWidth = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer previousHeight = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                Dimension previousSize = previousWidth == -1 || previousHeight == -1 ? toResize.getFigure().getSize().getCopy() : new Dimension(previousWidth.intValue(), previousHeight.intValue());
                Dimension delta = new Dimension(primarySize.width - previousSize.width, primarySize.height - previousSize.height);
                if (this.isLifelines()) {
                    Rectangle constraint = this.getLifelineConstraint();
                    Rectangle previousRect = SequenceUtil.getAbsoluteBounds(toResize);
                    delta.height = constraint.bottom() - previousRect.bottom();
                }
                ChangeBoundsRequest bRequest = new ChangeBoundsRequest();
                bRequest.setResizeDirection(20);
                bRequest.setSizeDelta(delta);
                bRequest.setType((Object)"resize");
                Command resizeCommand = toResize.getCommand((Request)bRequest);
                doResizeCmd.add(resizeCommand);
            }
            return doResizeCmd.unwrap();
        }
    }
}

