/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.DuplicateNamedElementCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.InteractionCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;

public class PackageItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public PackageItemSemanticEditPolicy() {
        super(UMLElementTypes.Package_1000);
    }

    @Override
    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return super.getCreateCommand(req);
        }
        IElementType baseElementType = requestElementType;
        boolean isExtendedType = false;
        if (requestElementType instanceof IExtendedHintedElementType) {
            baseElementType = ElementTypeUtils.getClosestDiagramType((IElementType)requestElementType);
            if (baseElementType != null) {
                isExtendedType = true;
            } else {
                baseElementType = ElementTypeUtils.findClosestNonExtendedElementType((IExtendedHintedElementType)((IExtendedHintedElementType)requestElementType));
                isExtendedType = true;
            }
        }
        if (UMLElementTypes.Interaction_2001 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new InteractionCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        return super.getCreateCommand(req);
    }

    @Override
    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Diagram currentDiagram = null;
        if (this.getHost() instanceof IGraphicalEditPart) {
            currentDiagram = ((IGraphicalEditPart)this.getHost()).getNotationView().getDiagram();
        }
        return this.getGEFWrapper((ICommand)new DuplicateAnythingCommand(editingDomain, req, currentDiagram));
    }

    private static class DuplicateAnythingCommand
    extends DuplicateNamedElementCommand {
        private Diagram diagram;

        public DuplicateAnythingCommand(TransactionalEditingDomain editingDomain, DuplicateElementsRequest req, Diagram currentDiagram) {
            super(editingDomain, req.getLabel(), req.getElementsToBeDuplicated(), req.getAllDuplicatedElementsMap(), currentDiagram);
            this.diagram = currentDiagram;
        }
    }
}

