/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomLifelineNameEditPart
extends LifelineNameEditPart {
    public CustomLifelineNameEditPart(View view) {
        super(view);
    }

    @Override
    public void setLabel(WrappingLabel figure) {
        figure.setTextWrap(false);
        super.setLabel(figure);
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    @Override
    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        Lifeline lifeline = (Lifeline)this.resolveSemanticElement();
        if (lifeline.getRepresents() != null || lifeline.getDecomposedAs() != null) {
            this.directEditionMode = 8;
        }
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                final ExtendedDirectEditionDialog dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        CustomLifelineNameEditPart.this.configuration.postEditAction((Object)CustomLifelineNameEditPart.this.resolveSemanticElement(), dialog.getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            if (CustomLifelineNameEditPart.this.isActive() && CustomLifelineNameEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    CustomLifelineNameEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && CustomLifelineNameEditPart.this.getEditText().equals(CustomLifelineNameEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    CustomLifelineNameEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    CustomLifelineNameEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy maskLabelPolicy = this.getParent().getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
        }
        this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        if (this.getParent() instanceof CustomLifelineEditPart) {
            Lifeline lifeline;
            Object feature = event.getFeature();
            Object notifier = event.getNotifier();
            if (notifier.equals((lifeline = (Lifeline)this.resolveSemanticElement()).getRepresents()) || UMLPackage.Literals.NAMED_ELEMENT__NAME.equals(feature) || UMLPackage.Literals.LIFELINE__REPRESENTS.equals(feature) || UMLPackage.Literals.LIFELINE__DECOMPOSED_AS.equals(feature) || UMLPackage.Literals.LIFELINE__SELECTOR.equals(feature) || event.getNotifier() instanceof Bounds) {
                ((CustomLifelineEditPart)this.getParent()).updateLifelinePosition();
            }
            if (notifier instanceof EAnnotation && ((EAnnotation)notifier).getSource().equals("CustomAppearance_Annotation")) {
                ((CustomLifelineEditPart)this.getParent()).updateLifelinePosition();
            }
        }
        super.handleNotificationEvent(event);
    }

    @Override
    protected Image getLabelIcon() {
        return ElementIconUtil.getLabelIcon((GraphicalEditPart)this);
    }
}

