/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ModelingProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = "org.eclipse.sirius.ui.modelingproject.wizard";
    private WizardNewProjectCreationPage newProjectPage;

    public ModelingProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        boolean finished = true;
        try {
            final String projectName = this.newProjectPage.getProjectName();
            final IPath locationPath = this.newProjectPage.getLocationPath();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ModelingProjectManager.INSTANCE.createNewModelingProject(projectName, locationPath, true, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 4, e.getMessage(), (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
            finished = false;
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 4, e.getMessage(), (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
            finished = false;
        }
        return finished;
    }

    public void init(IWorkbench wkbch, IStructuredSelection sel) {
        this.setWindowTitle("New Modeling Project");
        this.setDefaultPageImageDescriptor(SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/wizban/banner_modeling_project.gif"));
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void addPages() {
        this.newProjectPage = new WizardNewProjectCreationPage(SiriusEditPlugin.getPlugin().getString("_UI_ModelingProjectWizard_label"));
        this.newProjectPage.setInitialProjectName("");
        this.newProjectPage.setTitle(SiriusEditPlugin.getPlugin().getString("_UI_ModelingProjectWizard_label"));
        this.newProjectPage.setDescription(SiriusEditPlugin.getPlugin().getString("_UI_ModelingProjectWizard_description"));
        this.addPage((IWizardPage)this.newProjectPage);
        super.addPages();
    }
}

