/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IFeatureProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureProjectEditor
extends ProjectEditor
implements IFeatureProjectEditor {
    private Document fragmentXML;
    private IFile fragmentFile;
    private Element fragmentRoot;
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";

    public FeatureProjectEditor(IProject project) throws ParserConfigurationException, SAXException, IOException, CoreException {
        super(project);
    }

    @Override
    public void init() {
        this.fragmentFile = this.getPlugin();
        if (this.fragmentFile != null && this.fragmentFile.exists()) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                this.fragmentXML = documentBuilder.parse(this.fragmentFile.getLocation().toOSString());
                this.fragmentRoot = this.fragmentXML.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public void createFiles(Set<String> files) {
    }

    @Override
    public boolean exists() {
        IFile plugin = this.getProject().getFile("feature.xml");
        return plugin.exists() && super.exists();
    }

    public void setAttribute(Element element, String attributeName, String attributeValue) {
        element.setAttribute(attributeName, attributeValue);
    }

    private IFile getPlugin() {
        IFile plugin = this.getProject().getFile("feature.xml");
        if (plugin.exists()) {
            return plugin;
        }
        return null;
    }

    @Override
    public void save() {
        if (this.exists()) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(this.fragmentXML);
                transformer.transform(source, result);
                InputStream inputStream = this.getInputStream(result.getWriter().toString());
                this.fragmentFile.setContents(inputStream, true, true, null);
            }
            catch (TransformerException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        super.save();
    }

    @Override
    public Set<String> getMissingNature() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> getMissingFiles() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        return Collections.emptySet();
    }

    @Override
    public Document getDocument() {
        return this.fragmentXML;
    }

    @Override
    public void setLabel(String label) {
        this.fragmentRoot.setAttribute("label", label);
    }

    @Override
    public void setVersion(String version) {
        this.fragmentRoot.setAttribute("version", version);
    }

    @Override
    public void setProviderName(String providerName) {
        this.fragmentRoot.setAttribute("provider-name", providerName);
    }

    public void setDescription(String copyrightURL, String copyrightDesc) {
        if (this.exists()) {
            Element extension = this.getNode(DESCRIPTION);
            if (extension == null) {
                extension = this.fragmentXML.createElement(DESCRIPTION);
                extension.setAttribute(URL, copyrightURL);
                extension.setTextContent(copyrightDesc);
                this.fragmentRoot.appendChild(extension);
            } else {
                extension.setAttribute(URL, String.valueOf(copyrightURL) + "erase");
                extension.setTextContent(String.valueOf(copyrightDesc) + "erase");
            }
        }
    }

    @Override
    public void setLicense(String licenseURL, String licenseDesc) {
        this.setURLNode("license", licenseURL, licenseDesc);
    }

    protected void setURLNode(String nodeName, String url, String description) {
        if (this.exists()) {
            Element extension = this.getNode(nodeName);
            if (extension == null) {
                extension = this.fragmentXML.createElement(nodeName);
                if (url != null) {
                    extension.setAttribute(URL, url);
                }
                extension.setTextContent(description);
                this.fragmentRoot.appendChild(extension);
            } else {
                if (url != null) {
                    extension.setAttribute(URL, url);
                }
                extension.setTextContent(description);
            }
        }
    }

    @Override
    public String getLabel() {
        return this.fragmentRoot.getAttribute("label");
    }

    @Override
    public String getVersion() {
        return this.fragmentRoot.getAttribute("version");
    }

    @Override
    public String getProviderName() {
        return this.fragmentRoot.getAttribute("provider-name");
    }

    @Override
    public void setCopyright(String copyrightURL, String copyrightDesc) {
        this.setURLNode("copyright", copyrightURL, copyrightDesc);
    }

    @Override
    public String getCopyrightURL() {
        Element copyrightNode = this.getNode("copyright");
        if (copyrightNode != null) {
            String value = copyrightNode.getAttribute(URL);
            if (value != null && value.startsWith("%")) {
                IFile file = this.getProject().getFile("feature.properties");
                Properties prop = new Properties();
                try {
                    prop.load(file.getContents());
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                Object val = prop.get(URL);
                if (val != null) {
                    return (String)val;
                }
            }
            return copyrightNode.getAttribute(URL);
        }
        return null;
    }

    @Override
    public String getCopyrightText() {
        Element copyrightNode = this.getNode("copyright");
        if (copyrightNode != null) {
            return copyrightNode.getTextContent();
        }
        return null;
    }

    @Override
    public String getLicense() {
        return null;
    }

    public Element getNode(String nodeName) {
        if (this.exists()) {
            NodeList nodes = this.fragmentRoot.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                String name;
                Node item = nodes.item(i);
                if (item instanceof NodeList && (name = item.getNodeName()).equals(nodeName) && item instanceof Element) {
                    return (Element)item;
                }
                ++i;
            }
        }
        return null;
    }
}

