/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IProjectEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectEditor
extends AbstractFileEditor
implements IProjectEditor {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final IProjectDescription description = this.getProject().getDescription();

    public AbstractProjectEditor(IProject project) throws CoreException {
        super(project);
    }

    @Override
    public boolean exists() {
        return super.exists() && this.getMissingNature().size() == 0 && this.getMissingBuildCommand().size() == 0;
    }

    @Override
    public void create() {
        this.createFiles(this.getMissingFiles());
        this.addNatures(this.getMissingNature());
        this.addBuildCommands(this.getMissingBuildCommand());
        this.init();
    }

    @Override
    public boolean hasNature(String nature) {
        LinkedList<String> natures = new LinkedList<String>(Arrays.asList(this.description.getNatureIds()));
        return natures.contains(nature);
    }

    @Override
    public Set<String> getMissingNature() {
        return new HashSet<String>();
    }

    public void addNatures(Set<String> natures) {
        LinkedList<String> existingNatures = new LinkedList<String>(Arrays.asList(this.description.getNatureIds()));
        for (String nature : natures) {
            if (existingNatures.contains(nature)) continue;
            existingNatures.add(nature);
        }
        this.description.setNatureIds(existingNatures.toArray(new String[existingNatures.size()]));
    }

    @Override
    public boolean hasBuildCommand(String command) {
        ICommand[] buildSpec = this.description.getBuildSpec();
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals(command)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void addBuildCommands(Set<String> commands) {
        ICommand[] buildSpec = this.description.getBuildSpec();
        ArrayList<Object> buildSpecList = new ArrayList<Object>();
        buildSpecList.addAll(Arrays.asList(buildSpec));
        for (String name : commands) {
            if (this.hasBuildCommand(name)) continue;
            BuildCommand cmd = new BuildCommand();
            cmd.setBuilderName(name);
            buildSpecList.add(cmd);
        }
        this.description.setBuildSpec(buildSpecList.toArray(new ICommand[buildSpecList.size()]));
    }

    @Override
    public void save() {
        if (this.description != null) {
            try {
                this.getProject().setDescription(this.description, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        return new HashSet<String>();
    }
}

