/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.security;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider2;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdateProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.security.CredentialsDialog;
import org.eclipse.net4j.util.ui.security.CredentialsResetDialog;
import org.eclipse.net4j.util.ui.security.CredentialsUpdateDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class InteractiveCredentialsProvider
implements IPasswordCredentialsProvider2,
IPasswordCredentialsUpdateProvider {
    public boolean isInteractive() {
        return true;
    }

    public IPasswordCredentials getCredentials() {
        return this.getCredentials(null);
    }

    public IPasswordCredentials getCredentials(final String realm) {
        final IPasswordCredentials[] credentials = new IPasswordCredentials[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell;
                try {
                    IWorkbenchWindow window = UIUtil.getActiveWorkbenchWindow();
                    shell = window.getShell();
                }
                catch (Exception ex) {
                    shell = new Shell(display);
                }
                CredentialsDialog dialog = new CredentialsDialog(shell, realm);
                if (dialog.open() == 0) {
                    credentials[0] = dialog.getCredentials();
                }
            }
        });
        return credentials[0];
    }

    public IPasswordCredentialsUpdate getCredentialsUpdate(String userID, CredentialsUpdateOperation operation) {
        return this.getCredentialsUpdate(null, userID, operation);
    }

    public IPasswordCredentialsUpdate getCredentialsUpdate(final String realm, final String userID, final CredentialsUpdateOperation operation) {
        final IPasswordCredentialsUpdate[] update = new IPasswordCredentialsUpdate[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                CredentialsDialog dialog;
                Shell shell;
                try {
                    IWorkbenchWindow window = UIUtil.getActiveWorkbenchWindow();
                    shell = window.getShell();
                }
                catch (Exception ex) {
                    shell = new Shell(display);
                }
                if (operation == CredentialsUpdateOperation.CHANGE_PASSWORD) {
                    dialog = new CredentialsUpdateDialog(shell, realm, userID);
                    if (dialog.open() == 0) {
                        update[0] = ((CredentialsUpdateDialog)dialog).getCredentials();
                    }
                } else {
                    dialog = new CredentialsResetDialog(shell, realm, userID);
                    if (dialog.open() == 0) {
                        update[0] = ((CredentialsResetDialog)dialog).getCredentials();
                        final String newPassword = new String(update[0].getNewPassword());
                        MessageDialog msg = new MessageDialog(shell, Messages.getString("InteractiveCredentialsProvider.0"), null, MessageFormat.format(Messages.getString("InteractiveCredentialsProvider.1"), userID, newPassword), 2, new String[]{Messages.getString("InteractiveCredentialsProvider.2"), IDialogConstants.OK_LABEL}, 0){

                            protected void buttonPressed(int buttonId) {
                                if (buttonId == 0) {
                                    this.copyToClipboard();
                                } else {
                                    super.buttonPressed(0);
                                }
                            }

                            private void copyToClipboard() {
                                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                                try {
                                    clipboard.setContents(new Object[]{newPassword}, new Transfer[]{TextTransfer.getInstance()});
                                }
                                finally {
                                    clipboard.dispose();
                                }
                            }
                        };
                        msg.open();
                    }
                }
            }
        });
        return update[0];
    }
}

