/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class DependencyReorientCommand
extends EditElementCommand {
    protected final int reorientDirection;
    protected final EObject oldEnd;
    protected final EObject newEnd;

    public DependencyReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Dependency)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof NamedElement) || !(this.newEnd instanceof NamedElement)) {
            return false;
        }
        return this.getLink().eContainer() instanceof Package;
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof NamedElement) || !(this.newEnd instanceof NamedElement)) {
            return false;
        }
        return this.getLink().eContainer() instanceof Package;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getClients().remove((Object)this.getOldSource());
        this.getLink().getClients().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getSuppliers().remove((Object)this.getOldTarget());
        this.getLink().getSuppliers().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Dependency getLink() {
        return (Dependency)this.getElementToEdit();
    }

    protected NamedElement getOldSource() {
        return (NamedElement)this.oldEnd;
    }

    protected NamedElement getNewSource() {
        return (NamedElement)this.newEnd;
    }

    protected NamedElement getOldTarget() {
        return (NamedElement)this.oldEnd;
    }

    protected NamedElement getNewTarget() {
        return (NamedElement)this.newEnd;
    }
}

