/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.ui.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.scoping.VSLScopeProvider;
import org.eclipse.papyrus.marte.vsl.scoping.visitors.ScopingVisitors;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.AbstractVSLProposalProvider;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.VSLProposalUtils;
import org.eclipse.papyrus.marte.vsl.vSL.AdditiveExpression;
import org.eclipse.papyrus.marte.vsl.vSL.AndOrXorExpression;
import org.eclipse.papyrus.marte.vsl.vSL.CollectionOrTuple;
import org.eclipse.papyrus.marte.vsl.vSL.ConditionalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsName;
import org.eclipse.papyrus.marte.vsl.vSL.EqualityExpression;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsName;
import org.eclipse.papyrus.marte.vsl.vSL.ListOfValueNamePairs;
import org.eclipse.papyrus.marte.vsl.vSL.MultiplicativeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.NameOrChoiceOrBehaviorCall;
import org.eclipse.papyrus.marte.vsl.vSL.OperationCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PrimaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.QualifiedName;
import org.eclipse.papyrus.marte.vsl.vSL.RelationalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Tuple;
import org.eclipse.papyrus.marte.vsl.vSL.UnaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.VSLPackage;
import org.eclipse.papyrus.marte.vsl.vSL.ValueNamePair;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.papyrus.uml.xtext.integration.CompletionProposalUtils;
import org.eclipse.papyrus.uml.xtext.integration.CustomCompletionProposal;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class VSLProposalProvider
extends AbstractVSLProposalProvider {
    @Override
    public void completeExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeExpression_Exp(model, assignment, context, acceptor);
    }

    @Override
    public void completeAndOrXorExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof AndOrXorExpression) {
            AndOrXorExpression exp = (AndOrXorExpression)model;
            EList nestedExpressions = exp.getExp();
            if (nestedExpressions.size() >= 2) {
                VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkEqualityExpression((EqualityExpression)nestedExpressions.get(nestedExpressions.size() - 2));
                Classifier specifiedType = (Classifier)validationResult.inferedType();
                String operator = (String)exp.getOp().get(nestedExpressions.size() - 2);
                if (VSLJavaValidator.binaryOpTypeBinding.get(operator) != null && ((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType) != null) {
                    for (Type possibleType : (List)((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType)) {
                        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)possibleType);
                        for (String s : allProposals.keySet()) {
                            String displayString;
                            String completionString;
                            if (!s.startsWith(context.getPrefix())) continue;
                            CustomCompletionProposal completionProposal = null;
                            if (allProposals.get(s) == null) {
                                completionString = s.substring(context.getPrefix().length());
                                displayString = s;
                                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                            } else {
                                if (!s.contains("|")) {
                                    completionString = s;
                                    displayString = s;
                                } else {
                                    completionString = s.substring(0, s.indexOf("|"));
                                    displayString = s.substring(s.indexOf("|") + 1);
                                }
                                completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                            }
                            acceptor.accept((ICompletionProposal)completionProposal);
                        }
                    }
                }
            }
        } else {
            super.completeAndOrXorExpression_Exp(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeAndOrXorExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeAndOrXorExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeEqualityExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof EqualityExpression) {
            EqualityExpression exp = (EqualityExpression)model;
            EList nestedExpressions = exp.getExp();
            if (nestedExpressions.size() >= 2) {
                VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkRelationalExpression((RelationalExpression)nestedExpressions.get(nestedExpressions.size() - 2));
                Classifier specifiedType = (Classifier)validationResult.inferedType();
                String operator = (String)exp.getOp().get(nestedExpressions.size() - 2);
                if (VSLJavaValidator.binaryOpTypeBinding.get(operator) != null && ((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType) != null) {
                    for (Type possibleType : (List)((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType)) {
                        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)possibleType);
                        for (String s : allProposals.keySet()) {
                            String displayString;
                            String completionString;
                            if (!s.startsWith(context.getPrefix())) continue;
                            CustomCompletionProposal completionProposal = null;
                            if (allProposals.get(s) == null) {
                                completionString = s.substring(context.getPrefix().length());
                                displayString = s;
                                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                            } else {
                                if (!s.contains("|")) {
                                    completionString = s;
                                    displayString = s;
                                } else {
                                    completionString = s.substring(0, s.indexOf("|"));
                                    displayString = s.substring(s.indexOf("|") + 1);
                                }
                                completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                            }
                            acceptor.accept((ICompletionProposal)completionProposal);
                        }
                    }
                }
            }
        } else {
            super.completeEqualityExpression_Exp(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeEqualityExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeEqualityExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeRelationalExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof RelationalExpression) {
            RelationalExpression exp = (RelationalExpression)model;
            EList nestedExpressions = exp.getExp();
            if (nestedExpressions.size() >= 2) {
                VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkConditionalExpression((ConditionalExpression)nestedExpressions.get(nestedExpressions.size() - 2));
                Classifier specifiedType = (Classifier)validationResult.inferedType();
                String operator = (String)exp.getOp().get(nestedExpressions.size() - 2);
                if (VSLJavaValidator.binaryOpTypeBinding.get(operator) != null && ((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType) != null) {
                    for (Type possibleType : (List)((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType)) {
                        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)possibleType);
                        for (String s : allProposals.keySet()) {
                            String displayString;
                            String completionString;
                            if (!s.startsWith(context.getPrefix())) continue;
                            CustomCompletionProposal completionProposal = null;
                            if (allProposals.get(s) == null) {
                                completionString = s.substring(context.getPrefix().length());
                                displayString = s;
                                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                            } else {
                                if (!s.contains("|")) {
                                    completionString = s;
                                    displayString = s;
                                } else {
                                    completionString = s.substring(0, s.indexOf("|"));
                                    displayString = s.substring(s.indexOf("|") + 1);
                                }
                                completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                            }
                            acceptor.accept((ICompletionProposal)completionProposal);
                        }
                    }
                }
            }
        } else {
            super.completeRelationalExpression_Exp(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeRelationalExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRelationalExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeConditionalExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeConditionalExpression_Exp(model, assignment, context, acceptor);
    }

    @Override
    public void completeConditionalExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeConditionalExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeAdditiveExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof AdditiveExpression) {
            AdditiveExpression exp = (AdditiveExpression)model;
            EList nestedExpressions = exp.getExp();
            if (nestedExpressions.size() >= 2) {
                VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkMultiplicativeExpression((MultiplicativeExpression)nestedExpressions.get(nestedExpressions.size() - 2));
                Classifier specifiedType = (Classifier)validationResult.inferedType();
                String operator = (String)exp.getOp().get(nestedExpressions.size() - 2);
                if (VSLJavaValidator.binaryOpTypeBinding.get(operator) != null && ((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType) != null) {
                    for (Type possibleType : (List)((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType)) {
                        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)possibleType);
                        for (String s : allProposals.keySet()) {
                            String displayString;
                            String completionString;
                            if (!s.startsWith(context.getPrefix())) continue;
                            CustomCompletionProposal completionProposal = null;
                            if (allProposals.get(s) == null) {
                                completionString = s.substring(context.getPrefix().length());
                                displayString = s;
                                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                            } else {
                                if (!s.contains("|")) {
                                    completionString = s;
                                    displayString = s;
                                } else {
                                    completionString = s.substring(0, s.indexOf("|"));
                                    displayString = s.substring(s.indexOf("|") + 1);
                                }
                                completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                            }
                            acceptor.accept((ICompletionProposal)completionProposal);
                        }
                    }
                }
            }
        } else {
            super.completeAdditiveExpression_Exp(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeAdditiveExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeAdditiveExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeMultiplicativeExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof MultiplicativeExpression) {
            MultiplicativeExpression exp = (MultiplicativeExpression)model;
            EList nestedExpressions = exp.getExp();
            if (nestedExpressions.size() >= 1) {
                VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkUnaryExpression((UnaryExpression)nestedExpressions.get(nestedExpressions.size() - 1));
                Classifier specifiedType = (Classifier)validationResult.inferedType();
                String operator = (String)exp.getOp().get(exp.getOp().size() == 0 ? 0 : nestedExpressions.size() - 1);
                for (Type possibleType : (List)((Map)VSLJavaValidator.binaryOpTypeBinding.get(operator)).get(specifiedType)) {
                    Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)possibleType);
                    for (String s : allProposals.keySet()) {
                        String displayString;
                        String completionString;
                        if (!s.startsWith(context.getPrefix())) continue;
                        CustomCompletionProposal completionProposal = null;
                        if (allProposals.get(s) == null) {
                            completionString = s.substring(context.getPrefix().length());
                            displayString = s;
                            completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                        } else {
                            if (!s.contains("|")) {
                                completionString = s;
                                displayString = s;
                            } else {
                                completionString = s.substring(0, s.indexOf("|"));
                                displayString = s.substring(s.indexOf("|") + 1);
                            }
                            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                        }
                        acceptor.accept((ICompletionProposal)completionProposal);
                    }
                }
            }
        } else {
            super.completeMultiplicativeExpression_Exp(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeMultiplicativeExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeMultiplicativeExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeUnaryExpression_Op(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeUnaryExpression_Op(model, assignment, context, acceptor);
    }

    @Override
    public void completeUnaryExpression_Unary(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeUnaryExpression_Unary(model, assignment, context, acceptor);
    }

    @Override
    public void completeUnaryExpression_Exp(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeUnaryExpression_Exp(model, assignment, context, acceptor);
    }

    @Override
    public void completePrimaryExpression_Prefix(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completePrimaryExpression_Prefix(model, assignment, context, acceptor);
    }

    @Override
    public void completePrimaryExpression_Suffix(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completePrimaryExpression_Suffix(model, assignment, context, acceptor);
    }

    @Override
    public void completePropertyCallExpression_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Classifier classifierForScoping;
        if (model instanceof PrimaryExpression) {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            vSLScopeProvider.getClass();
            classifierForScoping = new VSLScopeProvider.ScopingHelper(vSLScopeProvider, (EObject)((PrimaryExpression)model).getPrefix()).getClassifierForScoping();
        } else {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            vSLScopeProvider.getClass();
            classifierForScoping = new VSLScopeProvider.ScopingHelper(vSLScopeProvider, model).getClassifierForScoping();
        }
        ArrayList<Property> allProperties = new ArrayList<Property>();
        if (classifierForScoping != null) {
            for (Feature f : classifierForScoping.allFeatures()) {
                if (!(f instanceof Property)) continue;
                allProperties.add((Property)f);
            }
        }
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(allProperties);
        SimpleScope scope = new SimpleScope(iterableIEobjectDescription);
        for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
            if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String displayString = eobjectDescription.getName() + " : " + (((Property)eobjectDescription.getEObjectOrProxy()).getType() != null ? ((Property)eobjectDescription.getEObjectOrProxy()).getType().getName() : "<Undefined>");
            String completionString = eobjectDescription.getName().getLastSegment();
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completePropertyCallExpression_Suffix(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completePropertyCallExpression_Suffix(model, assignment, context, acceptor);
    }

    @Override
    public void completeOperationCallExpression_Operation(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Classifier classifierForScoping;
        if (model instanceof PrimaryExpression) {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            vSLScopeProvider.getClass();
            classifierForScoping = new VSLScopeProvider.ScopingHelper(vSLScopeProvider, (EObject)((PrimaryExpression)model).getPrefix()).getClassifierForScoping();
        } else {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            vSLScopeProvider.getClass();
            classifierForScoping = new VSLScopeProvider.ScopingHelper(vSLScopeProvider, model).getClassifierForScoping();
        }
        ArrayList<Operation> allOperations = new ArrayList<Operation>();
        if (classifierForScoping != null) {
            for (Feature f : classifierForScoping.allFeatures()) {
                Operation o;
                if (!(f instanceof Operation) || (o = (Operation)f).getType() == null || o.getName().equals("<") || o.getName().equals(">") || o.getName().equals("<=") || o.getName().equals(">=") || o.getName().equals("==") || o.getName().equals("<>") || o.getName().equals("+") || o.getName().equals("-") || o.getName().equals("*") || o.getName().equals("/") || o.getName().equals("^")) continue;
                allOperations.add(o);
            }
        }
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(allOperations);
        SimpleScope scope = new SimpleScope(iterableIEobjectDescription);
        for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
            if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            Operation calledOperation = (Operation)eobjectDescription.getEObjectOrProxy();
            String displayString = VSLProposalUtils.buildDisplayStringForOperationCall(calledOperation);
            String completionString = VSLProposalUtils.buildCompletionStringForOperationCall(calledOperation);
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeOperationCallExpression_Arguments(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof OperationCallExpression)) {
            return;
        }
        Operation calledOperation = ((OperationCallExpression)model).getOperation();
        if (calledOperation != null) {
            Parameter firstParameter = null;
            Iterator allParameters = calledOperation.getOwnedParameters().iterator();
            while (allParameters.hasNext() && firstParameter == null) {
                Parameter currentParam = (Parameter)allParameters.next();
                if (currentParam.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                firstParameter = currentParam;
            }
            if (firstParameter != null) {
                Classifier expectedType = (Classifier)firstParameter.getType();
                Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType(expectedType);
                for (String s : allProposals.keySet()) {
                    String displayString;
                    String completionString;
                    if (!s.startsWith(context.getPrefix())) continue;
                    CustomCompletionProposal completionProposal = null;
                    if (allProposals.get(s) == null) {
                        completionString = s.substring(context.getPrefix().length());
                        displayString = s;
                        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                    } else {
                        if (!s.contains("|")) {
                            completionString = s;
                            displayString = s;
                        } else {
                            completionString = s.substring(0, s.indexOf("|"));
                            displayString = s.substring(s.indexOf("|") + 1);
                        }
                        completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                    }
                    acceptor.accept((ICompletionProposal)completionProposal);
                }
            }
        }
    }

    @Override
    public void completeOperationCallExpression_Suffix(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeOperationCallExpression_Suffix(model, assignment, context, acceptor);
    }

    @Override
    public void completeNameOrChoiceOrBehaviorCall_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeNameOrChoiceOrBehaviorCall_Path(model, assignment, context, acceptor);
    }

    @Override
    public void completeNameOrChoiceOrBehaviorCall_Id(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof NameOrChoiceOrBehaviorCall && ((NameOrChoiceOrBehaviorCall)model).getPath() != null) {
            IScope scope = VSLScopeProvider.eInstance.scope_NameOrChoiceOrBehaviorCall_id((NameOrChoiceOrBehaviorCall)model, VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id());
            for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
                if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
                boolean goOn = true;
                if (eobjectDescription.getEObjectOrProxy() instanceof Behavior) {
                    Behavior behavior = (Behavior)eobjectDescription.getEObjectOrProxy();
                    boolean behaviorHasAReturnType = false;
                    for (Parameter p : behavior.getOwnedParameters()) {
                        if (p.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
                        behaviorHasAReturnType = true;
                    }
                    goOn = behaviorHasAReturnType;
                }
                if (!goOn) continue;
                String displayString = eobjectDescription.getName().getLastSegment();
                String completionString = eobjectDescription.getName().getLastSegment();
                if (eobjectDescription.getEObjectOrProxy() instanceof Behavior) {
                    displayString = VSLProposalUtils.buildDisplayStringForBehaviorCall((Behavior)eobjectDescription.getEObjectOrProxy());
                    completionString = VSLProposalUtils.buildCompletionStringForBehaviorCall((Behavior)eobjectDescription.getEObjectOrProxy());
                }
                CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    @Override
    public void completeNameOrChoiceOrBehaviorCall_Arguments(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof NameOrChoiceOrBehaviorCall)) {
            return;
        }
        NamedElement cddBehavior = ((NameOrChoiceOrBehaviorCall)model).getId();
        if (cddBehavior == null || !(cddBehavior instanceof Behavior)) {
            return;
        }
        Behavior calledBehavior = (Behavior)cddBehavior;
        if (calledBehavior != null) {
            Parameter firstParameter = null;
            Iterator allParameters = calledBehavior.getOwnedParameters().iterator();
            while (allParameters.hasNext() && firstParameter == null) {
                Parameter currentParam = (Parameter)allParameters.next();
                if (currentParam.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                firstParameter = currentParam;
            }
            if (firstParameter != null) {
                Classifier expectedType = (Classifier)firstParameter.getType();
                Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType(expectedType);
                for (String s : allProposals.keySet()) {
                    String displayString;
                    String completionString;
                    if (!s.startsWith(context.getPrefix())) continue;
                    CustomCompletionProposal completionProposal = null;
                    if (allProposals.get(s) == null) {
                        completionString = s.substring(context.getPrefix().length());
                        displayString = s;
                        completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                    } else {
                        if (!s.contains("|")) {
                            completionString = s;
                            displayString = s;
                        } else {
                            completionString = s.substring(0, s.indexOf("|"));
                            displayString = s.substring(s.indexOf("|") + 1);
                        }
                        completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                    }
                    acceptor.accept((ICompletionProposal)completionProposal);
                }
            }
        }
    }

    @Override
    public void completeQualifiedName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeQualifiedName_Remaining(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof QualifiedName) {
            IScope scope = VSLScopeProvider.eInstance.scope_QualifiedName_remaining((QualifiedName)model, VSLPackage.eINSTANCE.getQualifiedName_Remaining());
            for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
                if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
                String displayString = eobjectDescription.getName() + "::";
                String completionString = eobjectDescription.getName() + "::";
                CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    @Override
    public void completeInterval_IsLowerIncluded(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeInterval_Lower(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeInterval_Lower(model, assignment, context, acceptor);
    }

    @Override
    public void completeInterval_Upper(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeInterval_Upper(model, assignment, context, acceptor);
    }

    @Override
    public void completeInterval_IsUpperIncluded(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeCollectionOrTuple_ListOfValues(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeCollectionOrTuple_ListOfValues(model, assignment, context, acceptor);
    }

    @Override
    public void completeTuple_ListOfValueNamePairs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeTuple_ListOfValueNamePairs(model, assignment, context, acceptor);
    }

    @Override
    public void completeListOfValues_Values(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof OperationCallExpression || model instanceof NameOrChoiceOrBehaviorCall || model instanceof CollectionOrTuple) {
            return;
        }
        INode node = context.getCurrentNode();
        IDocument document = context.getViewer().getDocument();
        char startChar = ' ';
        int openingListChar = 32;
        int rule = -1;
        if (model.eContainer() instanceof OperationCallExpression) {
            startChar = '.';
            openingListChar = 40;
            rule = 0;
        } else if (model.eContainer() instanceof NameOrChoiceOrBehaviorCall) {
            startChar = ' ';
            openingListChar = 40;
            rule = 1;
        } else if (model.eContainer() instanceof CollectionOrTuple) {
            startChar = ' ';
            openingListChar = 123;
            rule = 2;
        }
        try {
            Classifier expectedType = null;
            char[] completePrefix = document.get(0, node.getOffset()).toCharArray();
            boolean dotCallFound = false;
            boolean openingListCharFound = false;
            int i = completePrefix.length - 1;
            int positionInTheList = 0;
            int closingCharacters = 0;
            while (i > 0 && !dotCallFound) {
                char currentChar = completePrefix[i];
                if (currentChar == '(' || currentChar == '{') {
                    if (closingCharacters != 0) {
                        --closingCharacters;
                    } else {
                        openingListCharFound = true;
                    }
                } else if (currentChar == ')' || currentChar == '}') {
                    ++closingCharacters;
                } else if (currentChar == ',') {
                    if (closingCharacters == 0) {
                        ++positionInTheList;
                    }
                } else if (currentChar == startChar && openingListCharFound) {
                    dotCallFound = true;
                }
                --i;
            }
            if (openingListCharFound) {
                switch (rule) {
                    case 0: {
                        OperationCallExpression callOp = (OperationCallExpression)model.eContainer();
                        if (callOp.getOperation() == null || callOp.getOperation().getOwnedParameters() == null) {
                            return;
                        }
                        ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
                        for (Parameter p : callOp.getOperation().getOwnedParameters()) {
                            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                            operationParameters.add(p);
                        }
                        if (positionInTheList >= operationParameters.size()) break;
                        expectedType = (Classifier)((Parameter)operationParameters.get(positionInTheList)).getType();
                        break;
                    }
                    case 1: {
                        NameOrChoiceOrBehaviorCall callBehav = (NameOrChoiceOrBehaviorCall)model.eContainer();
                        NamedElement cddBehavior = callBehav.getId();
                        if (!(cddBehavior instanceof Behavior)) break;
                        Behavior behavior = (Behavior)cddBehavior;
                        if (behavior.getOwnedParameters() == null) {
                            return;
                        }
                        ArrayList<Parameter> behaviorParameters = new ArrayList<Parameter>();
                        for (Parameter p : behavior.getOwnedParameters()) {
                            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                            behaviorParameters.add(p);
                        }
                        if (positionInTheList >= behaviorParameters.size()) break;
                        expectedType = (Classifier)((Parameter)behaviorParameters.get(positionInTheList)).getType();
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                if (expectedType != null) {
                    Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType(expectedType);
                    for (String s : allProposals.keySet()) {
                        String displayString;
                        String completionString;
                        if (!s.startsWith(context.getPrefix())) continue;
                        CustomCompletionProposal completionProposal = null;
                        if (allProposals.get(s) == null) {
                            completionString = s.substring(context.getPrefix().length());
                            displayString = s;
                            completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                        } else {
                            if (!s.contains("|")) {
                                completionString = s;
                                displayString = s;
                            } else {
                                completionString = s.substring(0, s.indexOf("|"));
                                displayString = s.substring(s.indexOf("|") + 1);
                            }
                            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
                        }
                        acceptor.accept((ICompletionProposal)completionProposal);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void completeListOfValueNamePairs_ValueNamePairs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeListOfValueNamePairs_ValueNamePairs(model, assignment, context, acceptor);
    }

    @Override
    public void completeValueNamePair_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
        vSLScopeProvider.getClass();
        Classifier classifierForScoping = new VSLScopeProvider.ScopingHelper(vSLScopeProvider, model).getClassifierForScoping();
        if (!VSLContextUtil.isATupleType((Classifier)classifierForScoping)) {
            classifierForScoping = (Classifier)VSLJavaValidator._nfp_duration;
        }
        ArrayList<Property> allProperties = new ArrayList<Property>();
        for (Feature f : classifierForScoping.allFeatures()) {
            if (!(f instanceof Property)) continue;
            allProperties.add((Property)f);
        }
        ArrayList<Property> allReadySpecifiedProperties = new ArrayList<Property>();
        EObject cddContextListOfValueNamePairs = model;
        if (cddContextListOfValueNamePairs instanceof Tuple) {
            cddContextListOfValueNamePairs = ((Tuple)cddContextListOfValueNamePairs).getListOfValueNamePairs();
        }
        while (cddContextListOfValueNamePairs != null && !(cddContextListOfValueNamePairs instanceof ListOfValueNamePairs)) {
            cddContextListOfValueNamePairs = cddContextListOfValueNamePairs.eContainer();
        }
        if (cddContextListOfValueNamePairs != null) {
            ListOfValueNamePairs listOfValueNamePairs = (ListOfValueNamePairs)cddContextListOfValueNamePairs;
            for (ValueNamePair valueNamePair : listOfValueNamePairs.getValueNamePairs()) {
                if (valueNamePair.getProperty() == null) continue;
                allReadySpecifiedProperties.add(valueNamePair.getProperty());
            }
        }
        allProperties.removeAll(allReadySpecifiedProperties);
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(allProperties);
        SimpleScope scope = new SimpleScope(iterableIEobjectDescription);
        for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
            if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String displayString = eobjectDescription.getName() + " = ";
            String completionString = eobjectDescription.getName() + " = ";
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeValueNamePair_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model == null || !(model instanceof ValueNamePair)) {
            return;
        }
        ValueNamePair valueNamePairRuleRule = (ValueNamePair)model;
        if (valueNamePairRuleRule.getProperty() == null || valueNamePairRuleRule.getProperty().getType() == null) {
            return;
        }
        Property p = valueNamePairRuleRule.getProperty();
        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType((Classifier)p.getType());
        for (String s : allProposals.keySet()) {
            String displayString;
            String completionString;
            if (!s.startsWith(context.getPrefix())) continue;
            CustomCompletionProposal completionProposal = null;
            if (allProposals.get(s) == null) {
                completionString = s.substring(context.getPrefix().length());
                displayString = s;
                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
            } else {
                if (!s.contains("|")) {
                    completionString = s;
                    displayString = s;
                } else {
                    completionString = s.substring(0, s.indexOf("|"));
                    displayString = s.substring(s.indexOf("|") + 1);
                }
                completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(allProposals.get(s) != null && allProposals.get(s) instanceof NamedElement ? (NamedElement)allProposals.get(s) : null, (String)completionString, (String)displayString, (ContentAssistContext)context);
            }
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeInstantObsExpression_Id(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Element e : ScopingVisitors.recursivelyownedAndImportedInstantObservations.visit((Object)VSLJavaValidator.getModel())) {
            TimeObservation t = (TimeObservation)e;
            if (!t.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String displayString = t.getQualifiedName();
            String completionString = CompletionProposalUtils.getQualifiedNameLabelWithSufficientDepth((NamedElement)t, (Namespace)VSLJavaValidator.getModel());
            CustomCompletionProposal proposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)t, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    @Override
    public void completeInstantObsExpression_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeInstantObsExpression_Index(model, assignment, context, acceptor);
    }

    @Override
    public void completeInstantObsExpression_Condition(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeInstantObsExpression_Condition(model, assignment, context, acceptor);
    }

    @Override
    public void completeInstantObsName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeInstantObsName_InstantId(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof InstantObsName) {
            IScope scope = VSLScopeProvider.eInstance.scope_InstantObsName_instantId((InstantObsName)model, VSLPackage.eINSTANCE.getInstantObsName_InstantId());
            for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
                if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
                String displayString = eobjectDescription.getName().getLastSegment();
                String completionString = eobjectDescription.getName().getLastSegment();
                CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    @Override
    public void completeDurationObsExpression_Id(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Element e : ScopingVisitors.recursivelyownedAndImportedDurationObservations.visit((Object)VSLJavaValidator.getModel())) {
            DurationObservation d = (DurationObservation)e;
            if (!d.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String displayString = d.getQualifiedName();
            String completionString = CompletionProposalUtils.getQualifiedNameLabelWithSufficientDepth((NamedElement)d, (Namespace)VSLJavaValidator.getModel());
            CustomCompletionProposal proposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)d, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    @Override
    public void completeDurationObsExpression_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDurationObsExpression_Index(model, assignment, context, acceptor);
    }

    @Override
    public void completeDurationObsExpression_Condition(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDurationObsExpression_Condition(model, assignment, context, acceptor);
    }

    @Override
    public void completeDurationObsName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDurationObsName_Path(model, assignment, context, acceptor);
    }

    @Override
    public void completeDurationObsName_DurationId(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof DurationObsName) {
            IScope scope = VSLScopeProvider.eInstance.scope_DurationObsName_durationId((DurationObsName)model, VSLPackage.eINSTANCE.getDurationObsName_DurationId());
            for (IEObjectDescription eobjectDescription : scope.getAllElements()) {
                if (!eobjectDescription.getName().getLastSegment().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
                String displayString = eobjectDescription.getName().getLastSegment();
                String completionString = eobjectDescription.getName().getLastSegment();
                CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)eobjectDescription.getEObjectOrProxy()), (String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    @Override
    public void completeJitterExp_FirstInstant(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!context.getPrefix().equals("@")) {
            String displayString = "@";
            String completionString = "@";
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(null, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeJitterExp_SecondInstant(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!context.getPrefix().equals("@")) {
            String displayString = "@";
            String completionString = "@";
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix(null, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeVariableDeclaration_VariableDeclaration(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeVariableDeclaration_VariableDeclaration(model, assignment, context, acceptor);
    }

    @Override
    public void completeVariableDeclaration_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeVariableDeclaration_Name(model, assignment, context, acceptor);
    }

    @Override
    public void completeVariableDeclaration_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeVariableDeclaration_Type(model, assignment, context, acceptor);
    }

    @Override
    public void completeVariableDeclaration_InitValue(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeVariableDeclaration_InitValue(model, assignment, context, acceptor);
    }

    @Override
    public void completeDataTypeName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDataTypeName_Path(model, assignment, context, acceptor);
    }

    @Override
    public void completeDataTypeName_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDataTypeName_Type(model, assignment, context, acceptor);
    }

    @Override
    public void completeIntegerLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeIntegerLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeUnlimitedLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeUnlimitedLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeRealLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRealLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeDateTimeLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDateTimeLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeBooleanLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeBooleanLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeNullLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeNullLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeDefaultLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeDefaultLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void completeStringLiteralRule_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringLiteralRule_Value(model, assignment, context, acceptor);
    }

    @Override
    public void complete_Expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Expression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_AndOrXorExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_AndOrXorExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_EqualityExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_EqualityExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RelationalExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_RelationalExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_ConditionalExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ConditionalExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_AdditiveExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_AdditiveExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_MultiplicativeExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_MultiplicativeExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_UnaryExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_UnaryExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_PrimaryExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_PrimaryExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_ValueSpecification(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ValueSpecification(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_SuffixExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_SuffixExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_PropertyCallExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_PropertyCallExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_OperationCallExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_OperationCallExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_Literal(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Literal(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_NameOrChoiceOrBehaviorCall(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void complete_QualifiedName(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_QualifiedName(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_Interval(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Interval(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_CollectionOrTuple(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_CollectionOrTuple(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_Tuple(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Tuple(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_ListOfValues(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ListOfValues(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_ListOfValueNamePairs(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ListOfValueNamePairs(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_ValueNamePair(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_ValueNamePair(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_TimeExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TimeExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_InstantObsExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_InstantObsExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_InstantObsName(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_InstantObsName(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DurationObsExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DurationObsExpression(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DurationObsName(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DurationObsName(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_JitterExp(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_JitterExp(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_VariableDeclaration(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_VariableDeclaration(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_VariableDirectionKind(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_VariableDirectionKind(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DataTypeName(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DataTypeName(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_NumberLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_NumberLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_IntegerLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_IntegerLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_IntegerLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_IntegerLiteral(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_UnlimitedLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_UnlimitedLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RealLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_RealLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RealLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_RealLiteral(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DateTimeLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DateTimeLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DateTimeLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DateTimeLiteral(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_BooleanLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_BooleanLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_BooleanLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_BooleanLiteral(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_NullLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_NullLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_NullLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_NullLiteral(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_DefaultLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DefaultLiteralRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_StringLiteralRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_StringLiteralRule(model, ruleCall, context, acceptor);
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (!contentAssistContext.getPrefix().equals("") && keyword.getValue().startsWith(contentAssistContext.getPrefix())) {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }
}

