/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.xwt.IObservableValueListener;
import org.eclipse.papyrus.xwt.databinding.XWTObservableValue;
import org.eclipse.papyrus.xwt.internal.core.IEventController;
import org.eclipse.papyrus.xwt.internal.utils.LoggerManager;
import org.eclipse.papyrus.xwt.internal.utils.ObservableValueManager;
import org.eclipse.papyrus.xwt.internal.utils.UserData;
import org.eclipse.papyrus.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.papyrus.xwt.metadata.IEvent;
import org.eclipse.swt.widgets.Event;

public class EventPropertyObservableValue
extends XWTObservableValue {
    private EventProperty property;

    public EventPropertyObservableValue(Object observed, EventProperty property) {
        super(Boolean.class, observed, property.getName());
        this.property = property;
        IEventController controller = UserData.findEventController(observed);
        if (controller == null) {
            controller = UserData.updateEventController(observed);
        }
        IEvent event = property.getEvent();
        IObservableValueListener manager = UserData.getObservableValueManager(observed);
        if (manager == null) {
            manager = new ObservableValueManager(observed);
            UserData.setObservableValueManager(observed, manager);
        }
        try {
            controller.setEvent(event, UserData.getWidget(observed), manager, property, IObservableValueListener.class.getDeclaredMethod("changeValueHandle", Object.class, Event.class));
            manager.registerValue(property, (IObservableValue)this);
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return;
        }
    }

    protected void doSetApprovedValue(Object value) {
        UserData.setLocalData(this.getObserved(), this.property.getName(), value);
    }

    protected Object doGetValue() {
        return UserData.getLocalData(this.getObserved(), this.property.getName());
    }
}

