/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.types;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.yakindu.base.types.ITypeSystem;
import org.yakindu.base.types.ITypeSystemRegistry;

@Singleton
public class DefaultTypeSystemRegistry
implements ITypeSystemRegistry {
    private static final String EXTENSION_POINT_ID = "org.yakindu.base.types.typesystem";
    private static final String ITYPESYSTEM_CLASS = "typesystem";
    private static final String URI_SCHEME = "scheme";
    private Map<String, ITypeSystem> typeSystemRegistry = new HashMap<String, ITypeSystem>(3);

    public DefaultTypeSystemRegistry() {
        this.loadFromExtension();
    }

    @Override
    public ITypeSystem getTypeSystem(String uriScheme) {
        return this.typeSystemRegistry.get(uriScheme);
    }

    @Override
    public void addTypeSystem(String uriScheme, ITypeSystem system) {
        this.typeSystemRegistry.put(uriScheme, system);
    }

    @Override
    public void removeTypeSystem(String uriScheme) {
        this.typeSystemRegistry.remove(uriScheme);
    }

    protected void loadFromExtension() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                this.addTypeSystem(element.getAttribute(URI_SCHEME), (ITypeSystem)element.createExecutableExtension(ITYPESYSTEM_CLASS));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    @Override
    public Iterable<ITypeSystem> getAllTypeSystems() {
        return this.typeSystemRegistry.values();
    }
}

