/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.types;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.yakindu.base.types.AbstractTypeSystem;
import org.yakindu.base.types.ComplexType;
import org.yakindu.base.types.EnumerationType;
import org.yakindu.base.types.ITypeSystem;
import org.yakindu.base.types.InferenceIssue;
import org.yakindu.base.types.InferenceResult;
import org.yakindu.base.types.InferredType;
import org.yakindu.base.types.PrimitiveType;
import org.yakindu.base.types.Type;
import org.yakindu.base.types.TypeParameter;
import org.yakindu.base.types.TypesFactory;

@Singleton
public class DefaultTypeSystem
extends AbstractTypeSystem
implements ITypeSystem {
    public static final String COULD_NOT_INFER_A_TYPE_FOR_THE_OPERATION_NO_TYPE = "Could not infer a type for the operation %s, because no type was inferred for its operand.";
    public static final String COULD_NOT_INFER_A_TYPE_FOR_THE_OPERATION_NOT_INFERRED = "Could not infer a type for the operation %s, because types were not inferred for all of its operands.";
    public static final String OPERATOR_MAY_ONLY_BE_APPLIED_ON_A_PRIMITIVE_TYPE = "Operator %s may only be applied on a primitive type.";
    public static final String BITWISE_OPERATOR_MAY_ONLY_BE_APPLIED_ON_INTEGER_TYPES = "Bitwise operator '%s' may only be applied on integer types, not on %s.";
    public static final String BITWISE_OPERATOR_MAY_ONLY_BE_APPLIED_ON_INTEGER_TYPES_2 = "Bitwise operator '%s' may only be applied on integer types, not on %s and %s.";
    public static final String ARITHMETIC_OPERATORS_MAY_ONLY_BE_APPLIED_ON_NUMERIC_TYPES = "Arithmetic operator '%s' may only be applied on numeric types, not on %s";
    public static final String ARITHMETIC_OPERATORS_MAY_ONLY_BE_APPLIED_ON_NUMERIC_TYPES_2 = "Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.";
    public static final String LOGICAL_OPERATORS_MAY_ONLY_BE_APPLIED_ON_BOOLEAN_TYPES = "Logical operator '%s' may only be applied on boolean types, not on %s.";
    public static final String LOGICAL_OPERATORS_MAY_ONLY_BE_APPLIED_ON_BOOLEAN_TYPES_2 = "Logical operator '%s' may only be applied on boolean types, not on %s and %s.";
    public static final String COMPARSION_OPERATOR_MAY_ONLY_BE_APPLIED_ON_PRIMITIVE_TYPES = "Comparison operator '%s' may only be applied on primitive types, not on %s and %s.";
    public static final String COMPARSION_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES = "Comparison operator '%s' may only be applied on compatible types, not on %s and %s.";
    public static final String ASSIGNMENT_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES = "Assignment operator '%s' may only be applied on compatible types, not on %s and %s.";
    public static final String ASSIGNMENT_AND_EQUALITY_OPERATIONS_MAY_ONLY_BE_APPLIED_ON_TYPES_OF_THE_SAME_KIND = "Assignment and equality operations may only be applied on types of the same kind, not on %s and %s.";
    public static String NO_VALID_TYPE_CAN_BE_INFERRED_FOR_CONDITIONAL_EXPRESSION_BECAUSE_FIRST_OPERAND_NOT_BOOLEAN = "No valid type can be inferred for conditional expression, because type of first operand is not boolean.";
    public static String CANNOT_CAST_FROM_TO = "Cannot cast from %s to %s.";
    private static Resource resource;
    private static PrimitiveType voidType;
    private static PrimitiveType stringType;
    private static PrimitiveType realType;
    private static PrimitiveType integerType;
    private static PrimitiveType booleanType;
    private PrimitiveType nullType;

    protected static synchronized Resource getResource() {
        if (resource == null) {
            resource = new ResourceImpl();
            resource.setURI(URI.createURI((String)"platform:/plugin/org.yakindu.sct.model.stext/libraries/Primitives.types"));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getBooleanType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (booleanType == null) {
                booleanType = TypesFactory.eINSTANCE.createPrimitiveType();
                booleanType.setName("boolean");
                DefaultTypeSystem.getResource().getContents().add((Object)booleanType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return booleanType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getIntegerType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (integerType == null) {
                integerType = TypesFactory.eINSTANCE.createPrimitiveType();
                integerType.setName("integer");
                DefaultTypeSystem.getResource().getContents().add((Object)integerType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return integerType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getRealType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (realType == null) {
                realType = TypesFactory.eINSTANCE.createPrimitiveType();
                realType.setName("real");
                DefaultTypeSystem.getResource().getContents().add((Object)realType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return realType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getStringType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (stringType == null) {
                stringType = TypesFactory.eINSTANCE.createPrimitiveType();
                stringType.setName("string");
                DefaultTypeSystem.getResource().getContents().add((Object)stringType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return stringType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getVoidType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (voidType == null) {
                voidType = TypesFactory.eINSTANCE.createPrimitiveType();
                voidType.setName("void");
                DefaultTypeSystem.getResource().getContents().add((Object)voidType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return voidType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getNullType() {
        Class<DefaultTypeSystem> clazz = DefaultTypeSystem.class;
        synchronized (DefaultTypeSystem.class) {
            if (this.nullType == null) {
                this.nullType = TypesFactory.eINSTANCE.createPrimitiveType();
                this.nullType.setName("null");
                DefaultTypeSystem.getResource().getContents().add((Object)this.nullType);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nullType;
        }
    }

    @Override
    public InferenceResult inferTypeForLiteral(Object literal) {
        if (literal instanceof String) {
            return new InferenceResult(this.getStringType());
        }
        if (literal instanceof Boolean) {
            return new InferenceResult(this.getBooleanType());
        }
        if (literal instanceof Integer) {
            return new InferenceResult(this.getIntegerType());
        }
        if (literal instanceof Double) {
            return new InferenceResult(this.getRealType());
        }
        if (literal == null) {
            return new InferenceResult(this.getNullType());
        }
        throw new IllegalArgumentException("Literal of unknown kind " + literal);
    }

    @Override
    public InferenceResult inferType(InferredType operandType, ITypeSystem.ITypeSystemOperator unaryOperator) {
        if (operandType == null) {
            throw new NullPointerException("operandType may not be null.");
        }
        if (operandType.getType() == null) {
            return new InferenceResult(null, new InferenceIssue(String.format(COULD_NOT_INFER_A_TYPE_FOR_THE_OPERATION_NO_TYPE, unaryOperator.getSymbol()), 4));
        }
        if (!(operandType.getType() instanceof PrimitiveType)) {
            return new InferenceResult(null, new InferenceIssue(String.format(OPERATOR_MAY_ONLY_BE_APPLIED_ON_A_PRIMITIVE_TYPE, unaryOperator.getSymbol()), 4));
        }
        ITypeSystem.UnaryOperators o = (ITypeSystem.UnaryOperators)unaryOperator;
        switch (o) {
            case COMPLEMENT: {
                if (!this.isIntegerType(operandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(BITWISE_OPERATOR_MAY_ONLY_BE_APPLIED_ON_INTEGER_TYPES, o.getSymbol(), operandType.getType().getName()), 4));
                }
                return new InferenceResult(operandType);
            }
            case POSITIVE: 
            case NEGATIVE: {
                if (!this.isIntegerType(operandType.getType()) && !this.isRealType(operandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(ARITHMETIC_OPERATORS_MAY_ONLY_BE_APPLIED_ON_NUMERIC_TYPES, o.getSymbol(), operandType.getType().getName()), 4));
                }
                return new InferenceResult(operandType);
            }
            case LOGICAL_NOT: {
                if (!this.isBooleanType(operandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(LOGICAL_OPERATORS_MAY_ONLY_BE_APPLIED_ON_BOOLEAN_TYPES, o.getSymbol(), operandType.getType().getName()), 4));
                }
                return new InferenceResult(operandType);
            }
        }
        throw new IllegalArgumentException("Unsupported unary operator: " + unaryOperator);
    }

    @Override
    public InferenceResult inferType(InferredType firstOperandType, InferredType secondOperandType, ITypeSystem.ITypeSystemOperator binaryOperator) {
        if (firstOperandType == null || secondOperandType == null) {
            throw new NullPointerException("Operand types may not be null.");
        }
        if (firstOperandType.getType() == null || secondOperandType.getType() == null) {
            return new InferenceResult(null, new InferenceIssue(String.format(COULD_NOT_INFER_A_TYPE_FOR_THE_OPERATION_NOT_INFERRED, binaryOperator.getSymbol()), 4));
        }
        if (firstOperandType.getType() instanceof TypeParameter || secondOperandType.getType() instanceof TypeParameter) {
            return null;
        }
        ITypeSystem.BinaryOperators o = (ITypeSystem.BinaryOperators)binaryOperator;
        switch (o) {
            case BITWISE_OR: 
            case BITWISE_AND: 
            case BITWISE_XOR: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case ASSIGN_LEFT_SHIFT: 
            case ASSIGN_RIGHT_SHIFT: 
            case ASSIGN_BITWISE_AND: 
            case ASSIGN_BITWISE_XOR: 
            case ASSIGN_BITWISE_OR: {
                if (!this.isIntegerType(firstOperandType.getType()) || !this.isIntegerType(secondOperandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(BITWISE_OPERATOR_MAY_ONLY_BE_APPLIED_ON_INTEGER_TYPES_2, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                switch (o) {
                    case BITWISE_OR: 
                    case BITWISE_AND: 
                    case BITWISE_XOR: {
                        return this.union(firstOperandType, secondOperandType);
                    }
                    case LEFT_SHIFT: 
                    case RIGHT_SHIFT: 
                    case ASSIGN_LEFT_SHIFT: 
                    case ASSIGN_RIGHT_SHIFT: 
                    case ASSIGN_BITWISE_AND: 
                    case ASSIGN_BITWISE_XOR: 
                    case ASSIGN_BITWISE_OR: {
                        return new InferenceResult(firstOperandType);
                    }
                }
                throw new IllegalStateException("Unsupported operator kind.");
            }
            case MULTIPLY: 
            case DIV: 
            case MOD: 
            case ADD: 
            case SUBTRACT: {
                if (!this.isNumericType(firstOperandType.getType()) || !this.isNumericType(secondOperandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(ARITHMETIC_OPERATORS_MAY_ONLY_BE_APPLIED_ON_NUMERIC_TYPES_2, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                switch (o) {
                    case MULTIPLY: 
                    case DIV: 
                    case MOD: 
                    case ADD: 
                    case SUBTRACT: {
                        return this.union(firstOperandType, secondOperandType);
                    }
                    case ASSIGN_MULTIPLY: 
                    case ASSIGN_DIV: 
                    case ASSIGN_MOD: 
                    case ASSIGN_ADD: 
                    case ASSIGN_SUBTRACT: {
                        return new InferenceResult(firstOperandType);
                    }
                }
                throw new IllegalStateException("Unsupported operator kind.");
            }
            case ASSIGN_MULTIPLY: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_ADD: 
            case ASSIGN_SUBTRACT: {
                if (!EcoreUtil.equals((EObject)firstOperandType.getType(), (EObject)secondOperandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(ASSIGNMENT_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                switch (o) {
                    case MULTIPLY: 
                    case DIV: 
                    case MOD: 
                    case ADD: 
                    case SUBTRACT: {
                        return this.union(firstOperandType, secondOperandType);
                    }
                    case ASSIGN_MULTIPLY: 
                    case ASSIGN_DIV: 
                    case ASSIGN_MOD: 
                    case ASSIGN_ADD: 
                    case ASSIGN_SUBTRACT: {
                        return new InferenceResult(firstOperandType);
                    }
                }
                throw new IllegalStateException("Unsupported operator kind.");
            }
            case LOGICAL_OR: 
            case LOGICAL_AND: {
                if (!this.isBooleanType(firstOperandType.getType()) || !this.isBooleanType(secondOperandType.getType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(LOGICAL_OPERATORS_MAY_ONLY_BE_APPLIED_ON_BOOLEAN_TYPES_2, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                switch (o) {
                    case LOGICAL_OR: 
                    case LOGICAL_AND: {
                        return this.union(firstOperandType, secondOperandType);
                    }
                }
                throw new IllegalStateException("Unsupported operator kind.");
            }
            case SMALLER: 
            case SMALLER_EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: {
                if (!(firstOperandType.getType() instanceof PrimitiveType) || !(secondOperandType.getType() instanceof PrimitiveType)) {
                    return new InferenceResult(null, new InferenceIssue(String.format(COMPARSION_OPERATOR_MAY_ONLY_BE_APPLIED_ON_PRIMITIVE_TYPES, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                if (!(EcoreUtil.equals((EObject)this.getBaseType((PrimitiveType)firstOperandType.getType()), (EObject)this.getBaseType((PrimitiveType)secondOperandType.getType())) || this.isNumericType(firstOperandType.getType()) && this.isNumericType(secondOperandType.getType()))) {
                    return new InferenceResult(null, new InferenceIssue(String.format(COMPARSION_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES, o.getSymbol(), firstOperandType.getType(), secondOperandType.getType(), secondOperandType.getType().getName()), 4));
                }
                return new InferenceResult(new InferredType(this.getBooleanType()));
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case ASSIGN: {
                if (firstOperandType.getType() instanceof PrimitiveType && secondOperandType.getType() instanceof PrimitiveType) {
                    if (!EcoreUtil.equals((EObject)this.getBaseType((PrimitiveType)firstOperandType.getType()), (EObject)this.getBaseType((PrimitiveType)secondOperandType.getType()))) {
                        if (!this.isNumericType(firstOperandType.getType()) || !this.isNumericType(secondOperandType.getType())) {
                            return new InferenceResult(null, o.equals(ITypeSystem.BinaryOperators.ASSIGN) ? new InferenceIssue(String.format(ASSIGNMENT_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4) : new InferenceIssue(String.format(COMPARSION_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                        }
                        if (o.equals(ITypeSystem.BinaryOperators.ASSIGN) && !this.isRealType(firstOperandType.getType()) && this.isRealType(secondOperandType.getType())) {
                            return new InferenceResult(null, new InferenceIssue(String.format(ASSIGNMENT_OPERATOR_MAY_ONLY_BE_APPLIED_ON_COMPATIBLE_TYPES, o.getSymbol(), firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                        }
                    }
                } else if (!(firstOperandType.getType() instanceof ComplexType && secondOperandType.getType() instanceof ComplexType || firstOperandType.getType() == this.getNullType() && secondOperandType.getType() instanceof ComplexType || firstOperandType.getType() instanceof ComplexType && secondOperandType.getType() == this.getNullType())) {
                    return new InferenceResult(null, new InferenceIssue(String.format(ASSIGNMENT_AND_EQUALITY_OPERATIONS_MAY_ONLY_BE_APPLIED_ON_TYPES_OF_THE_SAME_KIND, firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                switch (o) {
                    case ASSIGN: {
                        return new InferenceResult(firstOperandType);
                    }
                    case EQUAL: 
                    case NOT_EQUAL: {
                        return new InferenceResult(new InferredType(this.getBooleanType()));
                    }
                }
                throw new IllegalStateException("Unsupported operator kind.");
            }
            case CAST: {
                if (!(!(firstOperandType.getType() instanceof PrimitiveType) || !(secondOperandType.getType() instanceof PrimitiveType) || EcoreUtil.equals((EObject)firstOperandType.getType(), (EObject)secondOperandType.getType()) || this.isNumericType(firstOperandType) && this.isNumericType(secondOperandType))) {
                    return new InferenceResult(null, new InferenceIssue(String.format(CANNOT_CAST_FROM_TO, firstOperandType.getType().getName(), secondOperandType.getType().getName()), 4));
                }
                return new InferenceResult(secondOperandType);
            }
        }
        throw new IllegalArgumentException("Unsupported binary operator: " + binaryOperator);
    }

    @Override
    public InferenceResult inferType(InferredType firstOperandType, InferredType secondOperandType, InferredType thirdOperandType, ITypeSystem.ITypeSystemOperator ternaryOperator) {
        if (firstOperandType == null || secondOperandType == null || thirdOperandType == null) {
            throw new NullPointerException("Operand types may not be null");
        }
        if (firstOperandType.getType() == null || secondOperandType.getType() == null || thirdOperandType.getType() == null) {
            return new InferenceResult(null, new InferenceIssue(String.format(COULD_NOT_INFER_A_TYPE_FOR_THE_OPERATION_NOT_INFERRED, ternaryOperator.getSymbol()), 4));
        }
        ITypeSystem.TernaryOperators o = (ITypeSystem.TernaryOperators)ternaryOperator;
        switch (o) {
            case CONDITIONAL: {
                ArrayList<InferenceIssue> issues = new ArrayList<InferenceIssue>();
                if (!this.isBooleanType(firstOperandType.getType())) {
                    issues.add(new InferenceIssue(NO_VALID_TYPE_CAN_BE_INFERRED_FOR_CONDITIONAL_EXPRESSION_BECAUSE_FIRST_OPERAND_NOT_BOOLEAN, 4));
                }
                InferenceResult unionResult = this.union(secondOperandType, thirdOperandType);
                unionResult.getIssues().addAll(issues);
                return unionResult;
            }
        }
        throw new IllegalArgumentException("Unsupported ternary operator: " + ternaryOperator);
    }

    public InferenceResult union(InferredType firstType, InferredType secondType) {
        if (firstType == null || secondType == null) {
            throw new NullPointerException("firstType and secondType may not be null.");
        }
        if (firstType.getType() == null || secondType.getType() == null) {
            return new InferenceResult(null, new InferenceIssue("Could not infer a type union, because not all given types were properly inferred in advance.", 4));
        }
        if (firstType.getType() instanceof PrimitiveType && secondType.getType() instanceof PrimitiveType) {
            Type commonType = this.computeCommonType((PrimitiveType)firstType.getType(), (PrimitiveType)secondType.getType());
            if (commonType != null) {
                return new InferenceResult(new InferredType(commonType));
            }
            if (this.isNumericType(firstType) && this.isNumericType(secondType)) {
                if (this.isRealType(firstType)) {
                    return new InferenceResult(firstType);
                }
                return new InferenceResult(secondType);
            }
        }
        return new InferenceResult(null, new InferenceIssue("Cannot compute a type union for the given types: " + firstType + ", " + secondType, 4));
    }

    @Override
    public List<Type> getTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(this.getVoidType());
        types.add(this.getBooleanType());
        types.add(this.getIntegerType());
        types.add(this.getRealType());
        types.add(this.getStringType());
        types.add(this.getNullType());
        return types;
    }

    @Override
    public boolean isVoidType(Type type) {
        return EcoreUtil.equals((EObject)this.getVoidType(), (EObject)type);
    }

    @Override
    public boolean isVoidType(InferredType type) {
        return this.isVoidType(type.getType());
    }

    @Override
    public boolean isBooleanType(InferredType type) {
        return this.isBooleanType(type.getType());
    }

    @Override
    public boolean isBooleanType(Type type) {
        return EcoreUtil.equals((EObject)this.getBooleanType(), (EObject)type);
    }

    @Override
    public boolean isRealType(Type type) {
        return EcoreUtil.equals((EObject)this.getRealType(), (EObject)type);
    }

    @Override
    public boolean isRealType(InferredType type) {
        return this.isRealType(type.getType());
    }

    @Override
    public boolean isIntegerType(Type type) {
        return EcoreUtil.equals((EObject)this.getIntegerType(), (EObject)type);
    }

    @Override
    public boolean isIntegerType(InferredType type) {
        return this.isIntegerType(type.getType());
    }

    @Override
    public boolean isStringType(Type type) {
        return EcoreUtil.equals((EObject)this.getStringType(), (EObject)type);
    }

    @Override
    public boolean isStringType(InferredType type) {
        return this.isStringType(type.getType());
    }

    public boolean isNumericType(Type type) {
        PrimitiveType baseType;
        boolean isNumeric;
        boolean bl = isNumeric = EcoreUtil.equals((EObject)this.getIntegerType(), (EObject)type) || EcoreUtil.equals((EObject)this.getRealType(), (EObject)type);
        if (!isNumeric && type instanceof PrimitiveType && (baseType = ((PrimitiveType)type).getBaseType()) != null) {
            return this.isNumericType(baseType);
        }
        return isNumeric;
    }

    public boolean isNumericType(InferredType type) {
        return this.isNumericType(type.getType());
    }

    @Override
    public Object defaultValue(Type type) {
        if (this.isBooleanType(type)) {
            return true;
        }
        if (this.isIntegerType(type)) {
            return 0L;
        }
        if (this.isRealType(type)) {
            return 0.0;
        }
        if (this.isVoidType(type)) {
            return null;
        }
        if (this.isStringType(type)) {
            return "\"\"";
        }
        if (type instanceof EnumerationType) {
            return ((EnumerationType)type).getEnumerator().get(0);
        }
        if (type instanceof ComplexType) {
            return "{}";
        }
        return null;
    }

    @Override
    public Object defaultValue(InferredType type) {
        return this.defaultValue(type.getType());
    }
}

