/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import java.util.StringTokenizer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypePropertiesEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static String APPLIED_STEREOTYPE_VISIBILITY_COMPARTMENT = "AppliedStereotypeVisibilityEditPolicy";

    protected Element getUMLElement() {
        return (Element)((View)this.getView().eContainer()).getElement();
    }

    protected View getView() {
        return (View)((EObject)this.getHost().getModel()).eContainer();
    }

    protected void executeAppliedStereotypePropertytCreation(final GraphicalEditPart editPart, final String stereotypesPropertiesToDisplay, final View node, final Stereotype stereotype) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
                            while (propStringTokenizer.hasMoreElements()) {
                                String propertyQN = propStringTokenizer.nextToken();
                                if (!propertyQN.startsWith(stereotype.getQualifiedName())) continue;
                                String propertyName = propertyQN.substring(propertyQN.lastIndexOf(".") + 1);
                                Property stereotypeProperty = StereotypeUtil.getPropertyByName((Stereotype)stereotype, (String)propertyName);
                                if (stereotypeProperty == null) {
                                    return;
                                }
                                Node sterotypePropertyNode = null;
                                int i = 0;
                                while (i < node.getChildren().size() && sterotypePropertyNode == null) {
                                    Node currentNode;
                                    if (node.getChildren().get(i) instanceof Node && "AppliedStereotypeProperty".equals((currentNode = (Node)node.getChildren().get(i)).getType()) && stereotypeProperty.equals(currentNode.getElement())) {
                                        sterotypePropertyNode = currentNode;
                                    }
                                    ++i;
                                }
                                if (sterotypePropertyNode != null) continue;
                                CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), editPart.getNotationView(), stereotypeProperty);
                                try {
                                    GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                                }
                                catch (Exception e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof Node && notification.getEventType() == 3 && notification.getNewValue() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNewValue()).getSource()) {
            this.refreshDisplay();
        }
    }

    protected void refreshEAnnotation() {
        final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)editPart.getNotationView().eContainer()));
        EObject stereotypeApplication = editPart.resolveSemanticElement();
        Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
        final RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)editPart.getEditingDomain(), (EModelElement)editPart.getNotationView(), (String)stereotype.getQualifiedName(), (String)presentationKind);
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            editPart.getEditingDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void refreshStereotypeDisplay() {
    }

    public void refreshDisplay() {
        if (((View)this.getHost().getModel()).eContainer() != null) {
            String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)((View)((View)this.getHost().getModel()).eContainer()));
            final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
            View node = editPart.getNotationView();
            EObject stereotypeApplication = editPart.resolveSemanticElement();
            Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
            if (stereotype != null) {
                this.executeAppliedStereotypePropertytCreation(editPart, stereotypesPropertiesToDisplay, node, stereotype);
                this.manageRemovingPropertiesNodes(stereotypesPropertiesToDisplay, editPart, node, stereotype);
            } else {
                try {
                    editPart.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            Display.getCurrent().syncExec(new Runnable(){

                                public void run() {
                                    DeleteCommand command = new DeleteCommand((View)AppliedStereotypePropertiesEditPolicy.this.getHost().getModel());
                                    try {
                                        GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (ICommand)command);
                                    }
                                    catch (Exception e) {
                                        System.err.println(e);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
    }

    protected void manageRemovingPropertiesNodes(String stereotypesPropertiesToDisplay, final GraphicalEditPart editPart, View node, Stereotype stereotype) {
        int i = 0;
        while (i < node.getChildren().size()) {
            Node currentNode;
            if (node.getChildren().get(i) instanceof Node && (currentNode = (Node)node.getChildren().get(i)).getType().equals("AppliedStereotypeProperty")) {
                Property property = (Property)currentNode.getElement();
                String propertyQN = String.valueOf(stereotype.getQualifiedName()) + "." + property.getName();
                if (!stereotypesPropertiesToDisplay.contains(propertyQN)) {
                    try {
                        editPart.getEditingDomain().runExclusive(new Runnable(){

                            public void run() {
                                Display.getCurrent().syncExec(new Runnable(){

                                    public void run() {
                                        if (currentNode.eContainer() != null) {
                                            DeleteCommand command = new DeleteCommand((View)currentNode);
                                            try {
                                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (ICommand)command);
                                            }
                                            catch (Exception e) {
                                                System.err.println(e);
                                            }
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
            }
            ++i;
        }
    }
}

